/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras.hpel;

import com.ibm.websphere.logging.hpel.reader.HpelFormatter;
import com.ibm.ws.logging.hpel.handlers.LogRecordHandler;
import com.ibm.ws.logging.hpel.impl.LogRepositoryBaseImpl;
import com.ibm.ws.logging.hpel.impl.LogRepositoryManagerImpl;
import com.ibm.ws.logging.hpel.impl.LogRepositoryWriterImpl;
import com.ibm.ws.logging.object.hpel.LogRecordStack;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.WriteAbortedException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.rmi.server.ServerCloneException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.xml.sax.SAXException;

public class HpelHelper {
    private static final String CLASS_NAME = HpelHelper.class.getName();
    private static final Logger log = Logger.getLogger(CLASS_NAME);
    static final long EMPTY_FILE_CHECK_SLEEP = 1000L;
    static final int EMPTY_FILE_CHECK_COUNT = 3;
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final boolean useJULThreadId = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.parseBoolean(System.getProperty("com.ibm.websphere.logging.useJULThreadID", "false"));
        }
    });
    private static String os = HpelHelper.getSystemProperty("os.name").trim();
    private static boolean isZOS = os.equals("OS/390") || os.equals("z/OS");
    private static String processId = "";
    private static Properties customProps;
    private static String[] customFormat;
    private static TimeZone sysTimeZone;

    public static void setCustomHeaderProperties(Properties properties) {
        customProps = properties;
    }

    public static void setCustomHeaderFormat(String[] headerFormat) {
        customFormat = new String[headerFormat.length];
        System.arraycopy(headerFormat, 0, customFormat, 0, headerFormat.length);
    }

    public static void setPid(String pid) {
        processId = pid == null ? processId : pid;
    }

    public static Properties getHeaderAsProperties() {
        Properties result = new Properties();
        if (customProps != null) {
            result.putAll((Map<?, ?>)customProps);
        }
        result.put("ProcessId", processId);
        result.put("ServerTimeZone", TimeZone.getDefault().getID());
        result.put("ServerLocaleLanguageCode", Locale.getDefault().getLanguage());
        result.put("ServerLocaleCountryCode", Locale.getDefault().getCountry());
        HpelHelper.addSystemPropertyIfPresent(result, "java.fullversion");
        HpelHelper.addSystemPropertyIfPresent(result, "java.version");
        HpelHelper.addSystemPropertyIfPresent(result, "os.name");
        HpelHelper.addSystemPropertyIfPresent(result, "os.version");
        HpelHelper.addSystemPropertyIfPresent(result, "java.compiler");
        HpelHelper.addSystemPropertyIfPresent(result, "java.vm.name");
        HpelHelper.addSystemPropertyIfPresent(result, "java.home");
        HpelHelper.addSystemPropertyIfPresent(result, "java.class.path");
        HpelHelper.addSystemPropertyIfPresent(result, "java.library.path");
        HpelHelper.addSystemPropertyIfPresent(result, "wlp.install.dir");
        HpelHelper.addSystemPropertyIfPresent(result, "server.config.dir");
        HpelHelper.addSystemPropertyIfPresent(result, "os.arch");
        HpelHelper.addIfPresent(result, "isZOS", isZOS ? "Y" : null);
        return result;
    }

    public static final String throwableToString(Throwable t) {
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        HpelHelper.printStackTrace(t, p);
        return HpelHelper.escape(s.toString());
    }

    public static Handler getHpelHandler(String repositoryLoc, String pid, String label, boolean useDirTree, Properties overrideProps) {
        LogRecordHandler handler = null;
        String methodName = "getHpelHandler";
        try {
            handler = new LogRecordHandler(Level.OFF.intValue(), LogRepositoryBaseImpl.KNOWN_FORMATTERS[0], overrideProps);
            File repositoryLocation = new File(repositoryLoc + "logdata");
            LogRepositoryManagerImpl manager = new LogRepositoryManagerImpl(repositoryLocation, pid, label, useDirTree);
            LogRepositoryWriterImpl logWriter = new LogRepositoryWriterImpl(manager);
            handler.setLogWriter(logWriter);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, methodName, "Error in setting up handler: " + e);
            }
            return null;
        }
        return handler;
    }

    private static final void printStackTrace(Throwable t, PrintWriter p) {
        if (t == null) {
            p.println("none");
            return;
        }
        try {
            t.printStackTrace(p);
        }
        catch (Throwable e) {
            p.println("<Encountered exception while printing stack trace>");
            p.println(e.getClass().getName() + ": " + e.getMessage());
            return;
        }
        boolean autoRecursion = true;
        Throwable tNext = null;
        try {
            while (autoRecursion) {
                tNext = t.getCause();
                if (tNext != null) {
                    t = tNext;
                    continue;
                }
                tNext = HpelHelper.getNestedThrowable(t);
                if (tNext == null) {
                    return;
                }
                if (HpelHelper.pstRecursesOnNested(t)) {
                    t = tNext;
                    continue;
                }
                autoRecursion = false;
            }
        }
        catch (Throwable e) {
            p.println("<Encountered exception while calculating a nested throwable>");
            p.println(e.getClass().getName() + ": " + e.getMessage());
            try {
                e.printStackTrace(p);
            }
            catch (Throwable e2) {
                p.println("<Caught exception while printing stack trace from failed nested calculation>");
                p.println(e2.getClass().getName() + ": " + e2.getMessage());
            }
            return;
        }
        p.println("---- Begin backtrace for Nested Throwables");
        HpelHelper.printStackTrace(tNext, p);
    }

    public static String getThreadId() {
        if (useJULThreadId) {
            LogRecord logRecord = new LogRecord(Level.FINE, "x");
            return HpelHelper.getThreadId(logRecord);
        }
        return HpelHelper.threadIdToString(HpelHelper.getIntThreadId());
    }

    public static String getThreadId(LogRecord logRecord) {
        return HpelHelper.threadIdToString(logRecord.getThreadID());
    }

    public static String threadIdToString(int threadId) {
        StringBuffer buffer = new StringBuffer(8);
        for (int shift = 7; shift >= 0; --shift) {
            buffer.append(hexChars[threadId >> (shift << 2) & 0xF]);
        }
        return buffer.toString();
    }

    public static int getActiveThreadId(LogRecord logRecord) {
        if (useJULThreadId) {
            return logRecord.getThreadID();
        }
        return LogRecordStack.getThreadID();
    }

    public static int getIntThreadId() {
        return useJULThreadId ? -1 : (int)(Thread.currentThread().getId() & 0xFFFFFFFFFFFFFFFFL);
    }

    private static void addIfPresent(Properties result, String key, String value) {
        if (value != null) {
            result.put(key, value);
        }
    }

    private static void addSystemPropertyIfPresent(Properties result, String systemProperty) {
        HpelHelper.addIfPresent(result, systemProperty, HpelHelper.getSystemProperty(systemProperty));
    }

    private static final String escape(String src) {
        if (src == null) {
            return "";
        }
        StringBuffer result = null;
        int max = src.length();
        int delta = 0;
        for (int i = 0; i < max; ++i) {
            char c = src.charAt(i);
            if ((Character.isWhitespace(c) || !Character.isISOControl(c)) && Character.getType(c) != 0) continue;
            String hexVal = Integer.toHexString(c);
            String replacement = "\\u" + ("0000" + hexVal).substring(hexVal.length());
            if (result == null) {
                result = new StringBuffer(src);
            }
            result.replace(i + delta, i + delta + 1, replacement);
            delta += replacement.length() - 1;
        }
        if (result == null) {
            return src;
        }
        return result.toString();
    }

    private static final Throwable getNestedThrowable(Throwable t) {
        Class<?> cName = t.getClass();
        if (cName.getName().equals("org.omg.CORBA.portable.UnknownException")) {
            return (Throwable)HpelHelper.getFieldValue(t, "originalEx");
        }
        if (t instanceof RemoteException) {
            return ((RemoteException)t).detail;
        }
        if (t instanceof InvocationTargetException) {
            return ((InvocationTargetException)t).getTargetException();
        }
        if (t instanceof NamingException) {
            return ((NamingException)t).getRootCause();
        }
        if (cName.getName().equals("javax.ejb.EJBException")) {
            return HpelHelper.invokeMethod(t, "getCausedByException");
        }
        if (t instanceof SQLException) {
            return ((SQLException)t).getNextException();
        }
        if (cName.getName().equals("javax.mail.MessagingException")) {
            return HpelHelper.invokeMethod(t, "getNextException");
        }
        if (cName.getName().equals("org.xml.sax.SAXException")) {
            return HpelHelper.invokeMethod(t, "getException");
        }
        if (cName.getName().equals("javax.servlet.jsp.JspException")) {
            return HpelHelper.invokeMethod(t, "getCause");
        }
        if (cName.getName().equals("javax.servlet.ServletException")) {
            return HpelHelper.invokeMethod(t, "getRootCause");
        }
        if (cName.getName().equals("javax.resource.ResourceException")) {
            return HpelHelper.invokeMethod(t, "getCause");
        }
        if (cName.getName().equals("javax.jms.JMSException")) {
            return HpelHelper.invokeMethod(t, "getLinkedException");
        }
        if (t instanceof UndeclaredThrowableException) {
            return ((UndeclaredThrowableException)t).getUndeclaredThrowable();
        }
        if (t instanceof WriteAbortedException) {
            return ((WriteAbortedException)t).detail;
        }
        if (t instanceof ServerCloneException) {
            return ((ServerCloneException)t).detail;
        }
        if (t instanceof PrivilegedActionException) {
            return ((PrivilegedActionException)t).getException();
        }
        return null;
    }

    private static Throwable invokeMethod(Throwable t, String exceptionMethod) {
        Object obj;
        block9: {
            Class<?> cName = t.getClass();
            String methodName = "invokeMethod";
            obj = null;
            try {
                Method method = HpelHelper.getMethod(cName, exceptionMethod);
                if (method != null) {
                    obj = method.invoke((Object)t, null);
                }
            }
            catch (IllegalArgumentException e) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, methodName, "The method " + exceptionMethod + " is not an member of the " + cName);
                }
            }
            catch (IllegalAccessException e) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, methodName, "The " + cName + " does not have access to the method " + exceptionMethod);
                }
            }
            catch (InvocationTargetException e) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, methodName, "The method threw an exception " + e.getMessage());
                }
            }
            catch (Throwable e) {
                if (!log.isLoggable(Level.FINE)) break block9;
                log.logp(Level.FINE, CLASS_NAME, methodName, "The method threw an exception " + e.getMessage());
            }
        }
        return (Throwable)obj;
    }

    public static Method getMethod(final Class cName, final String exceptionMethod) {
        Method method;
        block2: {
            method = null;
            try {
                method = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws Exception {
                        return cName.getMethod(exceptionMethod, null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (!log.isLoggable(Level.FINE)) break block2;
                log.logp(Level.FINE, CLASS_NAME, exceptionMethod, "PrivilegedActionException Cause " + e.getMessage());
            }
        }
        return method;
    }

    private static Object getFieldValue(Throwable t, String fieldName) {
        Object obj;
        block3: {
            obj = null;
            try {
                Field field = HpelHelper.getField(t.getClass(), fieldName);
                if (field != null) {
                    obj = field.get(t);
                }
            }
            catch (Throwable e) {
                if (!log.isLoggable(Level.FINE)) break block3;
                log.logp(Level.FINE, CLASS_NAME, fieldName, "The Field.get threw an exception " + e);
            }
        }
        return obj;
    }

    private static Field getField(final Class<?> klass, final String fieldName) {
        Field field;
        block2: {
            field = null;
            try {
                field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                    @Override
                    public Field run() throws Exception {
                        return klass.getField(fieldName);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (!log.isLoggable(Level.FINE)) break block2;
                log.logp(Level.FINE, CLASS_NAME, "getField", "PrivilegedActionException Cause " + e.getCause());
            }
        }
        return field;
    }

    public static String getSystemProperty(String propName) {
        final String temp = propName;
        try {
            String prop = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(temp);
                }
            });
            return prop;
        }
        catch (SecurityException se) {
            return null;
        }
    }

    private static final boolean pstRecursesOnNested(Throwable t) {
        Class<?> cName = t.getClass();
        if (cName.getName() != null && cName.getName().equals("org.omg.CORBA.portable.UnknownException")) {
            return false;
        }
        if (cName.getName() != null && cName.getName().equals("javax.mail.MessagingException")) {
            return false;
        }
        if (t instanceof SAXException) {
            return false;
        }
        if (cName.getName() != null && cName.getName().equals("javax.servlet.jsp.JspException")) {
            return false;
        }
        if (cName.getName() != null && cName.getName().equals("javax.servlet.ServletException")) {
            return false;
        }
        if (t instanceof NamingException) {
            return false;
        }
        if (t instanceof SQLException) {
            return false;
        }
        return cName.getName() == null || !cName.getName().equals("javax.jms.JMSException");
    }

    public static String getProcessId() {
        return processId;
    }

    public static void printHeader(PrintStream ps, Properties p) {
        HpelFormatter formatter = HpelFormatter.getFormatter("Basic");
        if (customFormat != null) {
            formatter.setCustomHeader(customFormat);
        }
        formatter.setHeaderProps(p);
        for (String line : formatter.getHeader()) {
            ps.println(line);
        }
    }

    static DateFormat getBasicDateFormatter() {
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
        if (formatter instanceof SimpleDateFormat) {
            SimpleDateFormat sdFormatter = (SimpleDateFormat)formatter;
            String pattern = sdFormatter.toPattern();
            int patternLength = pattern.length();
            int endOfSecsIndex = pattern.lastIndexOf(115) + 1;
            String newPattern = pattern.substring(0, endOfSecsIndex) + ":SSS z";
            if (endOfSecsIndex < patternLength) {
                newPattern = newPattern + pattern.substring(endOfSecsIndex, patternLength);
            }
            newPattern = newPattern.replace('h', 'H');
            newPattern = newPattern.replace('K', 'H');
            newPattern = newPattern.replace('k', 'H');
            newPattern = newPattern.replace('a', ' ');
            newPattern = newPattern.trim();
            sdFormatter.applyPattern(newPattern);
            formatter = sdFormatter;
        } else {
            formatter = new SimpleDateFormat("yy.MM.dd HH:mm:ss:SSS z");
        }
        if (sysTimeZone != null) {
            formatter.setTimeZone(sysTimeZone);
        }
        return formatter;
    }

    static {
        sysTimeZone = TimeZone.getDefault();
    }

    public static class OwnershipServerException
    extends Exception {
        private static final long serialVersionUID = -2499557857950787416L;

        OwnershipServerException(String otherServer) {
            super(otherServer);
        }
    }

    public static class OwnershipDirectoryException
    extends Exception {
        private static final long serialVersionUID = -5222218174834106488L;

        OwnershipDirectoryException(String ownerFile) {
            super(ownerFile);
        }
    }
}

