/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.AutoValue_HttpClientMetrics_State;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpMetricsAdvice;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpMetricsUtil;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import jakarta.annotation.Nullable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpClientMetrics
implements OperationListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final double NANOS_PER_S = TimeUnit.SECONDS.toNanos(1L);
    private static final ContextKey<State> HTTP_CLIENT_REQUEST_METRICS_STATE = ContextKey.named("http-client-metrics-state");
    private static final Logger logger = Logger.getLogger(HttpClientMetrics.class.getName());
    @Nullable
    private final DoubleHistogram stableDuration;
    @Nullable
    private final DoubleHistogram oldDuration;

    public static OperationMetrics get() {
        return HttpClientMetrics::new;
    }

    private HttpClientMetrics(Meter meter) {
        if (SemconvStability.emitStableHttpSemconv()) {
            DoubleHistogramBuilder stableDurationBuilder = HttpMetricsUtil.createStableDurationHistogramBuilder(meter, "http.client.request.duration", "Duration of HTTP client requests.");
            HttpMetricsAdvice.applyStableClientDurationAdvice(stableDurationBuilder);
            this.stableDuration = stableDurationBuilder.build();
        } else {
            this.stableDuration = null;
        }
        if (SemconvStability.emitOldHttpSemconv()) {
            DoubleHistogramBuilder oldDurationBuilder = meter.histogramBuilder("http.client.duration").setUnit("ms").setDescription("The duration of the outbound HTTP request");
            HttpMetricsAdvice.applyOldClientDurationAdvice(oldDurationBuilder);
            this.oldDuration = oldDurationBuilder.build();
        } else {
            this.oldDuration = null;
        }
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(HTTP_CLIENT_REQUEST_METRICS_STATE, new AutoValue_HttpClientMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        State state = context.get(HTTP_CLIENT_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        Attributes attributes = state.startAttributes().toBuilder().putAll(endAttributes).build();
        if (this.stableDuration != null) {
            this.stableDuration.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_S, attributes, context);
        }
        if (this.oldDuration != null) {
            this.oldDuration.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS, attributes, context);
        }
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

