/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.classloading.ClassLoaderIdentifierService;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.metadata.ComponentMetaDataListener;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.container.service.metadata.extended.DeferredMetaDataFactory;
import com.ibm.ws.container.service.metadata.extended.IdentifiableComponentMetaData;
import com.ibm.ws.container.service.metadata.extended.MetaDataIdentifierService;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.ModuleStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.wsspi.logging.Introspector;
import com.ibm.wsspi.persistence.DDLGenerationParticipant;
import com.ibm.wsspi.resource.ResourceConfigFactory;
import com.ibm.wsspi.resource.ResourceFactory;
import io.openliberty.cdi.spi.CDIExtensionMetadata;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import io.openliberty.data.internal.persistence.EntityInfo;
import io.openliberty.data.internal.persistence.QueryInfo;
import io.openliberty.data.internal.persistence.RepositoryImpl;
import io.openliberty.data.internal.persistence.Util;
import io.openliberty.data.internal.persistence.cdi.DataExtension;
import io.openliberty.data.internal.persistence.cdi.FutureEMBuilder;
import io.openliberty.data.internal.persistence.cdi.RepositoryProducer;
import io.openliberty.data.internal.persistence.metadata.DataComponentMetaData;
import io.openliberty.data.internal.persistence.metadata.DataModuleMetaData;
import io.openliberty.data.internal.version.DataVersionCompatibility;
import jakarta.data.Limit;
import jakarta.data.Order;
import jakarta.data.Sort;
import jakarta.data.page.Page;
import jakarta.data.page.PageRequest;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.persistence.EntityManagerFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import javax.sql.DataSource;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"io.openliberty.data"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, service={CDIExtensionMetadata.class, DataProvider.class, DeferredMetaDataFactory.class, ApplicationStateListener.class, ComponentMetaDataListener.class, Introspector.class, ModuleMetaDataListener.class, ModuleStateListener.class}, property={"deferredMetaData=DATA"})
public class DataProvider
implements CDIExtensionMetadata,
DeferredMetaDataFactory,
ApplicationStateListener,
ComponentMetaDataListener,
Introspector,
ModuleMetaDataListener,
ModuleStateListener {
    private static final TraceComponent tc = Tr.register(DataProvider.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private static final Set<Class<?>> beanClasses = Set.of(DataSource.class, EntityManagerFactory.class);
    private static final Set<Class<? extends Extension>> extensions = Collections.singleton(DataExtension.class);
    private static final int MAX_OUTPUT = 20;
    public final CDIService cdiService;
    public final ClassLoaderIdentifierService classloaderIdSvc;
    public final DataVersionCompatibility compat;
    public final ConcurrentHashMap<J2EEName, ComponentMetaData> componentMetadatasForModules = new ConcurrentHashMap();
    public final ConfigurationAdmin configAdmin;
    public volatile boolean createTables;
    public final Map<String, Map<String, Configuration>> dbStoreConfigAllApps = new ConcurrentHashMap<String, Map<String, Configuration>>();
    public final Map<String, Queue<ServiceRegistration<ResourceFactory>>> delegatorsAllApps = new ConcurrentHashMap<String, Queue<ServiceRegistration<ResourceFactory>>>();
    public final Map<String, Queue<ServiceRegistration<DDLGenerationParticipant>>> ddlgeneratorsAllApps = new ConcurrentHashMap<String, Queue<ServiceRegistration<DDLGenerationParticipant>>>();
    public volatile boolean dropTables;
    final ExecutorService executor;
    private final ConcurrentHashMap<String, Set<FutureEMBuilder>> futureEMBuilders = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<FutureEMBuilder>> futureEMBuildersInEJB = new ConcurrentHashMap();
    final LocalTransactionCurrent localTranCurrent;
    private volatile Set<String> logValues = Set.of();
    public final MetaDataIdentifierService metadataIdSvc;
    private final ConcurrentHashMap<String, DataComponentMetaData> metadatas = new ConcurrentHashMap();
    final Map<String, Queue<RepositoryProducer<?>>> repositoryProducers = new ConcurrentHashMap();
    public final ResourceConfigFactory resourceConfigFactory;
    final EmbeddableWebSphereTransactionManager tranMgr;
    transient Object validationService;
    static final long serialVersionUID = -7645439266310753288L;

    @Activate
    public DataProvider(Map<String, Object> props, @Reference CDIService cdiService, @Reference ClassLoaderIdentifierService classloaderIdSvc, @Reference DataVersionCompatibility compat, @Reference ConfigurationAdmin configAdmin, @Reference(target="(component.name=com.ibm.ws.threading)") ExecutorService executor, @Reference LocalTransactionCurrent localTranCurrent, @Reference MetaDataIdentifierService metadataIdSvc, @Reference ResourceConfigFactory resourceConfigFactory, @Reference EmbeddableWebSphereTransactionManager tranMgr) {
        HashSet<String> names;
        this.cdiService = cdiService;
        this.classloaderIdSvc = classloaderIdSvc;
        this.compat = compat;
        this.configAdmin = configAdmin;
        this.executor = executor;
        this.localTranCurrent = localTranCurrent;
        this.metadataIdSvc = metadataIdSvc;
        this.resourceConfigFactory = resourceConfigFactory;
        this.tranMgr = tranMgr;
        this.createTables = Boolean.TRUE.equals(props.get("createTables"));
        this.dropTables = Boolean.TRUE.equals(props.get("dropTables"));
        Collection list = (Collection)props.get("logValues");
        HashSet<String> hashSet = names = list == null ? Set.of() : new HashSet<String>(list.size());
        if (list != null) {
            for (String item : list) {
                names.add(item.trim());
            }
        }
        this.logValues = names;
    }

    @Trivial
    public void applicationStarting(ApplicationInfo appInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("applicationStarting " + appInfo.getDeploymentName() + " (" + appInfo.getName() + ")"), (Object[])new Object[0]);
        }
    }

    @Trivial
    @ManualTrace
    public void applicationStarted(ApplicationInfo appInfo) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("applicationStarted " + appInfo.getDeploymentName() + " (" + appInfo.getName() + ")"), (Object[])new Object[0]);
        }
        String appName = appInfo.getDeploymentName() == null ? appInfo.getName() : appInfo.getDeploymentName();
        Set<FutureEMBuilder> futures = this.futureEMBuilders.get(appName);
        Set<FutureEMBuilder> skip = this.futureEMBuildersInEJB.remove(appName);
        if (futures != null) {
            for (FutureEMBuilder futureEMBuilder : futures) {
                if (skip == null || !skip.contains(futureEMBuilder)) {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("completing futureEMBuilder " + String.valueOf(futureEMBuilder)), (Object[])new Object[]{futureEMBuilder.jeeName});
                    }
                    CheckpointPhase.onRestore(() -> futureEMBuilder.completeAsync(futureEMBuilder::createEMBuilder, this.executor));
                }
                futureEMBuilder.registerDDLGenerationParticipant(appName);
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"applicationStarted");
        }
    }

    @Trivial
    public void applicationStopping(ApplicationInfo appInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("applicationStopping " + appInfo.getDeploymentName() + " (" + appInfo.getName() + ")"), (Object[])new Object[0]);
        }
    }

    @Trivial
    @ManualTrace
    public void applicationStopped(ApplicationInfo appInfo) {
        Queue<ServiceRegistration<ResourceFactory>> registrations;
        String appName;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)("applicationStopped" + appInfo.getDeploymentName() + " (" + appInfo.getName() + ")"), (Object[])new Object[0]);
        }
        if ((appName = appInfo.getDeploymentName()) == null) {
            appName = appInfo.getName();
        }
        this.repositoryProducers.remove(appName);
        Queue<ServiceRegistration<DDLGenerationParticipant>> ddlgenRegistrations = this.ddlgeneratorsAllApps.remove(appName);
        if (ddlgenRegistrations != null) {
            ServiceRegistration<DDLGenerationParticipant> reg;
            while ((reg = ddlgenRegistrations.poll()) != null) {
                reg.unregister();
            }
        }
        this.futureEMBuilders.remove(appName);
        Map<String, Configuration> configurations = this.dbStoreConfigAllApps.remove(appName);
        if (configurations != null) {
            for (Configuration config : configurations.values()) {
                try {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("deleting " + String.valueOf(config)), (Object[])new Object[0]);
                    }
                    config.delete();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"io.openliberty.data.internal.persistence.DataProvider", (String)"411", (Object)this, (Object[])new Object[]{appInfo});
                }
            }
        }
        if ((registrations = this.delegatorsAllApps.remove(appName)) != null) {
            ServiceRegistration<ResourceFactory> reg;
            while ((reg = registrations.poll()) != null) {
                reg.unregister();
            }
        }
        Iterator<DataComponentMetaData> it = this.metadatas.values().iterator();
        while (it.hasNext()) {
            DataComponentMetaData cdata = it.next();
            if (!appName.equals(cdata.getJ2EEName().getApplication())) continue;
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("removing " + String.valueOf((Object)cdata)), (Object[])new Object[0]);
            }
            it.remove();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"applicationStopped");
        }
    }

    @Trivial
    public void componentMetaDataCreated(MetaDataEvent<ComponentMetaData> event) {
        IdentifiableComponentMetaData i;
        Set<FutureEMBuilder> futures;
        ComponentMetaData metadata = (ComponentMetaData)event.getMetaData();
        J2EEName jeeName = metadata.getJ2EEName();
        String appName = jeeName.getApplication();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("componentMetaDataCreated " + String.valueOf(jeeName)), (Object[])new Object[]{metadata});
        }
        if (jeeName.getComponent() == null) {
            this.componentMetadatasForModules.put(jeeName, metadata);
        }
        if ((futures = this.futureEMBuilders.get(appName)) != null && metadata instanceof IdentifiableComponentMetaData && (i = (IdentifiableComponentMetaData)metadata).getPersistentIdentifier().startsWith("EJB")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(i.getPersistentIdentifier() + " is an EJB"), (Object[])new Object[0]);
            }
            Set<FutureEMBuilder> processed = this.futureEMBuildersInEJB.get(appName);
            for (FutureEMBuilder futureEMBuilder : futures) {
                Set<FutureEMBuilder> previous;
                String m = futureEMBuilder.jeeName.getModule();
                if (m == null || !m.equals(jeeName.getModule()) || processed != null && processed.contains(futureEMBuilder)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("request completion of " + String.valueOf(futureEMBuilder)), (Object[])new Object[]{futureEMBuilder.jeeName, metadata});
                }
                CheckpointPhase.onRestore(() -> futureEMBuilder.completeAsync(futureEMBuilder::createEMBuilder, this.executor));
                if (processed == null && (previous = this.futureEMBuildersInEJB.putIfAbsent(appName, processed = new ConcurrentSkipListSet<FutureEMBuilder>())) != null) {
                    processed = previous;
                }
                processed.add(futureEMBuilder);
            }
        }
    }

    @Trivial
    public void componentMetaDataDestroyed(MetaDataEvent<ComponentMetaData> event) {
        ComponentMetaData metadata = (ComponentMetaData)event.getMetaData();
        J2EEName jeeName = metadata.getJ2EEName();
        if (metadata.getJ2EEName().getComponent() == null) {
            this.componentMetadatasForModules.remove(jeeName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("componentMetaDataDestroyed " + String.valueOf(jeeName)), (Object[])new Object[]{metadata});
        }
    }

    public ComponentMetaData createComponentMetadata(ApplicationMetaData appData, ClassLoader classloader) {
        DataComponentMetaData componentData;
        J2EEName jeeName = appData.getJ2EEName();
        DataModuleMetaData moduleData = new DataModuleMetaData(jeeName, appData);
        String identifier = "DATA#" + String.valueOf(jeeName);
        DataComponentMetaData existing = this.metadatas.putIfAbsent(identifier, componentData = new DataComponentMetaData(identifier, moduleData, classloader));
        return existing == null ? componentData : existing;
    }

    public ComponentMetaData createComponentMetaData(String identifier) {
        return this.metadatas.get(identifier);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        Object reg;
        this.repositoryProducers.clear();
        Iterator<Object> it = this.ddlgeneratorsAllApps.values().iterator();
        while (it.hasNext()) {
            Queue<ServiceRegistration<DDLGenerationParticipant>> ddlgenRegistrations = it.next();
            it.remove();
            while ((reg = ddlgenRegistrations.poll()) != null) {
                reg.unregister();
            }
        }
        it = this.dbStoreConfigAllApps.values().iterator();
        while (it.hasNext()) {
            Map configurations = (Map)it.next();
            it.remove();
            reg = configurations.values().iterator();
            while (reg.hasNext()) {
                Configuration config = (Configuration)reg.next();
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("deleting " + String.valueOf(config)), (Object[])new Object[0]);
                    }
                    config.delete();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"io.openliberty.data.internal.persistence.DataProvider", (String)"578", (Object)this, (Object[])new Object[]{cc});
                }
            }
        }
        it = this.delegatorsAllApps.values().iterator();
        while (it.hasNext()) {
            Queue registrations = (Queue)it.next();
            it.remove();
            while ((reg = (ServiceRegistration)registrations.poll()) != null) {
                reg.unregister();
            }
        }
    }

    public Set<Class<?>> getBeanClasses() {
        return beanClasses;
    }

    public ClassLoader getClassLoader(ComponentMetaData metadata) {
        return metadata instanceof DataComponentMetaData ? ((DataComponentMetaData)metadata).classLoader : null;
    }

    @Trivial
    public Set<Class<? extends Extension>> getExtensions() {
        return extensions;
    }

    public String getIntrospectorDescription() {
        return "Jakarta Data repository diagnostics";
    }

    public String getIntrospectorName() {
        return "JakartaDataIntrospector";
    }

    public String getMetaDataIdentifier(String appName, String moduleName, String componentName) {
        StringBuilder b = new StringBuilder("DATA#").append(appName);
        if (moduleName != null) {
            b.append('#').append(moduleName);
        }
        if (componentName != null) {
            b.append('#').append(componentName);
        }
        return b.toString();
    }

    @Trivial
    public void initialize(ComponentMetaData metadata) throws IllegalStateException {
    }

    public void introspect(PrintWriter writer) {
        ArrayList repositoryImpls = new ArrayList();
        LinkedHashSet queryInfos = new LinkedHashSet();
        LinkedHashSet builders = new LinkedHashSet();
        writer.println("compatibility: " + this.compat.getClass().getSimpleName());
        writer.println("createTables? " + this.createTables);
        writer.println("dropTables? " + this.dropTables);
        writer.println("logValues for " + String.valueOf(this.logValues));
        writer.println();
        writer.println("databaseStore config:");
        this.dbStoreConfigAllApps.forEach((appName, dbStoreToConfig) -> {
            writer.println("  for application " + appName);
            dbStoreToConfig.forEach((dbStore, config) -> {
                writer.println("    for databaseStore " + dbStore);
                Util.alphabetize(config.getProperties()).forEach((name, value) -> writer.println("      " + name + "=" + String.valueOf(value)));
            });
        });
        writer.println();
        writer.println("EntityManager builder futures:");
        this.futureEMBuilders.forEach((appName, futureEMBuilders) -> {
            writer.println("  for application " + appName);
            for (FutureEMBuilder futureEMBuilder : futureEMBuilders) {
                futureEMBuilder.introspect(writer, "    ").ifPresent(builders::add);
                writer.println();
            }
        });
        writer.println();
        writer.println("Repository Producers:");
        this.repositoryProducers.forEach((appName, producers) -> {
            writer.println("  for application " + appName);
            for (RepositoryProducer producer : producers) {
                queryInfos.addAll(producer.introspect(writer, "    ", repositoryImpls));
                writer.println();
            }
        });
        HashMap<EntityInfo, ArrayList<QueryInfo>> queryInfoPerEntity = new HashMap<EntityInfo, ArrayList<QueryInfo>>();
        for (QueryInfo queryInfo : queryInfos) {
            EntityInfo entityInfo = queryInfo.getEntityInfo();
            ArrayList<QueryInfo> list = (ArrayList<QueryInfo>)queryInfoPerEntity.get(entityInfo);
            if (list == null) {
                list = new ArrayList<QueryInfo>();
                queryInfoPerEntity.put(entityInfo, list);
            }
            list.add(queryInfo);
        }
        writer.println();
        writer.println("EntityManager builders:");
        builders.forEach(builder -> {
            builder.introspect(writer, "  ");
            writer.println();
            builder.entityInfoMap.forEach((userEntityClass, entityInfoFuture) -> {
                writer.println("    entity: " + userEntityClass.getName());
                EntityInfo entityInfo = null;
                writer.print("      future: ");
                if (entityInfoFuture.isCancelled()) {
                    writer.println("cancelled");
                } else if (entityInfoFuture.isDone()) {
                    try {
                        entityInfo = (EntityInfo)entityInfoFuture.join();
                        writer.println("completed");
                    }
                    catch (Throwable x) {
                        writer.println("failed");
                        Util.printStackTrace(x, writer, "    ", null);
                    }
                } else {
                    writer.println("not completed");
                }
                if (entityInfo != null) {
                    entityInfo.introspect(writer, "      ");
                }
                writer.println();
            });
        });
        writer.println();
        writer.println("Query Information:");
        for (List queryInfoList : queryInfoPerEntity.values()) {
            for (QueryInfo queryInfo : queryInfoList) {
                RepositoryImpl r;
                CompletableFuture<QueryInfo> future = null;
                Iterator iterator = repositoryImpls.iterator();
                while (iterator.hasNext() && (future = (r = (RepositoryImpl)iterator.next()).getQueryFuture(queryInfo.method)) == null) {
                }
                queryInfo.introspect(writer, "  ", future);
                writer.println();
            }
        }
    }

    @Trivial
    Object[] loggable(Class<?> repoClass, Method method, Object ... values) {
        String className;
        if (values == null || values.length == 0 || !this.logValues.isEmpty() && (this.logValues.contains("*") || this.logValues.contains(repoClass.getPackageName()) || this.logValues.contains(className = repoClass.getName()) || this.logValues.contains(className + "." + method.getName()))) {
            return values;
        }
        Object[] loggable = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            loggable[i] = values[i] == null || values[i] instanceof PageRequest || values[i] instanceof Order || values[i] instanceof Sort || values[i] instanceof Sort[] || values[i] instanceof Limit ? values[i] : this.loggable(values[i]);
        }
        return loggable;
    }

    @Trivial
    Object loggable(Class<?> repoClass, Method method, Object value) {
        String className;
        if (value == null || !this.logValues.isEmpty() && (this.logValues.contains("*") || this.logValues.contains(repoClass.getPackageName()) || this.logValues.contains(className = repoClass.getName()) || this.logValues.contains(className + "." + method.getName()))) {
            return value;
        }
        return this.loggable(value);
    }

    @Trivial
    private Object loggable(Object value) {
        Object loggable;
        Class<?> c = value.getClass();
        Class<?> a = c.getComponentType();
        if (a != null) {
            StringBuilder s = new StringBuilder();
            int len = Array.getLength(value);
            int maxOutput = len <= 20 ? len : 20;
            s.append(a.getName()).append('[').append(len).append("]: {");
            for (int i = 0; i < maxOutput; ++i) {
                Object v = this.loggable(Array.get(value, i));
                s.append(i == 0 ? " " : ", ").append(v);
            }
            if (len > maxOutput) {
                s.append(", ...");
            }
            s.append(" }");
            loggable = s.toString();
        } else if (value instanceof Optional) {
            Optional opt = (Optional)value;
            loggable = opt.isPresent() ? "Optional { " + this.loggable(opt.get()) + " }" : value;
        } else if (value instanceof Page) {
            loggable = value;
        } else if (value instanceof CompletionStage) {
            loggable = value;
        } else if (value instanceof Iterable) {
            StringBuilder s = new StringBuilder();
            int len = value instanceof Collection ? ((Collection)value).size() : -1;
            int maxOutput = 20;
            s.append(c.getName());
            if (len >= 0) {
                s.append('(').append(len).append("): {");
            } else {
                s.append(": {");
            }
            Iterator it = ((Iterable)value).iterator();
            for (int size = 0; size < maxOutput && it.hasNext(); ++size) {
                Object v = this.loggable(it.next());
                s.append(size == 0 ? " " : ", ").append(v);
            }
            if (it.hasNext()) {
                s.append(", ...");
            }
            s.append(" }");
            loggable = s.toString();
        } else {
            String name = c.getName();
            loggable = c.isPrimitive() || value instanceof Number ? name : new StringBuilder(name.length() + 9).append(name).append('@').append(Integer.toHexString(value.hashCode()));
        }
        return loggable;
    }

    @Trivial
    String loggableAppend(Class<?> repoClass, Method method, String prefix, Object ... possibleSuffix) {
        String className;
        StringBuilder b = new StringBuilder(prefix);
        if (possibleSuffix != null && !this.logValues.isEmpty() && (this.logValues.contains("*") || this.logValues.contains(repoClass.getPackageName()) || this.logValues.contains(className = repoClass.getName()) || this.logValues.contains(className + "." + method.getName()))) {
            for (Object s : possibleSuffix) {
                if (s != null && s.getClass().isArray()) {
                    int len = Array.getLength(s);
                    int maxOutput = len <= 20 ? len : 20;
                    b.append(s.getClass().getComponentType()).append('[').append(len).append("] {");
                    for (int i = 0; i < maxOutput; ++i) {
                        b.append(i == 0 ? " " : ", ").append(Array.get(s, i));
                    }
                    if (len > maxOutput) {
                        b.append(", ...");
                    }
                    b.append(" }");
                    continue;
                }
                b.append(s);
            }
        }
        return b.toString();
    }

    @Modified
    protected void modified(Map<String, Object> props) {
        HashSet<String> names;
        this.createTables = Boolean.TRUE.equals(props.get("createTables"));
        this.dropTables = Boolean.TRUE.equals(props.get("dropTables"));
        Collection list = (Collection)props.get("logValues");
        HashSet<String> hashSet = names = list == null ? Set.of() : new HashSet<String>(list.size());
        if (list != null) {
            for (String item : list) {
                names.add(item.trim());
            }
        }
        this.logValues = names;
    }

    @Trivial
    public void moduleMetaDataCreated(MetaDataEvent<ModuleMetaData> event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("moduleMetaDataCreated " + String.valueOf(((ModuleMetaData)event.getMetaData()).getJ2EEName())), (Object[])new Object[0]);
        }
    }

    @Trivial
    public void moduleMetaDataDestroyed(MetaDataEvent<ModuleMetaData> event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("moduleMetaDataDestroyed " + String.valueOf(((ModuleMetaData)event.getMetaData()).getJ2EEName())), (Object[])new Object[0]);
        }
    }

    @Trivial
    public void moduleStarted(ModuleInfo moduleInfo) throws StateChangeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String jeeAppName = moduleInfo.getApplicationInfo().getDeploymentName();
            if (jeeAppName == null) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("moduleStarted " + moduleInfo.getApplicationInfo().getName() + "/" + moduleInfo.getName()), (Object[])new Object[0]);
            } else {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("moduleStarted " + jeeAppName + "#" + moduleInfo.getName()), (Object[])new Object[0]);
            }
        }
    }

    @Trivial
    public void moduleStarting(ModuleInfo moduleInfo) throws StateChangeException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String jeeAppName = moduleInfo.getApplicationInfo().getDeploymentName();
            if (jeeAppName == null) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("moduleStarting " + moduleInfo.getApplicationInfo().getName() + "/" + moduleInfo.getName()), (Object[])new Object[0]);
            } else {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("moduleStarting " + jeeAppName + "#" + moduleInfo.getName()), (Object[])new Object[0]);
            }
        }
    }

    @Trivial
    public void moduleStopped(ModuleInfo moduleInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String jeeAppName = moduleInfo.getApplicationInfo().getDeploymentName();
            if (jeeAppName == null) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("moduleStopped " + moduleInfo.getApplicationInfo().getName() + "/" + moduleInfo.getName()), (Object[])new Object[0]);
            } else {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("moduleStopped " + jeeAppName + "#" + moduleInfo.getName()), (Object[])new Object[0]);
            }
        }
    }

    @Trivial
    public void moduleStopping(ModuleInfo moduleInfo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String jeeAppName = moduleInfo.getApplicationInfo().getDeploymentName();
            if (jeeAppName == null) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("moduleStopping " + moduleInfo.getApplicationInfo().getName() + "/" + moduleInfo.getName()), (Object[])new Object[0]);
            } else {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("moduleStopping " + jeeAppName + "#" + moduleInfo.getName()), (Object[])new Object[0]);
            }
        }
    }

    public void onStart(String appName, Set<FutureEMBuilder> builders) {
        Set<FutureEMBuilder> previous;
        Set merged = builders;
        while (null != (previous = this.futureEMBuilders.putIfAbsent(appName, merged))) {
            ConcurrentHashMap<FutureEMBuilder, Boolean> m = new ConcurrentHashMap<FutureEMBuilder, Boolean>();
            for (FutureEMBuilder b : previous) {
                m.put(b, Boolean.TRUE);
            }
            for (FutureEMBuilder b : builders) {
                m.put(b, Boolean.TRUE);
            }
            merged = m.keySet();
        }
    }

    @Trivial
    public void producerCreated(String appName, RepositoryProducer<?> producer) {
        ConcurrentLinkedQueue empty;
        ConcurrentLinkedQueue producers = this.repositoryProducers.get(appName);
        if (producers == null && (producers = (ConcurrentLinkedQueue)this.repositoryProducers.putIfAbsent(appName, empty = new ConcurrentLinkedQueue())) == null) {
            producers = empty;
        }
        producers.add(producer);
    }

    @Reference(service=ModuleMetaDataListener.class, target="(service.pid=com.ibm.ws.beanvalidation.OSGiBeanValidationImpl)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setValidation(ModuleMetaDataListener svc) {
        this.validationService = svc;
    }

    protected void unsetValidation(ModuleMetaDataListener svc) {
        if (this.validationService == svc) {
            this.validationService = null;
        }
    }
}

