/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.passivator.PassivatorSerializableHandle;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejb.portable.Constants;
import com.ibm.ws.ejbcontainer.runtime.EJBRuntime;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;

public final class PersistentTimerHandle
implements TimerHandle,
PassivatorSerializableHandle {
    private static final TraceComponent tc = Tr.register(PersistentTimerHandle.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final long serialVersionUID = -7720620493313660153L;
    private static final byte[] EYECATCHER = Constants.TIMER_HANDLE_EYE_CATCHER;
    private static final short PLATFORM = 1;
    private static final short VERSION_ID = 1;
    protected transient Long taskId;
    protected transient boolean isTimer;

    protected PersistentTimerHandle(long taskId, boolean timer) {
        this.taskId = taskId;
        this.isTimer = timer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)this.toString(), (Object[])new Object[0]);
        }
    }

    public Timer getTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTimer: " + this), (Object[])new Object[0]);
        }
        if (EJSPlatformHelper.isZOSCRA()) {
            NoSuchObjectLocalException nsoe = new NoSuchObjectLocalException(this.toString() + " -- called from the adjunct control region.");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getTimer: " + (Object)((Object)nsoe)));
            }
            throw nsoe;
        }
        this.checkTimerAccess();
        EJBRuntime ejbRuntime = EJSContainer.getDefaultContainer().getEJBRuntime();
        Timer timer = ejbRuntime.getPersistentTimerFromStore(this.taskId);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getTimer: " + timer));
        }
        return timer;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("writeObject: " + this), (Object[])new Object[0]);
        }
        out.defaultWriteObject();
        out.write(EYECATCHER);
        out.writeShort(1);
        out.writeShort(1);
        out.writeBoolean(this.isTimer);
        out.writeLong(this.taskId);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeObject");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readObject", (Object[])new Object[0]);
        }
        in.defaultReadObject();
        byte[] eyeCatcher = new byte[EYECATCHER.length];
        int bytesRead = 0;
        for (int offset = 0; offset < EYECATCHER.length; offset += bytesRead) {
            bytesRead = in.read(eyeCatcher, offset, EYECATCHER.length - offset);
            if (bytesRead != -1) continue;
            throw new IOException("end of input stream while reading eye catcher");
        }
        for (int i = 0; i < EYECATCHER.length; ++i) {
            if (EYECATCHER[i] == eyeCatcher[i]) continue;
            String eyeCatcherString = new String(eyeCatcher);
            throw new IOException("Invalid eye catcher '" + eyeCatcherString + "' in TimerHandle input stream");
        }
        short incoming_platform = in.readShort();
        short incoming_vid = in.readShort();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("readObject: platform = " + incoming_platform + ", version = " + incoming_vid), (Object[])new Object[0]);
        }
        if (incoming_vid != 1) {
            throw new InvalidObjectException("EJB TimerHandle data stream is not of the correct version, this client should be updated.");
        }
        this.isTimer = in.readBoolean();
        this.taskId = in.readLong();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("readObject: " + this));
        }
    }

    @Override
    public Object getSerializedObject() {
        if (this.isTimer) {
            EJBRuntime ejbRuntime = EJSContainer.getDefaultContainer().getEJBRuntime();
            return ejbRuntime.getPersistentTimer(this.taskId);
        }
        return this;
    }

    private void checkTimerAccess() throws IllegalStateException {
        BeanO beanO = EJSContainer.getCallbackBeanO();
        if (beanO != null) {
            beanO.checkTimerServiceAccess();
        } else if (EJSContainer.getDefaultContainer().allowTimerAccessOutsideBean) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkTimerAccess: TimerHandle access permitted outside of bean", (Object[])new Object[0]);
            }
        } else {
            IllegalStateException ise = new IllegalStateException("TimerHandle methods not allowed - no active EJB");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkTimerAccess: " + ise), (Object[])new Object[0]);
            }
            throw ise;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PersistentTimerHandle) {
            PersistentTimerHandle timerHandle = (PersistentTimerHandle)obj;
            return this.taskId.equals(timerHandle.taskId);
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.taskId % Integer.MAX_VALUE);
    }

    public String toString() {
        return "PersistentTimerHandle(" + this.taskId + ")";
    }
}

