/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.WebApplicationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.core.CompletionStageHolder;
import org.jboss.resteasy.core.MessageBodyParameterInjector;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ValueInjector;
import org.jboss.resteasy.spi.metadata.MethodParameter;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.jboss.resteasy.spi.validation.GeneralValidator;
import org.jboss.resteasy.spi.validation.GeneralValidatorCDI;

public class MethodInjectorImpl
implements MethodInjector {
    protected ValueInjector[] params;
    protected ResteasyProviderFactory factory;
    protected ResourceLocator method;
    protected Method interfaceBasedMethod;
    protected boolean expectsBody;

    public MethodInjectorImpl(ResourceLocator resourceMethod, ResteasyProviderFactory factory) {
        this.factory = factory;
        this.method = resourceMethod;
        this.interfaceBasedMethod = MethodInjectorImpl.findInterfaceBasedMethod(resourceMethod.getResourceClass().getClazz(), resourceMethod.getMethod());
        this.params = new ValueInjector[resourceMethod.getParams().length];
        int i = 0;
        for (MethodParameter parameter : resourceMethod.getParams()) {
            this.params[i] = factory.getInjectorFactory().createParameterExtractor(parameter, factory);
            if (this.params[i] instanceof MessageBodyParameterInjector) {
                this.expectsBody = true;
            }
            ++i;
        }
    }

    @Override
    public boolean expectsBody() {
        return this.expectsBody;
    }

    public static Method findInterfaceBasedMethod(Class<?> root, Method method) {
        if (method.getDeclaringClass().isInterface() || root.isInterface()) {
            return method;
        }
        for (Class<?> intf : root.getInterfaces()) {
            try {
                return intf.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        if (root.getSuperclass() == null || root.getSuperclass().equals(Object.class)) {
            return method;
        }
        return MethodInjectorImpl.findInterfaceBasedMethod(root.getSuperclass(), method);
    }

    @Override
    public ValueInjector[] getParams() {
        return this.params;
    }

    @Override
    public Object injectArguments(HttpRequest input, HttpResponse response) {
        try {
            if (this.params != null && this.params.length > 0) {
                Object[] args = new Object[this.params.length];
                int i = 0;
                CompletionStage<Object> ret = null;
                for (ValueInjector extractor : this.params) {
                    int j = i++;
                    Object injectedObject = extractor.inject(input, response, true);
                    if (injectedObject != null && injectedObject instanceof CompletionStage) {
                        if (ret == null) {
                            ret = CompletableFuture.completedFuture(null);
                        }
                        ret = ret.thenCompose(v -> ((CompletionStage)injectedObject).thenApply(value -> {
                            args[j] = CompletionStageHolder.resolve(value);
                            return args[j];
                        }));
                        continue;
                    }
                    args[j] = CompletionStageHolder.resolve(injectedObject);
                }
                if (ret == null) {
                    return args;
                }
                return ret.thenApply(v -> args);
            }
            return null;
        }
        catch (WebApplicationException we) {
            throw we;
        }
        catch (Failure f) {
            throw f;
        }
        catch (Exception e) {
            BadRequestException badRequest = new BadRequestException(Messages.MESSAGES.failedProcessingArguments(this.method.toString()), (Throwable)e);
            throw badRequest;
        }
    }

    @Override
    public Object invoke(HttpRequest request, HttpResponse httpResponse, Object resource) throws Failure, ApplicationException {
        Object argsObj = this.injectArguments(request, httpResponse);
        if (argsObj == null || !(argsObj instanceof CompletionStage)) {
            Object returnObj = this.invoke(request, httpResponse, resource, (Object[])argsObj);
            if (returnObj instanceof CompletionStage) {
                CompletionStage cs = (CompletionStage)returnObj;
                return new CompletionStageHolder(cs);
            }
            return returnObj;
        }
        CompletionStage stagedArgs = (CompletionStage)argsObj;
        return stagedArgs.thenApply(args -> this.invoke(request, httpResponse, resource, (Object[])args));
    }

    private Object invoke(HttpRequest request, HttpResponse httpResponse, Object resource, Object[] args) {
        Method invokedMethod;
        GeneralValidator validator = (GeneralValidator)GeneralValidator.class.cast(request.getAttribute(GeneralValidator.class.getName()));
        if (validator != null) {
            validator.validateAllParameters(request, resource, this.method.getMethod(), args, new Class[0]);
        }
        if (!(invokedMethod = this.method.getMethod()).getDeclaringClass().isAssignableFrom(resource.getClass())) {
            invokedMethod = this.interfaceBasedMethod;
        }
        Object result = null;
        try {
            result = invokedMethod.invoke(resource, args);
        }
        catch (IllegalAccessException e) {
            throw new InternalServerErrorException(Messages.MESSAGES.notAllowedToReflectOnMethod(this.method.toString()), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (validator instanceof GeneralValidatorCDI) {
                ((GeneralValidatorCDI)GeneralValidatorCDI.class.cast(validator)).checkForConstraintViolations(request, e);
            }
            throw new ApplicationException(cause);
        }
        catch (IllegalArgumentException e) {
            Object msg = Messages.MESSAGES.badArguments(this.method.toString() + "  (");
            if (args != null) {
                boolean first = false;
                for (Object arg : args) {
                    if (!first) {
                        first = true;
                    } else {
                        msg = (String)msg + ",";
                    }
                    msg = arg == null ? (String)msg + " null" : (String)msg + " " + arg.getClass().getName() + " " + arg;
                }
            }
            msg = (String)msg + " )";
            throw new InternalServerErrorException((String)msg, e);
        }
        if (validator != null) {
            validator.validateReturnValue(request, resource, this.method.getMethod(), result, new Class[0]);
        }
        return result;
    }
}

