/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.trigger;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.TriggerService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.enterprise.concurrent.LastExecution;
import jakarta.enterprise.concurrent.Trigger;
import jakarta.enterprise.concurrent.ZonedTrigger;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class ZonedTriggerService
implements TriggerService {
    private static final TraceComponent tc = Tr.register(ZonedTriggerService.class, (String)"concurrent", null);
    static final long serialVersionUID = -3027603005013305355L;

    public ZonedDateTime getNextRunTime(LastExecution lastExecution, ZonedDateTime taskScheduledTime, Trigger trigger) {
        Date nextExecutionDate;
        ZonedDateTime nextExecTime = trigger instanceof ZonedTrigger ? ((ZonedTrigger)trigger).getNextRunTime(lastExecution, taskScheduledTime) : ((nextExecutionDate = trigger.getNextRunTime(lastExecution, Date.from(taskScheduledTime.toInstant()))) == null ? null : nextExecutionDate.toInstant().atZone(taskScheduledTime.getZone()));
        return nextExecTime;
    }

    @Trivial
    public ZoneId getZoneId(Trigger trigger) {
        ZoneId zone;
        ZoneId zoneId = zone = trigger instanceof ZonedTrigger ? ((ZonedTrigger)trigger).getZoneId() : ZoneId.systemDefault();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getZoneId", (Object[])new Object[]{zone});
        }
        return zone;
    }

    public boolean skipRun(LastExecution lastExecution, ZonedDateTime nextExecutionTime, Trigger trigger) {
        boolean skip = trigger instanceof ZonedTrigger ? ((ZonedTrigger)trigger).skipRun(lastExecution, nextExecutionTime) : trigger.skipRun(lastExecution, Date.from(nextExecutionTime.toInstant()));
        return skip;
    }
}

