/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.data;

public class JSONObject {
    private StringBuilder jsonBuilder = new StringBuilder();

    private JSONObject(JSONObjectBuilder builder) {
        this.jsonBuilder = builder.jsonBuilder;
    }

    public String toString() {
        return this.jsonBuilder.toString();
    }

    public static class JSONObjectBuilder {
        private StringBuilder jsonBuilder = new StringBuilder();
        private final String OMIT_FIELDS_STRING = "@@@OMIT@@@";
        private boolean hasAnyFields = false;

        public JSONObject build() {
            this.jsonBuilder = new StringBuilder().append("{").append(this.jsonBuilder.toString()).append("}");
            return new JSONObject(this);
        }

        public String toString() {
            return this.jsonBuilder.toString();
        }

        public JSONObjectBuilder addPreformatted(String s) {
            if (s.isEmpty()) {
                return this;
            }
            this.prepForNewField();
            this.jsonBuilder.append(s);
            return this;
        }

        public JSONObjectBuilder addPreformattedField(String name, String preformattedValue) {
            if (name.isEmpty() || preformattedValue.isEmpty()) {
                return this;
            }
            if (name.equals("@@@OMIT@@@")) {
                return this;
            }
            this.prepForNewField();
            this.jsonBuilder.append("\"" + name + "\":" + preformattedValue);
            return this;
        }

        public JSONObjectBuilder addField(String name, String value, boolean jsonEscapeName, boolean jsonEscapeValue) {
            this.appendNameValue(name, value, jsonEscapeName, jsonEscapeValue, false);
            return this;
        }

        public JSONObjectBuilder addField(String name, int value, boolean jsonEscapeName) {
            this.appendNameValue(name, Integer.toString(value), jsonEscapeName, false, true);
            return this;
        }

        public JSONObjectBuilder addField(String name, boolean value, boolean jsonEscapeName) {
            this.appendNameValue(name, Boolean.toString(value), jsonEscapeName, false, true);
            return this;
        }

        public JSONObjectBuilder addField(String name, long value, boolean jsonEscapeName) {
            this.appendNameValue(name, Long.toString(value), jsonEscapeName, false, true);
            return this;
        }

        public JSONObjectBuilder addField(String name, float value, boolean jsonEscapeName) {
            this.appendNameValue(name, Float.toString(value), jsonEscapeName, false, true);
            return this;
        }

        private void prepForNewField() {
            if (this.hasAnyFields) {
                this.jsonBuilder.append(",");
                this.hasAnyFields = true;
            } else {
                this.hasAnyFields = true;
            }
        }

        private void appendNameValue(String name, String value, boolean jsonEscapeName, boolean jsonEscapeValue, boolean isQuoteless) {
            if (name == null || value == null) {
                return;
            }
            if (name.equals("@@@OMIT@@@")) {
                return;
            }
            this.prepForNewField();
            this.jsonBuilder.append("\"");
            if (jsonEscapeName) {
                this.jsonEscape3(name);
            } else {
                this.jsonBuilder.append(name);
            }
            if (isQuoteless) {
                this.jsonBuilder.append("\":" + value);
            } else {
                this.jsonBuilder.append("\":\"");
                if (jsonEscapeValue) {
                    this.jsonEscape3(value);
                } else {
                    this.jsonBuilder.append(value);
                }
                this.jsonBuilder.append("\"");
            }
        }

        private void jsonEscape3(String s) {
            block8: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\b': {
                        this.jsonBuilder.append("\\b");
                        continue block8;
                    }
                    case '\f': {
                        this.jsonBuilder.append("\\f");
                        continue block8;
                    }
                    case '\n': {
                        this.jsonBuilder.append("\\n");
                        continue block8;
                    }
                    case '\r': {
                        this.jsonBuilder.append("\\r");
                        continue block8;
                    }
                    case '\t': {
                        this.jsonBuilder.append("\\t");
                        continue block8;
                    }
                    case '\"': 
                    case '/': 
                    case '\\': {
                        this.jsonBuilder.append("\\");
                        this.jsonBuilder.append(c);
                        continue block8;
                    }
                    default: {
                        this.jsonBuilder.append(c);
                    }
                }
            }
        }
    }
}

