/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.remote.client;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.clientcontainer.remote.common.ClientSupport;
import com.ibm.ws.clientcontainer.remote.common.ClientSupportFactory;
import com.ibm.ws.container.service.naming.JavaColonNamingHelper;
import com.ibm.ws.container.service.naming.NamingConstants;
import com.ibm.ws.container.service.naming.RemoteObjectInstance;
import com.ibm.ws.container.service.naming.RemoteObjectInstanceException;
import com.ibm.ws.container.service.naming.RemoteReferenceObjectInstanceImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.serialization.DeserializationContext;
import com.ibm.ws.serialization.SerializationService;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.injectionengine.ObjectFactoryInfo;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(property={"service.ranking:Integer=-1000"})
public class RemoteClientJavaColonNamingHelper
implements JavaColonNamingHelper {
    private static final String REFERENCE_OBJECT_FACTORIES = "objectFactories";
    private SerializationService serializationService;
    private ClientSupportFactory clientSupportFactory;
    private final Map<String, ObjectFactoryInfo> objectFactoryInfos = new ConcurrentHashMap<String, ObjectFactoryInfo>();
    private final ConcurrentServiceReferenceMap<String, ObjectFactory> objectFactories = new ConcurrentServiceReferenceMap("objectFactories");
    static final long serialVersionUID = 8737200951668897053L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate(ComponentContext cc) throws Exception {
        this.objectFactories.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.objectFactories.deactivate(cc);
    }

    @org.osgi.service.component.annotations.Reference
    protected void setSerializationService(SerializationService ss) {
        this.serializationService = ss;
    }

    protected void unsetSerializationService(SerializationService ss) {
        if (this.serializationService == ss) {
            this.serializationService = null;
        }
    }

    @org.osgi.service.component.annotations.Reference
    protected void setClientSupportFactory(ClientSupportFactory clientSupportFactory) {
        this.clientSupportFactory = clientSupportFactory;
    }

    protected void unsetClientSupportFactory(ClientSupportFactory clientSupportFactory) {
        this.clientSupportFactory = null;
    }

    @org.osgi.service.component.annotations.Reference(name="objectFactories", service=ObjectFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addObjectFactory(ServiceReference<ObjectFactory> factorySR) {
        Object o = factorySR.getProperty("objectClass");
        String[] implNames = o instanceof String ? new String[]{(String)o} : (String[])o;
        for (String implName : implNames) {
            this.objectFactories.putReference((Object)implName, factorySR);
        }
    }

    protected void removeObjectFactory(ServiceReference<ObjectFactory> factorySR) {
        Object o = factorySR.getProperty("objectClass");
        String[] implNames = o instanceof String ? new String[]{(String)o} : (String[])o;
        for (String implName : implNames) {
            this.objectFactories.removeReference((Object)implName, factorySR);
        }
    }

    @org.osgi.service.component.annotations.Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addObjectFactoryInfo(ObjectFactoryInfo factoryInfo) {
        String factoryClassName = factoryInfo.getObjectFactoryClass().getName();
        this.objectFactoryInfos.put(factoryClassName, factoryInfo);
    }

    protected void removeObjectFactoryInfo(ObjectFactoryInfo factoryInfo) {
        String factoryClassName = factoryInfo.getObjectFactoryClass().getName();
        this.objectFactoryInfos.remove(factoryClassName);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getObjectInstance(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        Object objectInstance = null;
        if (!NamingConstants.JavaColonNamespace.APP.equals((Object)namespace)) {
            if (!NamingConstants.JavaColonNamespace.GLOBAL.equals((Object)namespace)) return objectInstance;
        }
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        J2EEName j2eeName = cmd.getJ2EEName();
        RemoteObjectInstance roi = null;
        try {
            ClientSupport jndiHelper = this.clientSupportFactory.getRemoteClientSupport();
            roi = jndiHelper.getRemoteObjectInstance(j2eeName.getApplication(), j2eeName.getModule(), j2eeName.getComponent(), namespace.toString(), name);
        }
        catch (RemoteException jndiHelper) {
            FFDCFilter.processException((Throwable)jndiHelper, (String)"com.ibm.ws.jndi.remote.client.RemoteClientJavaColonNamingHelper", (String)"160", (Object)this, (Object[])new Object[]{namespace, name});
            throw new NamingException("Failed remote lookup of " + namespace.prefix() + name);
        }
        if (roi == null) return objectInstance;
        try {
            objectInstance = roi.getObject();
            if (!(roi instanceof RemoteReferenceObjectInstanceImpl)) return objectInstance;
            ObjectInputStream ois = null;
            try {
                byte[] bytes22 = (byte[])objectInstance;
                ClassLoader classLoader = AccessController.doPrivileged(new GetCL("this"));
                DeserializationContext dc = this.serializationService.createDeserializationContext();
                ois = dc.createObjectInputStream((InputStream)new ByteArrayInputStream(bytes22), classLoader);
                objectInstance = ois.readObject();
                if (objectInstance == null) throw new NamingException("Invalid reference returned from server");
                if (!(objectInstance instanceof Reference)) {
                    throw new NamingException("Invalid reference returned from server");
                }
                Reference ref = (Reference)objectInstance;
                String factoryClassName = ref.getFactoryClassName();
                ObjectFactory objectFactory = null;
                ObjectFactoryInfo info = this.objectFactoryInfos.get(factoryClassName);
                objectFactory = info != null ? (ObjectFactory)info.getObjectFactoryClass().newInstance() : (ObjectFactory)this.objectFactories.getServiceWithException((Object)factoryClassName);
                objectInstance = objectFactory.getObjectInstance(ref, null, null, null);
                if (objectInstance == null) {
                    throw new NamingException("Could not object instance from object factory " + objectFactory);
                }
                if (ois == null) return objectInstance;
            }
            catch (Exception bytes22) {
                try {
                    void ex;
                    FFDCFilter.processException((Throwable)bytes22, (String)"com.ibm.ws.jndi.remote.client.RemoteClientJavaColonNamingHelper", (String)"196", (Object)this, (Object[])new Object[]{namespace, name});
                    NamingException ne = new NamingException("Failure occurred while reconstructing remote reference object");
                    ne.initCause((Throwable)ex);
                    throw ne;
                }
                catch (Throwable throwable) {
                    if (ois == null) throw throwable;
                    try {
                        ois.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jndi.remote.client.RemoteClientJavaColonNamingHelper", (String)"204", (Object)this, (Object[])new Object[]{namespace, name});
                    }
                    throw throwable;
                }
            }
            try {
                ois.close();
                return objectInstance;
            }
            catch (IOException bytes22) {
                FFDCFilter.processException((Throwable)bytes22, (String)"com.ibm.ws.jndi.remote.client.RemoteClientJavaColonNamingHelper", (String)"204", (Object)this, (Object[])new Object[]{namespace, name});
                return objectInstance;
            }
        }
        catch (RemoteObjectInstanceException ois) {
            void ex;
            FFDCFilter.processException((Throwable)ois, (String)"com.ibm.ws.jndi.remote.client.RemoteClientJavaColonNamingHelper", (String)"210", (Object)this, (Object[])new Object[]{namespace, name});
            NamingException ne = new NamingException();
            ne.initCause((Throwable)ex);
            throw ne;
        }
    }

    public boolean hasObjectWithPrefix(NamingConstants.JavaColonNamespace namespace, String name) throws NamingException {
        boolean b;
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        J2EEName j2eeName = cmd.getJ2EEName();
        try {
            b = (NamingConstants.JavaColonNamespace.APP.equals((Object)namespace) || NamingConstants.JavaColonNamespace.GLOBAL.equals((Object)namespace)) && this.clientSupportFactory.getRemoteClientSupport().hasRemoteObjectWithPrefix(j2eeName.getApplication(), j2eeName.getModule(), j2eeName.getComponent(), namespace.toString(), name);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.jndi.remote.client.RemoteClientJavaColonNamingHelper", (String)"235", (Object)this, (Object[])new Object[]{namespace, name});
            b = false;
        }
        return b;
    }

    public Collection<? extends NameClassPair> listInstances(NamingConstants.JavaColonNamespace namespace, String nameInContext) throws NamingException {
        Collection<Object> instances;
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        J2EEName j2eeName = cmd.getJ2EEName();
        if (NamingConstants.JavaColonNamespace.APP.equals((Object)namespace) || NamingConstants.JavaColonNamespace.GLOBAL.equals((Object)namespace)) {
            try {
                ClientSupport jndiHelper = this.clientSupportFactory.getRemoteClientSupport();
                instances = jndiHelper.listRemoteInstances(j2eeName.getApplication(), j2eeName.getModule(), j2eeName.getComponent(), namespace.toString(), nameInContext);
            }
            catch (RemoteException jndiHelper) {
                FFDCFilter.processException((Throwable)jndiHelper, (String)"com.ibm.ws.jndi.remote.client.RemoteClientJavaColonNamingHelper", (String)"256", (Object)this, (Object[])new Object[]{namespace, nameInContext});
                instances = Collections.emptyList();
            }
        } else {
            instances = Collections.emptyList();
        }
        return instances;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jndi.remote.client.RemoteClientJavaColonNamingHelper", RemoteClientJavaColonNamingHelper.class, (String)"Naming", null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class GetCL
    implements PrivilegedAction<ClassLoader> {
        String whichLoader;
        static final long serialVersionUID = -2755807570521080171L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        GetCL(String which) {
            this.whichLoader = which;
        }

        @Override
        public ClassLoader run() {
            if ("this".equals(this.whichLoader)) {
                return RemoteClientJavaColonNamingHelper.class.getClassLoader();
            }
            return Thread.currentThread().getContextClassLoader();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jndi.remote.client.RemoteClientJavaColonNamingHelper$GetCL", GetCL.class, (String)"Naming", null);
        }
    }
}

