/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.imageio.ImageIO;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.model.SoapBodyInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxInEndingInterceptor;
import org.apache.cxf.jaxws.interceptors.HolderInInterceptor;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.model.MessagePartInfo;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class SwAInInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(SwAInInterceptor.class);
    static final long serialVersionUID = 2972084047538633005L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SwAInInterceptor() {
        super("pre-invoke");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.SwAInInterceptor", "<init>", new Object[0]);
        }
        this.getBefore().add(HolderInInterceptor.class.getName());
        this.getAfter().add(StaxInEndingInterceptor.class.getName());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAInInterceptor", "<init>", (Object)this);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(@Sensitive SoapMessage message) throws Fault {
        if (SwAInInterceptor.LOG != null && SwAInInterceptor.LOG.isLoggable(Level.FINER)) {
            v0 = new Object[1];
            v0[0] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
            SwAInInterceptor.LOG.entering("org.apache.cxf.jaxws.interceptors.SwAInInterceptor", "handleMessage", v0);
        }
        isFinestEnabled = SwAInInterceptor.LOG.isLoggable(Level.FINEST);
        bop = message.getExchange().getBindingOperationInfo();
        if (bop == null) {
            if (isFinestEnabled) {
                SwAInInterceptor.LOG.finest("BindingOperationInfo is null. Returning.");
            }
            if (SwAInInterceptor.LOG != null && SwAInInterceptor.LOG.isLoggable(Level.FINER)) {
                SwAInInterceptor.LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAInInterceptor", "handleMessage");
            }
            return;
        }
        if (bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
            if (isFinestEnabled) {
                SwAInInterceptor.LOG.finest("BindingOperationInfo is switched to wrapped version");
            }
        }
        v1 = bmi = (client = this.isRequestor((Message)message)) != false ? bop.getOutput() : bop.getInput();
        if (bmi == null) {
            if (isFinestEnabled) {
                SwAInInterceptor.LOG.finest("BindingMessageInfo is null. Returning.");
            }
            if (SwAInInterceptor.LOG != null && SwAInInterceptor.LOG.isLoggable(Level.FINER)) {
                SwAInInterceptor.LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAInInterceptor", "handleMessage");
            }
            return;
        }
        sbi = (SoapBodyInfo)bmi.getExtensor(SoapBodyInfo.class);
        if (sbi == null || sbi.getAttachments() == null || sbi.getAttachments().isEmpty()) {
            if (isFinestEnabled) {
                SwAInInterceptor.LOG.finest("SoapBodyInfo is null or it doesn't have attachments. Returning.");
            }
            if (SwAInInterceptor.LOG != null && SwAInInterceptor.LOG.isLoggable(Level.FINER)) {
                SwAInInterceptor.LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAInInterceptor", "handleMessage");
            }
            return;
        }
        foundAtts = new HashSet<Integer>();
        inObjects = MessageContentsList.getContentsList((Message)message);
        for (MessagePartInfo mpi : sbi.getAttachments()) {
            partName = mpi.getConcreteName().getLocalPart();
            start = partName + "=";
            found = false;
            if (foundAtts.contains(mpi.getIndex())) continue;
            foundAtts.add(mpi.getIndex());
            for (Attachment a : message.getAttachments()) {
                if (!a.getId().startsWith(start)) continue;
                dh = a.getDataHandler();
                ct = dh.getContentType();
                typeClass = mpi.getTypeClass();
                if (DataHandler.class.isAssignableFrom(typeClass)) {
                    o /* !! */  = dh;
                    if (isFinestEnabled) {
                        SwAInInterceptor.LOG.finest("DataHandler obtained from attachment assigned to Object: " + o /* !! */ );
                    }
                } else if (String.class.isAssignableFrom(typeClass)) {
                    try {
                        o /* !! */  = dh.getContent();
                        if (!isFinestEnabled) ** GOTO lbl85
                        SwAInInterceptor.LOG.finest("Content of DataHandler obtained from attachment assigned to Object: " + o /* !! */ );
                    }
                    catch (IOException e) {
                        throw new Fault((Throwable)e);
                    }
                } else if (byte[].class.isAssignableFrom(typeClass)) {
                    try {
                        o /* !! */  = (DataHandler)IOUtils.readBytesFromStream((InputStream)dh.getInputStream());
                        if (!isFinestEnabled) ** GOTO lbl85
                        SwAInInterceptor.LOG.finest("InputStream read from DataHandler tobtained from attachment assigned to Object: " + o /* !! */ );
                    }
                    catch (IOException e) {
                        throw new Fault((Throwable)e);
                    }
                } else if (ct.startsWith("image/")) {
                    try {
                        o /* !! */  = ImageIO.read(dh.getInputStream());
                        if (!isFinestEnabled) ** GOTO lbl85
                        SwAInInterceptor.LOG.finest("InputStream read from DataHandlerobtained from image attachment assigned Object: " + o /* !! */ );
                    }
                    catch (IOException e) {
                        throw new Fault((Throwable)e);
                    }
                } else if (ct.startsWith("text/xml") || ct.startsWith("application/xml")) {
                    try {
                        o /* !! */  = new StreamSource(dh.getInputStream());
                        if (!isFinestEnabled) ** GOTO lbl85
                        SwAInInterceptor.LOG.finest("A StreeamSource created from the DataHandler is assigned to Object: " + o /* !! */ );
                    }
                    catch (IOException e) {
                        throw new Fault((Throwable)e);
                    }
                } else {
                    o /* !! */  = dh;
                }
lbl85:
                // 10 sources

                inObjects.put(mpi, (Object)o /* !! */ );
                found = true;
                if (!isFinestEnabled) break;
                SwAInInterceptor.LOG.finest("Object is put in MessageContentsList and found is set to true.");
                break;
            }
            if (found) continue;
            inObjects.put(mpi, null);
            if (!isFinestEnabled) continue;
            SwAInInterceptor.LOG.finest("Object is not put in MessageContentsList since it's not found.");
        }
        if (SwAInInterceptor.LOG != null && SwAInInterceptor.LOG.isLoggable(Level.FINER)) {
            SwAInInterceptor.LOG.exiting("org.apache.cxf.jaxws.interceptors.SwAInInterceptor", "handleMessage");
        }
    }
}

