/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.injection.factory;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.HomeOfHomes;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.injection.factory.MBLinkInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionUtil;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class MBLinkObjectFactory
implements ObjectFactory {
    private static final String CLASS_NAME = MBLinkObjectFactory.class.getName();
    private static final TraceComponent tc = Tr.register(MBLinkObjectFactory.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");

    public MBLinkObjectFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getObjectInstance : " + obj), (Object[])new Object[0]);
        }
        Object retObj = null;
        if (!(obj instanceof Reference)) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getObjectInstance : null (non-Reference)");
            }
            return null;
        }
        Reference ref = (Reference)obj;
        if (!ref.getFactoryClassName().equals(CLASS_NAME)) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getObjectInstance : null (wrong factory class: " + ref.getFactoryClassName() + " )"));
            }
            return null;
        }
        RefAddr addr = ref.get("MBLinkInfo");
        if (addr == null) {
            NamingException nex = new NamingException("The address for this Reference is empty (null)");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getObjectInstance : " + nex));
            }
            throw nex;
        }
        MBLinkInfo info = (MBLinkInfo)addr.getContent();
        EJSHome home = info.ivHome;
        String beanType = info.ivBeanType;
        if (home == null) {
            HomeOfHomes homeOfHomes = EJSContainer.homeOfHomes;
            if (beanType != null) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("auto-link on " + beanType), (Object[])new Object[0]);
                }
                home = homeOfHomes.getHomeByInterface(info.ivApplication, info.ivModule, beanType);
            }
            if (home == null || !home.isManagedBeanHome()) {
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("ManagedBean reference could not be resolved : " + home));
                }
                String cause = home == null ? "Managed bean of type " + beanType + " could not be located in the application." : "The " + beanType + " reference type is an EJB; an EJB reference must be used.";
                throw new InjectionException("ManagedBean reference " + info.ivRefName + "  could not be resolved. " + cause);
            }
            info.ivHome = home;
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("home = " + home.getJ2EEName()), (Object[])new Object[0]);
        }
        BeanMetaData bmd = home.getBeanMetaData();
        try {
            retObj = home.createBusinessObject(bmd.enterpriseBeanClassName, false);
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".getObjectInstance"), (String)"257", (Object)this);
            String msg = "The " + info.ivRefName + " managed bean reference in the " + info.ivModule + " module of the " + info.ivApplication + " application could not be resolved. A failure occurred creating an instance of the " + bmd.j2eeName.getComponent() + " managed bean in the " + bmd.j2eeName.getModule() + " module of the " + bmd.j2eeName.getApplication() + " application.";
            InjectionException inex = InjectionUtil.checkForRecursiveException((Throwable)ex, (String)msg);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getObjectInstance: " + (Object)((Object)inex)));
            }
            throw inex;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getObjectInstance : " + retObj.getClass().getName()));
        }
        return retObj;
    }
}

