/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.terracotta;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.cluster.ClusterNode;
import net.sf.ehcache.cluster.ClusterTopologyListener;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.config.MemoryUnit;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.terracotta.ClusteredInstanceFactory;
import net.sf.ehcache.terracotta.ClusteredInstanceFactoryWrapper;
import net.sf.ehcache.terracotta.DisconnectedClusterNode;
import net.sf.ehcache.terracotta.TerracottaCacheCluster;
import net.sf.ehcache.terracotta.TerracottaClientRejoinListener;
import net.sf.ehcache.terracotta.TerracottaClusteredInstanceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerracottaClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerracottaClient.class);
    private static final int REJOIN_SLEEP_MILLIS_ON_EXCEPTION = Integer.getInteger("net.sf.ehcache.rejoin.sleepMillisOnException", 5000);
    private final TerracottaClientConfiguration terracottaClientConfiguration;
    private volatile ClusteredInstanceFactoryWrapper clusteredInstanceFactory;
    private final TerracottaCacheCluster cacheCluster = new TerracottaCacheCluster();
    private final RejoinWorker rejoinWorker = new RejoinWorker();
    private final TerracottaClientRejoinListener rejoinListener;
    private final CacheManager cacheManager;
    private ExecutorService l1TerminatorThreadPool;

    public TerracottaClient(CacheManager cacheManager, TerracottaClientRejoinListener rejoinAction, TerracottaClientConfiguration terracottaClientConfiguration) {
        this.cacheManager = cacheManager;
        this.rejoinListener = rejoinAction;
        this.terracottaClientConfiguration = terracottaClientConfiguration;
        if (terracottaClientConfiguration != null) {
            terracottaClientConfiguration.freezeConfig();
        }
        if (this.isRejoinEnabled()) {
            TerracottaClusteredInstanceHelper.TerracottaRuntimeType type = TerracottaClusteredInstanceHelper.getInstance().getTerracottaRuntimeTypeOrNull();
            if (type == null) {
                throw new InvalidConfigurationException("Terracotta Rejoin is enabled but can't determine Terracotta Runtime. You are probably missing Terracotta jar(s).");
            }
            if (type != TerracottaClusteredInstanceHelper.TerracottaRuntimeType.EnterpriseExpress && type != TerracottaClusteredInstanceHelper.TerracottaRuntimeType.Express) {
                throw new InvalidConfigurationException("Rejoin cannot be used in Terracotta DSO mode.");
            }
            Thread rejoinThread = new Thread((Runnable)this.rejoinWorker, "Rejoin Worker Thread [cacheManager: " + cacheManager.getName() + "]");
            rejoinThread.setDaemon(true);
            rejoinThread.start();
        }
    }

    public static TerracottaConfiguration.StorageStrategy getTerracottaDefaultStrategyForCurrentRuntime(CacheConfiguration cacheConfiguration) {
        return TerracottaClusteredInstanceHelper.getInstance().getDefaultStorageStrategyForCurrentRuntime(cacheConfiguration);
    }

    private static void setTestMode(TerracottaClusteredInstanceHelper testHelper) {
        try {
            Method method = TerracottaClusteredInstanceHelper.class.getDeclaredMethod("setTestMode", TerracottaClusteredInstanceHelper.class);
            method.setAccessible(true);
            method.invoke(null, testHelper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ClusteredInstanceFactory getClusteredInstanceFactory() {
        this.rejoinWorker.waitUntilRejoinComplete();
        return this.clusteredInstanceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createClusteredInstanceFactory(Map<String, CacheConfiguration> cacheConfigs) {
        boolean created;
        this.rejoinWorker.waitUntilRejoinComplete();
        if (this.clusteredInstanceFactory != null) {
            return false;
        }
        TerracottaClient terracottaClient = this;
        synchronized (terracottaClient) {
            if (this.clusteredInstanceFactory == null) {
                this.clusteredInstanceFactory = this.createNewClusteredInstanceFactory(cacheConfigs);
                created = true;
            } else {
                created = false;
            }
        }
        return created;
    }

    public TerracottaCacheCluster getCacheCluster() {
        this.rejoinWorker.waitUntilRejoinComplete();
        if (this.clusteredInstanceFactory == null) {
            throw new CacheException("Cannot get CacheCluster as ClusteredInstanceFactory has not been initialized yet.");
        }
        return this.cacheCluster;
    }

    public synchronized void shutdown() {
        this.rejoinWorker.waitUntilRejoinComplete();
        this.rejoinWorker.shutdown();
        if (this.clusteredInstanceFactory != null) {
            this.shutdownClusteredInstanceFactoryWrapper(this.clusteredInstanceFactory);
        }
    }

    private void shutdownClusteredInstanceFactoryWrapper(ClusteredInstanceFactoryWrapper clusteredInstanceFactory) {
        clusteredInstanceFactory.getActualFactory().getTopology().getTopologyListeners().clear();
        clusteredInstanceFactory.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ClusteredInstanceFactoryWrapper createNewClusteredInstanceFactory(Map<String, CacheConfiguration> cacheConfigs) {
        ClusteredInstanceFactory factory;
        if (this.clusteredInstanceFactory != null) {
            this.info("Shutting down old ClusteredInstanceFactory...");
            this.shutdownClusteredInstanceFactoryWrapper(this.clusteredInstanceFactory);
        }
        this.info("Creating new ClusteredInstanceFactory");
        CacheCluster underlyingCacheCluster = null;
        try {
            factory = TerracottaClusteredInstanceHelper.getInstance().newClusteredInstanceFactory(cacheConfigs, this.terracottaClientConfiguration);
            underlyingCacheCluster = factory.getTopology();
        }
        finally {
            if (this.isRejoinEnabled()) {
                if (underlyingCacheCluster != null) {
                    underlyingCacheCluster.addTopologyListener(new NodeLeftListener(this, underlyingCacheCluster.waitUntilNodeJoinsCluster()));
                } else {
                    this.warn("Unable to register node left listener for rejoin");
                }
            }
        }
        if (!this.rejoinWorker.isRejoinInProgress()) {
            this.cacheCluster.setUnderlyingCacheCluster(underlyingCacheCluster);
        }
        return new ClusteredInstanceFactoryWrapper(this, factory);
    }

    protected void waitUntilRejoinComplete() {
        this.rejoinWorker.waitUntilRejoinComplete();
    }

    private synchronized ExecutorService getL1TerminatorThreadPool() {
        if (this.l1TerminatorThreadPool == null) {
            this.l1TerminatorThreadPool = Executors.newCachedThreadPool(new ThreadFactory(){
                private final ThreadGroup threadGroup = new ThreadGroup("Rejoin Terminator Thread Group");

                public Thread newThread(Runnable runnable) {
                    Thread t = new Thread(this.threadGroup, runnable, "L1 Terminator");
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        return this.l1TerminatorThreadPool;
    }

    private void rejoinCluster(final ClusterNode oldNode) {
        if (!this.isRejoinEnabled()) {
            return;
        }
        Runnable rejoinRunnable = new Runnable(){

            public void run() {
                if (TerracottaClient.this.rejoinWorker.isRejoinInProgress()) {
                    TerracottaClient.this.debug("Current node (" + oldNode.getId() + ") left before rejoin could complete, force terminating current client");
                    if (TerracottaClient.this.clusteredInstanceFactory != null) {
                        TerracottaClient.this.info("Shutting down old client");
                        TerracottaClient.this.shutdownClusteredInstanceFactoryWrapper(TerracottaClient.this.clusteredInstanceFactory);
                        TerracottaClient.this.clusteredInstanceFactory = null;
                    } else {
                        TerracottaClient.this.warn("Current node (" + oldNode.getId() + ") left before rejoin could complete, but previous client is null");
                    }
                    TerracottaClient.this.debug("Interrupting rejoin thread");
                    TerracottaClient.this.rejoinWorker.rejoinThread.interrupt();
                }
                TerracottaClient.this.debug("Going to initiate rejoin");
                TerracottaClient.this.rejoinWorker.startRejoin(oldNode);
            }
        };
        if (this.rejoinWorker.isRejoinInProgress()) {
            this.rejoinWorker.setForcedShutdown();
            this.getL1TerminatorThreadPool().execute(rejoinRunnable);
        } else {
            rejoinRunnable.run();
        }
    }

    private boolean isRejoinEnabled() {
        return this.terracottaClientConfiguration != null && this.terracottaClientConfiguration.isRejoin();
    }

    private void info(String msg) {
        this.info(msg, null);
    }

    private void info(String msg, Throwable t) {
        if (t == null) {
            LOGGER.info(this.getLogPrefix() + msg);
        } else {
            LOGGER.info(this.getLogPrefix() + msg, t);
        }
    }

    private String getLogPrefix() {
        return "Thread [" + Thread.currentThread().getName() + "] [cacheManager: " + this.getCacheManagerName() + "]: ";
    }

    private void debug(String msg) {
        LOGGER.debug(this.getLogPrefix() + msg);
    }

    private void warn(String msg) {
        LOGGER.warn(this.getLogPrefix() + msg);
    }

    private String getCacheManagerName() {
        if (this.cacheManager.isNamed()) {
            return "'" + this.cacheManager.getName() + "'";
        }
        return "no name";
    }

    private static class FireRejoinEventListener
    implements ClusterTopologyListener {
        private final CountDownLatch latch;
        private final ClusterNode currentNode;

        public FireRejoinEventListener(ClusterNode currentNode, CountDownLatch latch) {
            this.currentNode = currentNode;
            this.latch = latch;
        }

        public void nodeJoined(ClusterNode node) {
            if (node.equals(this.currentNode)) {
                this.latch.countDown();
            }
        }

        public void clusterOnline(ClusterNode node) {
            if (node.equals(this.currentNode)) {
                this.latch.countDown();
            }
        }

        public void nodeLeft(ClusterNode node) {
        }

        public void clusterOffline(ClusterNode node) {
        }

        public void clusterRejoined(ClusterNode oldNode, ClusterNode newNode) {
        }
    }

    private static class RejoinStatus {
        private volatile RejoinState state = RejoinState.NOT_IN_PROGRESS;

        private RejoinStatus() {
        }

        public boolean isRejoinInProgress() {
            return this.state == RejoinState.IN_PROGRESS;
        }

        public synchronized void waitUntilRejoinComplete() {
            boolean interrupted = false;
            while (this.state == RejoinState.IN_PROGRESS) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }

        public synchronized void rejoinStarted() {
            this.state = RejoinState.IN_PROGRESS;
            this.notifyAll();
        }

        public synchronized void rejoinComplete() {
            this.state = RejoinState.NOT_IN_PROGRESS;
            this.notifyAll();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum RejoinState {
            IN_PROGRESS,
            NOT_IN_PROGRESS;

        }
    }

    private static class NodeLeftListener
    implements ClusterTopologyListener {
        private final ClusterNode currentNode;
        private final TerracottaClient client;

        public NodeLeftListener(TerracottaClient client, ClusterNode currentNode) {
            this.client = client;
            this.currentNode = currentNode;
            client.info("Registered interest for rejoin, current node: " + currentNode.getId());
        }

        public void nodeLeft(ClusterNode node) {
            this.client.info("ClusterNode [id=" + node.getId() + "] left the cluster (currentNode=" + this.currentNode.getId() + ")");
            if (node.equals(this.currentNode)) {
                this.client.rejoinCluster(node);
            }
        }

        public void clusterOffline(ClusterNode node) {
            this.client.info("ClusterNode [id=" + node.getId() + "] went offline (currentNode=" + this.currentNode.getId() + ")");
        }

        public void clusterOnline(ClusterNode node) {
            this.client.info("ClusterNode [id=" + node.getId() + "] became online (currentNode=" + this.currentNode.getId() + ")");
        }

        public void nodeJoined(ClusterNode node) {
            this.client.info("ClusterNode [id=" + node.getId() + "] joined the cluster (currentNode=" + this.currentNode.getId() + ")");
        }

        public void clusterRejoined(ClusterNode oldNode, ClusterNode newNode) {
            this.client.info("ClusterNode [id=" + oldNode.getId() + "] rejoined cluster as ClusterNode [id=" + newNode.getId() + "] (currentNode=" + this.currentNode.getId() + ")");
        }
    }

    private static class RejoinRequest {
        private final ClusterNode oldNode;

        public RejoinRequest(ClusterNode oldNode) {
            this.oldNode = oldNode;
        }

        public ClusterNode getRejoinOldNode() {
            return this.oldNode;
        }

        public String toString() {
            return "RejoinRequest [oldNode=" + this.oldNode.getId() + "]";
        }
    }

    private static class RejoinRequestHolder {
        private RejoinRequest outstandingRequest;

        private RejoinRequestHolder() {
        }

        public synchronized void addRejoinRequest(ClusterNode oldNode) {
            this.outstandingRequest = new RejoinRequest(oldNode);
        }

        public synchronized RejoinRequest consume() {
            if (this.outstandingRequest == null) {
                return null;
            }
            RejoinRequest rv = this.outstandingRequest;
            this.outstandingRequest = null;
            return rv;
        }

        public synchronized boolean isRejoinRequested() {
            return this.outstandingRequest != null;
        }
    }

    private class RejoinWorker
    implements Runnable {
        private final Object rejoinSync = new Object();
        private final RejoinStatus rejoinStatus = new RejoinStatus();
        private final AtomicInteger rejoinCount = new AtomicInteger();
        private final RejoinRequestHolder rejoinRequestHolder = new RejoinRequestHolder();
        private volatile boolean shutdown;
        private volatile Thread rejoinThread;
        private volatile boolean forcedShutdown;

        private RejoinWorker() {
        }

        public void run() {
            this.rejoinThread = Thread.currentThread();
            block2: while (!this.shutdown) {
                this.waitUntilRejoinRequested();
                if (this.shutdown || this.isJVMShuttingDown()) break;
                boolean rejoined = false;
                RejoinRequest rejoinRequest = this.rejoinRequestHolder.consume();
                TerracottaClient.this.debug("Going to start rejoin for request: " + rejoinRequest);
                while (!rejoined) {
                    try {
                        this.doRejoin(rejoinRequest);
                        rejoined = true;
                    }
                    catch (Exception e) {
                        boolean forced = this.getAndClearForcedShutdown();
                        if (forced) {
                            TerracottaClient.this.info("Client was shutdown forcefully before rejoin completed", e);
                            continue block2;
                        }
                        LOGGER.warn("Caught exception while trying to rejoin cluster", (Throwable)e);
                        if (this.isError(e)) {
                            TerracottaClient.this.info("Rejoin worker thread exiting - unrecoverable error condition", e);
                            this.shutdown = true;
                            continue block2;
                        }
                        TerracottaClient.this.info("Trying to rejoin again in " + REJOIN_SLEEP_MILLIS_ON_EXCEPTION + " msecs...");
                        this.sleep(REJOIN_SLEEP_MILLIS_ON_EXCEPTION);
                    }
                }
            }
        }

        private boolean isError(Throwable t) {
            while (t != null) {
                if (t instanceof Error) {
                    return true;
                }
                t = t.getCause();
            }
            return false;
        }

        public synchronized boolean getAndClearForcedShutdown() {
            boolean rv = this.forcedShutdown;
            this.forcedShutdown = false;
            return rv;
        }

        public synchronized void setForcedShutdown() {
            this.forcedShutdown = true;
        }

        public boolean isRejoinInProgress() {
            return this.rejoinStatus.isRejoinInProgress();
        }

        public synchronized boolean isJVMShuttingDown() {
            try {
                Thread jvmShutdownCheckThread = new Thread();
                Runtime.getRuntime().addShutdownHook(jvmShutdownCheckThread);
                Runtime.getRuntime().removeShutdownHook(jvmShutdownCheckThread);
                return false;
            }
            catch (IllegalStateException e) {
                return true;
            }
        }

        private void sleep(long sleepMillis) {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.rejoinSync;
            synchronized (object) {
                this.shutdown = true;
                this.rejoinSync.notifyAll();
            }
        }

        private void doRejoin(RejoinRequest rejoinRequest) {
            if (rejoinRequest == null) {
                return;
            }
            DisconnectedClusterNode oldNodeReference = new DisconnectedClusterNode(rejoinRequest.getRejoinOldNode());
            this.rejoinStatus.rejoinStarted();
            if (Thread.currentThread().isInterrupted()) {
                TerracottaClient.this.info("Clearing interrupt state of rejoin thread");
                Thread.currentThread();
                Thread.interrupted();
            }
            int rejoinNumber = this.rejoinCount.incrementAndGet();
            TerracottaClient.this.info("Starting Terracotta Rejoin (as client id: " + (oldNodeReference == null ? "null" : oldNodeReference.getId()) + " left the cluster) [rejoin count = " + rejoinNumber + "] ... ");
            TerracottaClient.this.rejoinListener.clusterRejoinStarted();
            TerracottaClient.this.clusteredInstanceFactory = TerracottaClient.this.createNewClusteredInstanceFactory(Collections.emptyMap());
            TerracottaClient.this.rejoinListener.clusterRejoinComplete();
            this.fireClusterRejoinedEvent(oldNodeReference);
            TerracottaClient.this.info("Rejoin Complete [rejoin count = " + rejoinNumber + "]");
            this.rejoinStatus.rejoinComplete();
        }

        private void fireClusterRejoinedEvent(ClusterNode oldNodeReference) {
            TerracottaClient.this.cacheCluster.setUnderlyingCacheCluster(TerracottaClient.this.clusteredInstanceFactory.getActualFactory().getTopology());
            CountDownLatch latch = new CountDownLatch(2);
            FireRejoinEventListener fireRejoinEventListener = new FireRejoinEventListener(TerracottaClient.this.clusteredInstanceFactory.getActualFactory().getTopology().waitUntilNodeJoinsCluster(), latch);
            TerracottaClient.this.clusteredInstanceFactory.getActualFactory().getTopology().addTopologyListener(fireRejoinEventListener);
            this.waitUntilLatchOpen(latch);
            try {
                TerracottaClient.this.cacheCluster.fireNodeRejoinedEvent(oldNodeReference, TerracottaClient.this.cacheCluster.getCurrentNode());
            }
            catch (Throwable e) {
                LOGGER.error("Caught exception while firing rejoin event", e);
            }
            TerracottaClient.this.clusteredInstanceFactory.getActualFactory().getTopology().removeTopologyListener(fireRejoinEventListener);
        }

        private void waitUntilLatchOpen(CountDownLatch latch) {
            boolean done = false;
            do {
                try {
                    latch.await();
                    done = true;
                }
                catch (InterruptedException e) {
                    if (this.forcedShutdown) {
                        throw new CacheException(e);
                    }
                    LOGGER.info("Ignoring interrupted exception while waiting for latch");
                }
            } while (!done);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitUntilRejoinRequested() {
            String message = "Rejoin worker waiting until rejoin requested";
            List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
                String name = memoryPoolMXBean.getName();
                if (!name.contains("Perm Gen")) continue;
                MemoryUsage usage = memoryPoolMXBean.getUsage();
                message = message + " (" + name + " : " + MemoryUnit.BYTES.toMegaBytes(usage.getUsed()) + "M / " + MemoryUnit.BYTES.toMegaBytes(usage.getMax()) + "M)";
            }
            TerracottaClient.this.info(message + "...");
            Object object = this.rejoinSync;
            synchronized (object) {
                while (!this.rejoinRequestHolder.isRejoinRequested() && !this.shutdown) {
                    try {
                        this.rejoinSync.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startRejoin(ClusterNode oldNode) {
            Object object = this.rejoinSync;
            synchronized (object) {
                this.rejoinRequestHolder.addRejoinRequest(oldNode);
                this.rejoinSync.notifyAll();
            }
        }

        private void waitUntilRejoinComplete() {
            if (this.rejoinThread == Thread.currentThread()) {
                return;
            }
            if (TerracottaClient.this.isRejoinEnabled()) {
                this.rejoinStatus.waitUntilRejoinComplete();
            }
        }
    }
}

