/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwtsso.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConfigUtils {
    private static final TraceComponent tc = Tr.register(ConfigUtils.class, (String)"JWTSSO", (String)"com.ibm.ws.security.jwtsso.internal.resources.JWTSSOMessages");
    public static final String CFG_DEFAULT_COOKIENAME = "JWT";
    private static final String validCookieChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!#$%&'*+-.^_`|~";
    static final long serialVersionUID = 3852851897201490176L;

    public String validateCookieName(String cookieName, boolean quiet) {
        if (cookieName == null || cookieName.length() == 0) {
            if (!quiet) {
                Tr.error((TraceComponent)tc, (String)"COOKIE_NAME_CANT_BE_EMPTY", (Object[])new Object[0]);
            }
            return CFG_DEFAULT_COOKIENAME;
        }
        String cookieNameUc = cookieName.toUpperCase();
        boolean valid = true;
        for (int i = 0; i < cookieName.length(); ++i) {
            String eval = cookieNameUc.substring(i, i + 1);
            if (validCookieChars.contains(eval)) continue;
            if (!quiet) {
                Tr.error((TraceComponent)tc, (String)"COOKIE_NAME_INVALID", (Object[])new Object[]{cookieName, eval});
            }
            valid = false;
        }
        if (!valid) {
            return CFG_DEFAULT_COOKIENAME;
        }
        return cookieName;
    }
}

