/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import java.io.IOException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClientBase;
import org.apache.http.impl.nio.client.CloseableHttpPipeliningClient;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.util.Asserts;

abstract class CloseableHttpAsyncClientBase
extends CloseableHttpPipeliningClient {
    private final Log log = LogFactory.getLog(this.getClass());
    private final NHttpClientConnectionManager connmgr;
    private final Thread reactorThread;
    private final AtomicReference<Status> status;

    public CloseableHttpAsyncClientBase(NHttpClientConnectionManager connmgr, ThreadFactory threadFactory, NHttpClientEventHandler handler) {
        this.connmgr = connmgr;
        this.reactorThread = threadFactory != null && handler != null ? threadFactory.newThread((Runnable)new /* Unavailable Anonymous Inner Class!! */) : null;
        this.status = new AtomicReference<Status>(Status.INACTIVE);
    }

    public void start() {
        if (this.status.compareAndSet(Status.INACTIVE, Status.ACTIVE) && this.reactorThread != null) {
            this.reactorThread.start();
        }
    }

    protected void ensureRunning() {
        Status currentStatus = (Status)this.status.get();
        Asserts.check((currentStatus == Status.ACTIVE ? 1 : 0) != 0, (String)"Request cannot be executed; I/O reactor status: %s", (Object)currentStatus);
    }

    public void close() {
        if (this.status.compareAndSet(Status.ACTIVE, Status.STOPPED) && this.reactorThread != null) {
            try {
                this.connmgr.shutdown();
            }
            catch (IOException ex) {
                this.log.error((Object)"I/O error shutting down connection manager", (Throwable)ex);
            }
            try {
                this.reactorThread.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isRunning() {
        return this.status.get() == Status.ACTIVE;
    }

    static /* synthetic */ Log access$000(CloseableHttpAsyncClientBase x0) {
        return x0.log;
    }

    static /* synthetic */ AtomicReference access$100(CloseableHttpAsyncClientBase x0) {
        return x0.status;
    }
}

