/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.binding;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.impl.Saml20HTTPPostDecoder;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import com.ibm.ws.security.saml.sso20.metadata.AcsDOMMetadataProvider;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPPostDecoder;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BasicMessageContextBuilder<InboundMessageType extends SAMLObject, OutboundMessageType extends SAMLObject, NameIdentifierType extends SAMLObject> {
    private static TraceComponent tc = Tr.register(BasicMessageContextBuilder.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    static BasicMessageContextBuilder<?, ?, ?> instance = new BasicMessageContextBuilder();
    static final long serialVersionUID = 1087992428369251503L;

    public static void setInstance(BasicMessageContextBuilder<?, ?, ?> instance) {
        BasicMessageContextBuilder.instance = instance;
    }

    public static BasicMessageContextBuilder<?, ?, ?> getInstance() {
        return instance;
    }

    BasicMessageContext<InboundMessageType, OutboundMessageType> getBasicMessageContext(SsoSamlService ssoService) {
        return new BasicMessageContext(ssoService);
    }

    BasicMessageContext<InboundMessageType, OutboundMessageType> getBasicMessageContext(SsoSamlService ssoService, HttpServletRequest request, HttpServletResponse response) {
        return new BasicMessageContext(ssoService, request, response);
    }

    public BasicMessageContext<InboundMessageType, OutboundMessageType> buildAcs(HttpServletRequest req, HttpServletResponse res, SsoSamlService ssoService, String externalRelayState, SsoRequest samlRequest) throws SamlException {
        BasicMessageContext<InboundMessageType, OutboundMessageType> basicMessageContext = this.getBasicMessageContext(ssoService, req, res);
        basicMessageContext.setAndRemoveCachedRequestInfo(externalRelayState, samlRequest);
        this.setIdpMetadaProvider(basicMessageContext);
        this.decodeSamlResponse(basicMessageContext, req);
        return basicMessageContext;
    }

    public BasicMessageContext<InboundMessageType, OutboundMessageType> buildSLO(HttpServletRequest req, HttpServletResponse res, SsoSamlService ssoService, String externalRelayState, SsoRequest samlRequest) throws SamlException {
        BasicMessageContext<InboundMessageType, OutboundMessageType> basicMessageContext = this.getBasicMessageContext(ssoService, req, res);
        basicMessageContext.setAndRemoveCachedRequestInfo(externalRelayState, samlRequest);
        this.setIdpMetadaProvider(basicMessageContext);
        this.decodeSamlLogoutMessage(basicMessageContext, req);
        return basicMessageContext;
    }

    public BasicMessageContext<InboundMessageType, OutboundMessageType> buildRsSaml(HttpServletRequest req, HttpServletResponse res, SsoSamlService ssoService, String headerCpontent, SsoRequest samlRequest) throws SamlException {
        BasicMessageContext<InboundMessageType, OutboundMessageType> basicMessageContext = this.getBasicMessageContext(ssoService, req, res);
        basicMessageContext.setMessageContext((MessageContext<SAMLObject>)new MessageContext());
        return basicMessageContext;
    }

    public BasicMessageContext<InboundMessageType, OutboundMessageType> buildIdp(HttpServletRequest req, HttpServletResponse res, SsoSamlService ssoService) throws SamlException {
        BasicMessageContext<InboundMessageType, OutboundMessageType> basicMessageContext = this.getBasicMessageContext(ssoService);
        this.setIdpMetadaProvider(basicMessageContext);
        return basicMessageContext;
    }

    /*
     * WARNING - void declaration
     */
    public boolean decodeSamlResponse(BasicMessageContext<InboundMessageType, OutboundMessageType> basicMessageContext, HttpServletRequest req) throws SamlException {
        String acsUrl = RequestUtil.getAcsUrl(basicMessageContext.getHttpServletRequest(), "/ibm/saml20/", basicMessageContext.getSsoService().getProviderId(), basicMessageContext.getSsoConfig());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"acsUrl:", (Object[])new Object[]{acsUrl});
        }
        try {
            HTTPPostDecoder samlMessageDecoder = this.getSamlHttpPostDecoder(acsUrl, req);
            samlMessageDecoder.decode();
            basicMessageContext.setMessageContext((MessageContext<SAMLObject>)samlMessageDecoder.getMessageContext());
        }
        catch (Exception samlMessageDecoder) {
            void e;
            FFDCFilter.processException((Throwable)samlMessageDecoder, (String)"com.ibm.ws.security.saml.sso20.binding.BasicMessageContextBuilder", (String)"134", (Object)this, (Object[])new Object[]{basicMessageContext, req});
            throw BasicMessageContextBuilder.decodeError((Exception)e);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean decodeSamlLogoutMessage(BasicMessageContext<InboundMessageType, OutboundMessageType> basicMessageContext, HttpServletRequest req) throws SamlException {
        String sloUrl = RequestUtil.getSloUrl(basicMessageContext.getHttpServletRequest(), "/ibm/saml20/", basicMessageContext.getSsoService().getProviderId(), basicMessageContext.getSsoConfig());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SLO Url:", (Object[])new Object[]{sloUrl});
        }
        try {
            HTTPPostDecoder samlMessageDecoder = this.getSamlHttpPostDecoder(sloUrl, req);
            samlMessageDecoder.decode();
            basicMessageContext.setMessageContext((MessageContext<SAMLObject>)samlMessageDecoder.getMessageContext());
        }
        catch (Exception samlMessageDecoder) {
            void e;
            FFDCFilter.processException((Throwable)samlMessageDecoder, (String)"com.ibm.ws.security.saml.sso20.binding.BasicMessageContextBuilder", (String)"156", (Object)this, (Object[])new Object[]{basicMessageContext, req});
            throw BasicMessageContextBuilder.decodeError((Exception)e);
        }
        return true;
    }

    HTTPPostDecoder getSamlHttpPostDecoder(String acsUrl, HttpServletRequest req) throws ComponentInitializationException {
        Saml20HTTPPostDecoder decoder = new Saml20HTTPPostDecoder(acsUrl);
        decoder.setHttpServletRequest(req);
        decoder.setParserPool(XMLObjectProviderRegistrySupport.getParserPool());
        decoder.initialize();
        return decoder;
    }

    BasicMessageContext<InboundMessageType, OutboundMessageType> setIdpMetadaProvider(BasicMessageContext<InboundMessageType, OutboundMessageType> messageContext) throws SamlException {
        SsoConfig samlConfig = messageContext.getSsoConfig();
        AcsDOMMetadataProvider acsIdpMetadataProvider = samlConfig.getIdpMetadataProvider();
        messageContext.setMetadataProvider(acsIdpMetadataProvider);
        return messageContext;
    }

    public static SamlException decodeError(Exception e) {
        String msg = e.getMessage();
        String className = e.getClass().getName();
        SamlException result = new SamlException("SAML20_DECODE_SAML_RESPONSE_FAILURE_LOG", e, new Object[]{msg, className});
        return result;
    }
}

