/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.wls;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.platform.server.ServerPlatformDetector;

public class WebLogicPlatformDetector
implements ServerPlatformDetector {
    @Override
    public String checkPlatform() {
        String platform;
        block15: {
            platform = null;
            String serverNameAndVersion = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return WebLogicPlatformDetector.this.getServerNameAndVersionInternal();
                }
            }) : this.getServerNameAndVersionInternal();
            if (serverNameAndVersion == null) break block15;
            int idx = serverNameAndVersion.indexOf(46);
            switch (serverNameAndVersion.substring(0, idx)) {
                case "12": {
                    platform = "WebLogic_12";
                    break;
                }
                case "10": 
                case "11": {
                    platform = "WebLogic_10";
                    break;
                }
                case "9": {
                    platform = "WebLogic_9";
                    break;
                }
                default: {
                    platform = "WebLogic";
                }
            }
        }
        return platform;
    }

    private String getServerNameAndVersionInternal() {
        try {
            String loaderStr = WebLogicPlatformDetector.class.getClassLoader().getClass().getName();
            if (loaderStr.contains("weblogic")) {
                Class<?> versionCls = Class.forName("weblogic.version");
                Method method = versionCls.getMethod("getReleaseBuildVersion", new Class[0]);
                return (String)method.invoke(null, new Object[0]);
            }
        }
        catch (Throwable throwable) {}
        return null;
    }
}

