/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.expression;

import jakarta.data.constraint.Like;
import jakarta.data.constraint.NotLike;
import jakarta.data.expression.ComparableExpression;
import jakarta.data.expression.NumericExpression;
import jakarta.data.restrict.BasicRestriction;
import jakarta.data.restrict.Restriction;
import jakarta.data.spi.expression.function.NumericFunctionExpression;
import jakarta.data.spi.expression.function.TextFunctionExpression;

public interface TextExpression<T>
extends ComparableExpression<T, String> {
    default public TextExpression<T> append(String suffix) {
        return TextFunctionExpression.of("concat", this, suffix);
    }

    default public TextExpression<T> append(TextExpression<? super T> suffixExpression) {
        return TextFunctionExpression.of("concat", suffixExpression, this);
    }

    default public Restriction<T> contains(String substring) {
        Like constraint = Like.substring(substring);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> endsWith(String suffix) {
        Like constraint = Like.suffix(suffix);
        return BasicRestriction.of(this, constraint);
    }

    default public TextExpression<T> left(int length) {
        return TextFunctionExpression.of("left", this, length);
    }

    default public NumericExpression<T, Integer> length() {
        return NumericFunctionExpression.of("length", this);
    }

    default public Restriction<T> like(Like pattern) {
        return BasicRestriction.of(this, pattern);
    }

    default public Restriction<T> like(String pattern) {
        Like constraint = Like.pattern(pattern);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> like(String pattern, char charWildcard, char stringWildcard) {
        Like constraint = Like.pattern(pattern, charWildcard, stringWildcard);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> like(String pattern, char charWildcard, char stringWildcard, char escape) {
        Like constraint = Like.pattern(pattern, charWildcard, stringWildcard, escape);
        return BasicRestriction.of(this, constraint);
    }

    default public TextExpression<T> lower() {
        return TextFunctionExpression.of("lower", this);
    }

    default public Restriction<T> notContains(String substring) {
        NotLike constraint = NotLike.substring(substring);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> notEndsWith(String suffix) {
        NotLike constraint = NotLike.suffix(suffix);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> notLike(String pattern) {
        NotLike constraint = NotLike.pattern(pattern);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> notLike(String pattern, char charWildcard, char stringWildcard) {
        NotLike constraint = NotLike.pattern(pattern, charWildcard, stringWildcard);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> notLike(String pattern, char charWildcard, char stringWildcard, char escape) {
        NotLike constraint = NotLike.pattern(pattern, charWildcard, stringWildcard, escape);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> notStartsWith(String prefix) {
        NotLike constraint = NotLike.prefix(prefix);
        return BasicRestriction.of(this, constraint);
    }

    default public TextExpression<T> prepend(String prefix) {
        return TextFunctionExpression.of("concat", prefix, this);
    }

    default public TextExpression<T> prepend(TextExpression<? super T> prefixExpression) {
        return TextFunctionExpression.of("concat", prefixExpression, this);
    }

    default public TextExpression<T> right(int length) {
        return TextFunctionExpression.of("right", this, length);
    }

    default public Restriction<T> startsWith(String prefix) {
        Like constraint = Like.prefix(prefix);
        return BasicRestriction.of(this, constraint);
    }

    default public TextExpression<T> upper() {
        return TextFunctionExpression.of("upper", this);
    }
}

