/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.sip.channel.resolver;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SIPUri {
    static final TraceComponent tc = Tr.register(SIPUri.class);
    public static final String SIP_SCHEME = "sip:";
    public static final String SIPS_SCHEME = "sips:";
    private String URI = null;
    private String scheme = null;
    private String userInfo = null;
    private String host = null;
    private String port = null;
    private String mAddr = null;
    private String transport = null;
    protected String additionalParameters = null;
    boolean changed = false;
    boolean parsed = false;
    private boolean ipV6addr = false;

    public static SIPUri createSIPUri(String originalUri) {
        SIPUri sipUri = new SIPUri();
        sipUri.setURI(originalUri);
        return sipUri;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof SIPUri)) {
            return false;
        }
        this.parseUri();
        SIPUri uri = (SIPUri)o;
        if (this.scheme == null) {
            if (uri.getScheme() != null) {
                return false;
            }
        } else {
            if (uri.getScheme() == null) {
                return false;
            }
            if (!uri.getScheme().equals(this.scheme)) {
                return false;
            }
        }
        if (this.host == null) {
            if (uri.getHost() != null) {
                return false;
            }
        } else {
            if (uri.getHost() == null) {
                return false;
            }
            if (!uri.getHost().equals(this.host)) {
                return false;
            }
        }
        if (this.port == null) {
            if (uri.getPort() != null) {
                return false;
            }
        } else {
            if (uri.getPort() == null) {
                return false;
            }
            if (!uri.getPort().equals(this.port)) {
                return false;
            }
        }
        if (this.mAddr == null) {
            if (uri.getMaddr() != null) {
                return false;
            }
        } else {
            if (uri.getMaddr() == null) {
                return false;
            }
            if (!uri.getMaddr().equals(this.mAddr)) {
                return false;
            }
        }
        if (this.transport == null) {
            if (uri.getTransport() != null) {
                return false;
            }
        } else {
            if (uri.getTransport() == null) {
                return false;
            }
            if (!uri.getTransport().equals(this.transport)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.scheme != null) {
            hashCode += this.scheme.hashCode();
        }
        if (this.host != null) {
            hashCode += this.host.hashCode();
        }
        if (this.port != null) {
            hashCode += this.port.hashCode();
        }
        if (this.mAddr != null) {
            hashCode += this.mAddr.hashCode();
        }
        if (this.transport != null) {
            hashCode += this.transport.hashCode();
        }
        return hashCode;
    }

    public String getURI() {
        if (this.changed) {
            this.changed = false;
            this.URI = this.scheme;
            if (this.userInfo != null) {
                this.URI = this.URI + this.userInfo + "@";
            }
            this.URI = this.URI + this.host;
            if (this.port != null) {
                this.URI = this.URI + ":" + this.port;
            }
            this.URI = this.URI + this.additionalParameters;
        }
        return this.URI;
    }

    public void setURI(String uri) {
        this.URI = uri;
        this.changed = false;
        this.parsed = false;
        this.scheme = null;
        this.userInfo = null;
        this.host = null;
        this.port = null;
        this.mAddr = null;
        this.transport = null;
        this.additionalParameters = null;
    }

    protected void parseUri() {
        if (!this.parsed && this.URI != null) {
            this.parsed = true;
            String tempString = this.URI;
            int index = tempString.indexOf("<");
            if (index != -1) {
                tempString = tempString.substring(index + 1);
            }
            this.scheme = (index = tempString.indexOf(SIP_SCHEME)) == -1 ? ((index = tempString.indexOf(SIPS_SCHEME)) == -1 ? new String(tempString.substring(0, tempString.indexOf(":") + 1)) : SIPS_SCHEME) : SIP_SCHEME;
            tempString = tempString.substring(this.scheme.length());
            index = tempString.indexOf("@");
            if (index != -1) {
                this.userInfo = tempString.substring(0, index);
                tempString = tempString.substring(index + 1);
            }
            String hostPort = null;
            index = tempString.indexOf(";");
            if (index != -1) {
                hostPort = tempString.substring(0, index);
            } else {
                hostPort = tempString;
                index = tempString.length();
            }
            int leftSquareBracketIndex = hostPort.indexOf("[");
            if (leftSquareBracketIndex != -1) {
                int rightSquareBracketIndex = hostPort.indexOf("]");
                if (rightSquareBracketIndex != -1) {
                    this.ipV6addr = true;
                    this.host = hostPort.substring(leftSquareBracketIndex + 1, rightSquareBracketIndex);
                    int colonIndex = hostPort.indexOf(":", rightSquareBracketIndex);
                    this.port = colonIndex != -1 ? hostPort.substring(colonIndex + 1, index) : new String("5060");
                }
            } else {
                int colonIndex = hostPort.indexOf(":");
                int bracketIndex = hostPort.indexOf(">");
                int semiIndex = hostPort.indexOf(";");
                if (bracketIndex != -1) {
                    index = bracketIndex;
                }
                if (semiIndex != -1 && semiIndex < bracketIndex) {
                    index = semiIndex;
                }
                if (colonIndex != -1) {
                    this.host = hostPort.substring(0, colonIndex);
                    this.port = hostPort.substring(colonIndex + 1, index);
                } else {
                    this.host = hostPort.substring(0, index);
                    this.port = new String("5060");
                }
            }
            this.additionalParameters = tempString = tempString.substring(hostPort.length());
            this.parseAdditionalParameters(this.additionalParameters);
        }
    }

    private void parseAdditionalParameters(String additionalParameters) {
        if (additionalParameters.length() > 1) {
            try {
                StringTokenizer tokenizer = new StringTokenizer(additionalParameters, ";=");
                while (true) {
                    String token;
                    if ((token = tokenizer.nextToken()).compareToIgnoreCase("maddr") == 0) {
                        this.mAddr = tokenizer.nextToken();
                        continue;
                    }
                    if (token.compareToIgnoreCase("transport") == 0) {
                        this.transport = tokenizer.nextToken();
                        continue;
                    }
                    tokenizer.nextToken();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public String getHost() {
        this.parseUri();
        return this.host;
    }

    public String getPort() {
        this.parseUri();
        return this.port;
    }

    public String getScheme() {
        this.parseUri();
        return this.scheme;
    }

    public String getUserInfo() {
        this.parseUri();
        return this.userInfo;
    }

    public void setHost(String string) {
        this.parseUri();
        this.changed = true;
        this.host = string;
    }

    public void setPort(String string) {
        this.parseUri();
        this.changed = true;
        this.port = string;
    }

    public void setScheme(String string) {
        this.parseUri();
        this.changed = true;
        this.scheme = string;
    }

    public void setUserInfo(String string) {
        this.parseUri();
        this.changed = true;
        this.userInfo = string;
    }

    public String getBaseSIPUri() {
        this.parseUri();
        String baseUri = new String();
        baseUri = this.scheme;
        if (this.userInfo != null) {
            baseUri = baseUri + this.userInfo + "@";
        }
        baseUri = baseUri + this.getHostnamePortCombo();
        return baseUri;
    }

    public String getHostnamePortCombo() {
        this.parseUri();
        String hostnamePort = new String();
        hostnamePort = this.host;
        if (this.port != null) {
            hostnamePort = hostnamePort + ":" + this.port;
        }
        hostnamePort = this.ipV6addr ? "[" + this.host + "]" : this.host;
        if (this.port != null) {
            hostnamePort = hostnamePort + ":" + this.port;
        }
        return hostnamePort;
    }

    public String getBaseSIPUriWithoutSchema() {
        this.parseUri();
        String baseUri = new String();
        if (this.userInfo != null) {
            baseUri = baseUri + this.userInfo + "@";
        }
        baseUri = baseUri + this.getHostnamePortCombo();
        return baseUri;
    }

    public String getAdditionalParms() {
        this.parseUri();
        return this.additionalParameters;
    }

    public void setAdditionalParms(String string) {
        this.parseUri();
        this.changed = true;
        this.additionalParameters = string;
    }

    public void setPortInt(int p) {
        this.parseUri();
        this.changed = true;
        this.port = Integer.toString(p);
    }

    public int getPortInt() {
        this.parseUri();
        if (this.port != null) {
            return Integer.parseInt(this.port);
        }
        return -1;
    }

    public void setTransport(String s) {
        this.parseUri();
        this.changed = true;
        this.transport = s;
    }

    public String getTransport() {
        this.parseUri();
        return this.transport;
    }

    public void setMaddr(String s) {
        this.parseUri();
        this.changed = true;
        this.mAddr = s;
    }

    public String getMaddr() {
        this.parseUri();
        return this.mAddr;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"version : ", (Object)"1.14 ");
        }
    }
}

