/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.transaction;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.proxy.StatefullProxy;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.transaction.TransactionListener;
import com.ibm.ws.sip.container.transaction.TransactionTable;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.SipServletResponse;

public abstract class SipTransaction {
    private static final LogMgr c_logger = Log.get(SipTransaction.class);
    protected SipServletRequestImpl m_originalRequest;
    private long m_transactionID = -1L;
    private Proxy m_proxy = null;
    protected TransactionListener m_listener;
    private boolean m_isTerminated = false;

    public SipTransaction(long transactionID, SipServletRequestImpl request) {
        this.m_transactionID = transactionID;
        this.m_originalRequest = request;
    }

    public SipTransaction(SipServletRequestImpl request) {
        this.m_originalRequest = request;
    }

    public long getTransactionID() {
        return this.m_transactionID;
    }

    protected void setId(long transactionId) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{new Long(transactionId)};
            c_logger.traceEntry((Object)this, "setId", params);
        }
        if (this.getTransactionID() != -1L && c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setId", "Reuse this transaction in NAPTR usage case");
        }
        this.m_transactionID = transactionId;
    }

    public SipServletRequestImpl getOriginalRequest() {
        return this.m_originalRequest;
    }

    protected TransactionUserWrapper getTransactionUser() {
        return this.m_originalRequest.getTransactionUser();
    }

    public Proxy getProxy(boolean create) {
        if (null == this.m_proxy && create) {
            this.m_proxy = new StatefullProxy(this.m_originalRequest);
        }
        return this.m_proxy;
    }

    public void onFinalResponse(SipServletResponse response) {
        this.markAsTerminated();
        this.removeFromTransactionTable(response != null ? response.getMethod() : null);
    }

    protected void removeFromTransactionTable(String method) {
        TransactionTable tt = TransactionTable.getInstance();
        boolean removedTransaction = tt.removeTransaction(this);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "removeFromTransactionTable", "Cleaned Up Transaction: " + tt + " transaction found ? = " + removedTransaction);
        }
        if (removedTransaction && this.m_listener != null) {
            this.m_listener.removeTransaction(method);
            this.notifyDerivedTUs();
        }
        this.transactionTerminated(this.m_originalRequest);
    }

    protected abstract void notifyDerivedTUs();

    public abstract void addReferece(TransactionUserWrapper var1);

    protected abstract void transactionTerminated(SipServletRequestImpl var1);

    public void processTimeout() {
        this.markAsTerminated();
        this.removeFromTransactionTable(this.getOriginalRequest().getMethod());
    }

    public void markAsTerminated() {
        this.m_isTerminated = true;
    }

    public synchronized boolean isTerminated() {
        return this.m_isTerminated;
    }

    public void setTransactionListener(TransactionListener listener) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "setTransactionListener", (Object)("New listener=" + listener));
        }
        boolean replaceExistingListener = false;
        if (this.m_listener != listener) {
            if (this.m_listener != null) {
                this.replaceListener();
                replaceExistingListener = true;
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setTransactionListener", "Replace the old one = " + this.m_listener + " with the new one = " + listener);
            }
            this.m_listener = listener;
            if (!replaceExistingListener && this.m_originalRequest != null && !this.m_originalRequest.getMethod().equals("ACK")) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "setTransactionListener", "Add transaction to new listener");
                }
                this.m_listener.addTransaction(this.m_originalRequest.getMethod());
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setTransactionListener", "Not adding new transaction to related listener for ACK message");
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "setTransactionListener");
        }
    }

    protected abstract void replaceListener();
}

