/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.AbstractObjectStore;
import com.ibm.ws.objectManager.AbstractSetView;
import com.ibm.ws.objectManager.ConcurrentHashMap;
import com.ibm.ws.objectManager.Iterator;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.Set;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.util.Map;

public class MemoryObjectStore
extends AbstractObjectStore {
    private static final Class cclass = MemoryObjectStore.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerStore");
    private static final long serialVersionUID = 219689509007536977L;
    private transient Map inMemoryManagedObjects;
    private transient Set tokenSet;

    public MemoryObjectStore(String storeName, ObjectManager objectManager) throws ObjectManagerException {
        super(storeName, objectManager, 1);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", "StoreName=" + storeName + ", ObjectManager=" + objectManager);
            trace.exit(this, cclass, "<init>");
        }
    }

    @Override
    public synchronized void open(ObjectManagerState objectManagerState) throws ObjectManagerException {
        String methodName = "open";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "open", new Object[]{objectManagerState});
        }
        super.open(objectManagerState);
        this.usesSerializedForm = false;
        this.inMemoryManagedObjects = new ConcurrentHashMap(64);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "open");
        }
    }

    @Override
    public ManagedObject get(Token token) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "get", token);
            trace.exit(this, cclass, "get returns null");
        }
        return null;
    }

    @Override
    public void add(ManagedObject managedObject, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
        String methodName = "add";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "add", new Object[]{managedObject, new Boolean(requiresCurrentCheckpoint)});
        }
        super.add(managedObject, requiresCurrentCheckpoint);
        this.inMemoryManagedObjects.put(new Long(managedObject.owningToken.storedObjectIdentifier), managedObject);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "add");
        }
    }

    @Override
    public void remove(Token token, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "remove", new Object[]{token, new Boolean(requiresCurrentCheckpoint)});
        }
        super.remove(token, requiresCurrentCheckpoint);
        this.inMemoryManagedObjects.remove(new Long(token.storedObjectIdentifier));
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "remove");
        }
    }

    @Override
    protected synchronized void clear() throws ObjectManagerException {
        String methodName = "clear";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "clear");
        }
        super.clear();
        this.inMemoryManagedObjects = new ConcurrentHashMap(64);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "clear");
        }
    }

    @Override
    public synchronized void flush() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "flush");
            trace.exit(this, cclass, "flush");
        }
    }

    @Override
    public Set tokens() {
        if (this.tokenSet == null) {
            this.tokenSet = new AbstractSetView(){

                @Override
                public long size() {
                    return MemoryObjectStore.this.inMemoryManagedObjects.size();
                }

                @Override
                public Iterator iterator() {
                    final java.util.Iterator tokenIterator = MemoryObjectStore.this.inMemoryTokens.values().iterator();
                    return new Iterator(){

                        @Override
                        public boolean hasNext() {
                            return tokenIterator.hasNext();
                        }

                        @Override
                        public Object next() {
                            return tokenIterator.next();
                        }

                        @Override
                        public boolean hasNext(Transaction transaction) throws ObjectManagerException {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Object next(Transaction transaction) throws ObjectManagerException {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public Object remove(Transaction transaction) throws ObjectManagerException {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        return this.tokenSet;
    }
}

