/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.model.callbacks;

import com.ibm.ws.microprofile.openapi.model.utils.OpenAPIUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;

public class CallbackImpl
extends LinkedHashMap<String, PathItem>
implements Callback {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> extensions = null;
    private String $ref = null;

    public Callback addPathItem(String name, PathItem item) {
        if (item == null) {
            return this;
        }
        this.put(name, item);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CallbackImpl) {
            CallbackImpl callback = (CallbackImpl)o;
            return Objects.equals(this.extensions, callback.extensions) && super.equals(o);
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.extensions, super.hashCode());
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public Callback addExtension(String name, Object value) {
        if (value == null) {
            return this;
        }
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(name, value);
        return this;
    }

    public void removeExtension(String key) {
        if (this.extensions != null) {
            this.extensions.remove(key);
        }
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Callback {\n");
        sb = super.toString() != null ? sb.append("    ").append(this.toIndentedString(super.toString())).append("\n") : sb.append("");
        sb = this.$ref != null ? sb.append("    $ref: ").append(this.toIndentedString(this.$ref)).append("\n") : sb.append("");
        sb = this.extensions != null ? sb.append("    extensions: ").append(OpenAPIUtils.mapToString(this.extensions)).append("\n") : sb.append("");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String getRef() {
        return this.$ref;
    }

    public void setRef(String ref) {
        if (ref != null && ref.indexOf(".") == -1 && ref.indexOf("/") == -1) {
            ref = "#/components/callbacks/" + ref;
        }
        this.$ref = ref;
    }

    public Callback ref(String ref) {
        this.setRef(ref);
        return this;
    }

    public Map<String, PathItem> getPathItems() {
        return Collections.unmodifiableMap(this);
    }

    public void removePathItem(String key) {
        this.remove(key);
    }

    public void setPathItems(Map<String, PathItem> pathItems) {
        this.clear();
        this.putAll(pathItems);
    }
}

