/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.plugins;

import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OAuthConfigurationException;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidResponseTypeException;
import com.ibm.oauth.core.internal.oauth20.config.OAuth20ConfigProvider;
import com.ibm.oauth.core.internal.oauth20.responsetype.OAuth20ResponseTypeHandler;
import com.ibm.oauth.core.internal.oauth20.responsetype.OAuth20ResponseTypeHandlerFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.openidconnect.server.internal.Utils;
import com.ibm.ws.security.openidconnect.server.plugins.OIDCResponseTypeHandlerCodeImpl;
import com.ibm.ws.security.openidconnect.server.plugins.OIDCResponseTypeHandlerImplicitImpl;
import java.util.Map;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OIDCResponseTypeHandlerFactoryImpl
implements OAuth20ResponseTypeHandlerFactory {
    private static final TraceComponent tc = Tr.register(OIDCResponseTypeHandlerFactoryImpl.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    OAuthComponentConfiguration _oldconfig = null;
    static final long serialVersionUID = 4105273775263104912L;

    protected void activate(ComponentContext cc, Map<String, Object> properties) {
    }

    protected void deactivate(ComponentContext cc, Map<String, Object> properties) {
    }

    protected void modified(ComponentContext cc, Map<String, Object> properties) {
    }

    public void init(OAuthComponentConfiguration oldconfig) {
        this._oldconfig = oldconfig;
    }

    public synchronized OAuth20ResponseTypeHandler getHandler(String responseType, OAuth20ConfigProvider config) throws OAuthException {
        Object result = null;
        boolean foundCode = false;
        boolean foundToken = false;
        boolean allowed = false;
        if (responseType != null) {
            String[] responseTypes;
            for (String rType : responseTypes = responseType.split(" ")) {
                if ("code".equals(rType)) {
                    foundCode = true;
                    if (responseTypes.length != 1) continue;
                    allowed = config.isGrantTypeAllowed("authorization_code");
                    if (!allowed) {
                        String allowedGrantTypesAsString = "";
                        if (config instanceof OAuth20Provider) {
                            allowedGrantTypesAsString = Utils.toString(((OAuth20Provider)config).getGrantTypesAllowed());
                        }
                        Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_GRANT_TYPE_NOT_ALLOWED_ERR", (Object[])new Object[]{"authorization_code", allowedGrantTypesAsString});
                        throw new OAuthConfigurationException("oauth20.grant.types.allowed", responseType, null);
                    }
                    result = new OIDCResponseTypeHandlerCodeImpl();
                    continue;
                }
                if ("token".equals(rType) || "id_token".equals(rType)) {
                    foundToken = true;
                    allowed = config.isGrantTypeAllowed("implicit");
                    if (!allowed) {
                        String allowedGrantTypesAsString = "";
                        if (config instanceof OAuth20Provider) {
                            allowedGrantTypesAsString = Utils.toString(((OAuth20Provider)config).getGrantTypesAllowed());
                        }
                        Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_GRANT_TYPE_NOT_ALLOWED_ERR", (Object[])new Object[]{"authorization_code", allowedGrantTypesAsString});
                        throw new OAuthConfigurationException("oauth20.grant.types.allowed", responseType, null);
                    }
                    result = new OIDCResponseTypeHandlerImplicitImpl();
                    continue;
                }
                Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_INVALID_RESPONSE_TYPE_ERR", (Object[])new Object[]{rType, "{'code', 'token', 'id_token token'}"});
                throw new OAuth20InvalidResponseTypeException("security.oauth20.error.invalid.responsetype", responseType);
            }
        }
        if (!(foundToken ^ foundCode)) {
            if (foundToken) {
                Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_MULTIPLE_RESPONSE_TYPE_ERR", (Object[])new Object[]{"code", "token id_token"});
                throw new OAuth20InvalidResponseTypeException("security.oauth20.error.multiple.responsetype", responseType, "code", "token id_token");
            }
            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_INVALID_RESPONSE_TYPE_ERR", (Object[])new Object[]{responseType, "{'code', 'token', 'id_token token'}"});
            throw new OAuth20InvalidResponseTypeException("security.oauth20.error.invalid.responsetype", responseType);
        }
        return result;
    }
}

