/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jsl;

import com.ibm.jbatch.jsl.model.Batchlet;
import com.ibm.jbatch.jsl.model.CheckpointAlgorithm;
import com.ibm.jbatch.jsl.model.Chunk;
import com.ibm.jbatch.jsl.model.Collector;
import com.ibm.jbatch.jsl.model.End;
import com.ibm.jbatch.jsl.model.ExceptionClassFilter;
import com.ibm.jbatch.jsl.model.Fail;
import com.ibm.jbatch.jsl.model.ItemProcessor;
import com.ibm.jbatch.jsl.model.ItemReader;
import com.ibm.jbatch.jsl.model.ItemWriter;
import com.ibm.jbatch.jsl.model.JSLProperties;
import com.ibm.jbatch.jsl.model.Listener;
import com.ibm.jbatch.jsl.model.Listeners;
import com.ibm.jbatch.jsl.model.Next;
import com.ibm.jbatch.jsl.model.Partition;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Stop;
import com.ibm.jbatch.jsl.model.helper.TransitionElement;
import com.ibm.jbatch.jsl.model.v1.ObjectFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CloneUtility {
    private static final Map<String, com.ibm.jbatch.jsl.model.ObjectFactory> objectFactoryMap;
    static final long serialVersionUID = 1046179196021403917L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Batchlet cloneBatchlet(Batchlet batchlet) {
        com.ibm.jbatch.jsl.model.ObjectFactory jslFactory = objectFactoryMap.get(batchlet.getClass().getPackage().getName());
        Batchlet newBatchlet = jslFactory.createBatchlet();
        newBatchlet.setRef(batchlet.getRef());
        newBatchlet.setProperties(CloneUtility.cloneJSLProperties(batchlet.getProperties()));
        return newBatchlet;
    }

    public static JSLProperties cloneJSLProperties(JSLProperties jslProps) {
        if (jslProps == null) {
            return null;
        }
        com.ibm.jbatch.jsl.model.ObjectFactory jslFactory = objectFactoryMap.get(jslProps.getClass().getPackage().getName());
        JSLProperties newJSLProps = jslFactory.createJSLProperties();
        newJSLProps.setPartition(jslProps.getPartition());
        List<? extends Property> newPropertyList = newJSLProps.getPropertyList();
        for (Property property : jslProps.getPropertyList()) {
            Object newProperty = jslFactory.createProperty();
            ((Property)newProperty).setName(property.getName());
            ((Property)newProperty).setValue(property.getValue());
            newPropertyList.add((Property)newProperty);
        }
        return newJSLProps;
    }

    public static void cloneControlElements(List<TransitionElement> controlElements, List<TransitionElement> newControlElements) {
        newControlElements.clear();
        for (TransitionElement controlElement : controlElements) {
            com.ibm.jbatch.jsl.model.ObjectFactory jslFactory = objectFactoryMap.get(controlElement.getClass().getPackage().getName());
            if (controlElement instanceof End) {
                End endElement = (End)controlElement;
                End newEnd = jslFactory.createEnd();
                newEnd.setExitStatus(endElement.getExitStatus());
                newEnd.setOn(endElement.getOn());
                newControlElements.add(newEnd);
                continue;
            }
            if (controlElement instanceof Fail) {
                Fail failElement = (Fail)controlElement;
                Fail newFail = jslFactory.createFail();
                newFail.setExitStatus(failElement.getExitStatus());
                newFail.setOn(failElement.getOn());
                newControlElements.add(newFail);
                continue;
            }
            if (controlElement instanceof Next) {
                Next nextElement = (Next)controlElement;
                Next newNext = jslFactory.createNext();
                newNext.setOn(nextElement.getOn());
                newNext.setTo(nextElement.getTo());
                newControlElements.add(newNext);
                continue;
            }
            if (!(controlElement instanceof Stop)) continue;
            Stop stopElement = (Stop)controlElement;
            Stop newStop = jslFactory.createStop();
            newStop.setExitStatus(stopElement.getExitStatus());
            newStop.setOn(stopElement.getOn());
            newStop.setRestart(stopElement.getRestart());
            newControlElements.add(newStop);
        }
    }

    public static Listeners cloneListeners(Listeners listeners) {
        if (listeners == null) {
            return null;
        }
        com.ibm.jbatch.jsl.model.ObjectFactory jslFactory = objectFactoryMap.get(listeners.getClass().getPackage().getName());
        Listeners newListeners = jslFactory.createListeners();
        List<? extends Listener> newListenerList = newListeners.getListenerList();
        for (Listener listener : listeners.getListenerList()) {
            Listener newListener = jslFactory.createListener();
            newListenerList.add(newListener);
            newListener.setRef(listener.getRef());
            newListener.setProperties(CloneUtility.cloneJSLProperties(listener.getProperties()));
        }
        return newListeners;
    }

    public static Chunk cloneChunk(Chunk chunk) {
        com.ibm.jbatch.jsl.model.ObjectFactory jslFactory = objectFactoryMap.get(chunk.getClass().getPackage().getName());
        Chunk newChunk = jslFactory.createChunk();
        newChunk.setItemCount(chunk.getItemCount());
        newChunk.setRetryLimit(chunk.getRetryLimit());
        newChunk.setSkipLimit(chunk.getSkipLimit());
        newChunk.setTimeLimit(chunk.getTimeLimit());
        newChunk.setCheckpointPolicy(chunk.getCheckpointPolicy());
        newChunk.setCheckpointAlgorithm(CloneUtility.cloneCheckpointAlorithm(chunk.getCheckpointAlgorithm()));
        newChunk.setProcessor(CloneUtility.cloneItemProcessor(chunk.getProcessor()));
        newChunk.setReader(CloneUtility.cloneItemReader(chunk.getReader()));
        newChunk.setWriter(CloneUtility.cloneItemWriter(chunk.getWriter()));
        newChunk.setNoRollbackExceptionClasses(CloneUtility.cloneExceptionClassFilter(chunk.getNoRollbackExceptionClasses()));
        newChunk.setRetryableExceptionClasses(CloneUtility.cloneExceptionClassFilter(chunk.getRetryableExceptionClasses()));
        newChunk.setSkippableExceptionClasses(CloneUtility.cloneExceptionClassFilter(chunk.getSkippableExceptionClasses()));
        return newChunk;
    }

    private static CheckpointAlgorithm cloneCheckpointAlorithm(CheckpointAlgorithm checkpointAlgorithm) {
        if (checkpointAlgorithm == null) {
            return null;
        }
        com.ibm.jbatch.jsl.model.ObjectFactory jslFactory = objectFactoryMap.get(checkpointAlgorithm.getClass().getPackage().getName());
        CheckpointAlgorithm newCheckpointAlgorithm = jslFactory.createCheckpointAlgorithm();
        newCheckpointAlgorithm.setRef(checkpointAlgorithm.getRef());
        newCheckpointAlgorithm.setProperties(CloneUtility.cloneJSLProperties(checkpointAlgorithm.getProperties()));
        return newCheckpointAlgorithm;
    }

    private static ItemProcessor cloneItemProcessor(ItemProcessor itemProcessor) {
        if (itemProcessor == null) {
            return null;
        }
        com.ibm.jbatch.jsl.model.ObjectFactory jslFactory = objectFactoryMap.get(itemProcessor.getClass().getPackage().getName());
        ItemProcessor newItemProcessor = jslFactory.createItemProcessor();
        newItemProcessor.setRef(itemProcessor.getRef());
        newItemProcessor.setProperties(CloneUtility.cloneJSLProperties(itemProcessor.getProperties()));
        return newItemProcessor;
    }

    private static ItemReader cloneItemReader(ItemReader itemReader) {
        if (itemReader == null) {
            return null;
        }
        com.ibm.jbatch.jsl.model.ObjectFactory jslFactory = objectFactoryMap.get(itemReader.getClass().getPackage().getName());
        ItemReader newItemReader = jslFactory.createItemReader();
        newItemReader.setRef(itemReader.getRef());
        newItemReader.setProperties(CloneUtility.cloneJSLProperties(itemReader.getProperties()));
        return newItemReader;
    }

    private static ItemWriter cloneItemWriter(ItemWriter itemWriter) {
        com.ibm.jbatch.jsl.model.ObjectFactory jslFactory = objectFactoryMap.get(itemWriter.getClass().getPackage().getName());
        ItemWriter newItemWriter = jslFactory.createItemWriter();
        newItemWriter.setRef(itemWriter.getRef());
        newItemWriter.setProperties(CloneUtility.cloneJSLProperties(itemWriter.getProperties()));
        return newItemWriter;
    }

    private static ExceptionClassFilter cloneExceptionClassFilter(ExceptionClassFilter exceptionClassFilter) {
        if (exceptionClassFilter == null) {
            return null;
        }
        com.ibm.jbatch.jsl.model.ObjectFactory jslFactory = objectFactoryMap.get(exceptionClassFilter.getClass().getPackage().getName());
        ExceptionClassFilter newExceptionClassFilter = jslFactory.createExceptionClassFilter();
        List<? extends ExceptionClassFilter.Include> newIncludeList = newExceptionClassFilter.getIncludeList();
        List<? extends ExceptionClassFilter.Exclude> newExcludeList = newExceptionClassFilter.getExcludeList();
        for (ExceptionClassFilter.Include include : exceptionClassFilter.getIncludeList()) {
            newIncludeList.add(CloneUtility.cloneExceptionClassFilterInclude(include));
        }
        for (ExceptionClassFilter.Exclude exclude : exceptionClassFilter.getExcludeList()) {
            newExcludeList.add(CloneUtility.cloneExceptionClassFilterExclude(exclude));
        }
        return newExceptionClassFilter;
    }

    private static ExceptionClassFilter.Include cloneExceptionClassFilterInclude(ExceptionClassFilter.Include include) {
        if (include == null) {
            return null;
        }
        com.ibm.jbatch.jsl.model.ObjectFactory jslFactory = objectFactoryMap.get(include.getClass().getPackage().getName());
        Object newInclude = jslFactory.createExceptionClassFilterInclude();
        ((ExceptionClassFilter.Include)newInclude).setClazz(include.getClazz());
        return newInclude;
    }

    private static ExceptionClassFilter.Exclude cloneExceptionClassFilterExclude(ExceptionClassFilter.Exclude exclude) {
        if (exclude == null) {
            return null;
        }
        com.ibm.jbatch.jsl.model.ObjectFactory jslFactory = objectFactoryMap.get(exclude.getClass().getPackage().getName());
        Object newExclude = jslFactory.createExceptionClassFilterExclude();
        ((ExceptionClassFilter.Exclude)newExclude).setClazz(exclude.getClazz());
        return newExclude;
    }

    public static Properties jslPropertiesToJavaProperties(JSLProperties xmlProperties) {
        Properties props = new Properties();
        for (Property property : xmlProperties.getPropertyList()) {
            props.setProperty(property.getName(), property.getValue());
        }
        return props;
    }

    public static JSLProperties javaPropsTojslProperties(com.ibm.jbatch.jsl.model.ObjectFactory jslFactory, Properties javaProps) {
        JSLProperties newJSLProps = jslFactory.createJSLProperties();
        Enumeration<?> keySet = javaProps.propertyNames();
        List<? extends Property> newPropertyList = newJSLProps.getPropertyList();
        while (keySet.hasMoreElements()) {
            String key = (String)keySet.nextElement();
            String value = javaProps.getProperty(key);
            Object newProperty = jslFactory.createProperty();
            ((Property)newProperty).setName(key);
            ((Property)newProperty).setValue(value);
            newPropertyList.add((Property)newProperty);
        }
        return newJSLProps;
    }

    public static Partition cloneRelevantPartitionModel(Partition partition) {
        com.ibm.jbatch.jsl.model.ObjectFactory jslFactory = objectFactoryMap.get(partition.getClass().getPackage().getName());
        Partition newPartition = jslFactory.createPartition();
        if (partition.getCollector() != null) {
            newPartition.setCollector(CloneUtility.cloneCollector(partition.getCollector()));
        }
        return newPartition;
    }

    private static Collector cloneCollector(Collector collector) {
        if (collector == null) {
            return null;
        }
        com.ibm.jbatch.jsl.model.ObjectFactory jslFactory = objectFactoryMap.get(collector.getClass().getPackage().getName());
        Collector newCollector = jslFactory.createCollector();
        newCollector.setRef(collector.getRef());
        newCollector.setProperties(CloneUtility.cloneJSLProperties(collector.getProperties()));
        return newCollector;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.jsl.CloneUtility", CloneUtility.class, null, null);
        HashMap<String, com.ibm.jbatch.jsl.model.ObjectFactory> map = new HashMap<String, com.ibm.jbatch.jsl.model.ObjectFactory>();
        map.put("com.ibm.jbatch.jsl.model.v1", new ObjectFactory());
        map.put("com.ibm.jbatch.jsl.model.v2", new com.ibm.jbatch.jsl.model.v2.ObjectFactory());
        objectFactoryMap = Collections.unmodifiableMap(map);
    }
}

