/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.util;

import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.api.oauth20.token.OAuth20TokenCache;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.plugins.OAuth20TokenImpl;
import com.ibm.ws.security.oauth20.util.HashUtils;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.security.oauth20.web.EndpointUtils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CacheUtil {
    private OAuth20TokenCache cache;
    static final long serialVersionUID = 2523276909889456488L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public CacheUtil(OAuth20TokenCache tokenCache) {
        this.cache = tokenCache;
    }

    public CacheUtil() {
    }

    public String computeHash(String lookupKeyParam, String encoding) {
        String lookupKey = lookupKeyParam;
        boolean isPlainEncoding = "plain".equals(encoding);
        lookupKey = isPlainEncoding ? EndpointUtils.computeTokenHash(lookupKey) : EndpointUtils.computeTokenHash(lookupKey, encoding);
        return lookupKey;
    }

    public boolean shouldHash(OAuth20Token entry, String encoding) {
        boolean isAppPasswordOrAppTokenGT = "app_password".equals(entry.getGrantType()) || "app_token".equals(entry.getGrantType());
        boolean isAuthorizationGrantTypeAndCodeSubType = "authorization_grant".equals(entry.getType()) && "authorization_code".equals(entry.getSubType());
        boolean isPlainEncoding = "plain".equals(encoding);
        return !isAuthorizationGrantTypeAndCodeSubType && (!isPlainEncoding || isAppPasswordOrAppTokenGT);
    }

    public OAuth20Token getRefreshToken(OAuth20Token token) {
        String refreshLookupKey = null;
        OAuth20Token refresh = null;
        refreshLookupKey = this.getRefreshTokenId(token);
        if (refreshLookupKey != null) {
            refresh = this.cache.get(refreshLookupKey);
        }
        return refresh;
    }

    public String getRefreshTokenId(OAuth20Token token) {
        String refreshLookupKey = null;
        if (token != null) {
            if ("access_token".equals(token.getType())) {
                refreshLookupKey = this.getLookupKey(token);
            } else {
                OAuth20Token access = this.getAccessToken(token);
                if (access != null) {
                    refreshLookupKey = this.getLookupKey(access);
                }
            }
        }
        return refreshLookupKey;
    }

    public String getAccessTokenId(OAuth20Token idtoken) {
        String accessTokenId = null;
        if (idtoken != null && "id_token".equals(idtoken.getType())) {
            accessTokenId = ((OAuth20TokenImpl)idtoken).getAccessTokenKey();
        }
        return accessTokenId;
    }

    private OAuth20Token getAccessToken(OAuth20Token idtoken) {
        OAuth20Token access = null;
        if ("id_token".equals(idtoken.getType())) {
            String accessTokenKey = ((OAuth20TokenImpl)idtoken).getAccessTokenKey();
            if (accessTokenKey != null && OidcOAuth20Util.isJwtToken(accessTokenKey)) {
                accessTokenKey = HashUtils.digest(accessTokenKey);
            }
            access = this.cache.get(accessTokenKey);
        }
        return access;
    }

    private String getLookupKey(OAuth20Token token) {
        return ((OAuth20TokenImpl)token).getRefreshTokenKey();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.util.CacheUtil", CacheUtil.class, null, null);
    }
}

