/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.security.PrivilegedAction;

class ManagedObjectInputStream
extends ObjectInputStream {
    private static final Class cclass = ManagedObjectInputStream.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerObjects");
    protected ObjectManagerState objectManagerState;

    ManagedObjectInputStream(InputStream inputStream, ObjectManagerState objectManagerState) throws IOException, StreamCorruptedException {
        super(inputStream);
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{inputStream, objectManagerState});
        }
        this.objectManagerState = objectManagerState;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ManagedObjectInputStream.this.enableResolveObject(true);
                return null;
            }
        });
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass objectStreamClass;
        String methodName = "readClassDescriptor";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "readClassDescriptor");
        }
        if ((objectStreamClass = super.readClassDescriptor()).getSerialVersionUID() == 2723354058036620229L && objectStreamClass.getName().equals(ManagedObject.class.getName())) {
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.entry((Object)this, cclass, "readClassDescriptor", new Object[]{"Migrating:93", objectStreamClass});
            }
            objectStreamClass = ObjectStreamClass.lookup(ManagedObject.class);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "readClassDescriptor", new Object[]{objectStreamClass});
        }
        return objectStreamClass;
    }

    @Override
    protected Object resolveObject(Object objectToResolve) {
        String methodName = "resolveObject";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "resolveObject", new Object[]{objectToResolve});
        }
        Object resolvedObject = objectToResolve instanceof Token ? ((Token)objectToResolve).current() : objectToResolve;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "resolveObject", new Object[]{resolvedObject});
        }
        return resolvedObject;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String methodName = "resolveClass";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "resolveClass", new Object[]{objectStreamClass});
        }
        Class<?> theClass = null;
        try {
            theClass = Class.forName(objectStreamClass.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            theClass = Class.forName(objectStreamClass.getName(), true, classLoader);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "resolveClass", new Object[]{theClass});
        }
        return theClass;
    }
}

