/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.objectManager;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.objectManager.LogFileFullException;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectStore;
import com.ibm.ws.objectManager.ObjectStoreFullException;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.PersistenceFullException;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.impl.CachedPersistableImpl;
import com.ibm.ws.sib.msgstore.persistence.objectManager.PersistableImpl;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.utils.ras.SibTr;

public class BatchingContextImpl
implements BatchingContext {
    private static TraceComponent tc = SibTr.register(BatchingContextImpl.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private ObjectManager _objectManager;
    private ObjectStore _objectStore;
    private Transaction _tran;
    private PersistenceException _deferredException;
    private int _capacity = 10;
    private static final int STATE_ACTIVE = 0;
    private static final int STATE_PREPARING = 1;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_COMMITTING = 3;
    private static final int STATE_COMMITTED = 4;
    private static final int STATE_ROLLINGBACK = 5;
    private static final int STATE_ROLLEDBACK = 6;
    private static final String[] _stateToString = new String[]{"STATE_ACTIVE", "STATE_PREPARING", "STATE_PREPARED", "STATE_COMMITTING", "STATE_COMMITTED", "STATE_ROLLINGBACK", "STATE_ROLLEDBACK"};
    private int _state = 0;
    private byte[] _xid;

    public BatchingContextImpl(ObjectManager objectManager, ObjectStore objectStore) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{"ObjectManager=" + objectManager, "ObjectStore=" + objectStore});
        }
        this._objectManager = objectManager;
        this._objectStore = objectStore;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public BatchingContextImpl(ObjectManager objectManager, ObjectStore objectStore, PersistentTransaction transaction) throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{"ObjectManager=" + objectManager, "ObjectStore=" + objectStore, "Transaction=" + transaction});
        }
        this._objectManager = objectManager;
        this._objectStore = objectStore;
        if (transaction != null) {
            this._xid = transaction.getPersistentTranId().toByteArray();
            try {
                this._tran = this._objectManager.getTransaction();
                this._tran.setXID(this._xid);
            }
            catch (ObjectManagerException ome) {
                FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.<init>", (String)"1:132:1.18", (Object)this);
                PersistenceException pe = new PersistenceException("Exception caught starting object manager transaction: " + ome.getMessage(), (Throwable)ome);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Exception caught starting object manager transaction!");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"<init>");
                }
                throw pe;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public BatchingContextImpl(ObjectManager objectManager, ObjectStore objectStore, Transaction transaction) throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{"ObjectManager=" + objectManager, "ObjectStore=" + objectStore, "Transaction=" + transaction});
        }
        this._objectManager = objectManager;
        this._objectStore = objectStore;
        if (transaction == null) {
            PersistenceException pe = new PersistenceException("Recovered transaction is null!");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Recovered transaction is null!");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"<init>");
            }
            throw pe;
        }
        this._tran = transaction;
        this._state = 2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public void insert(Persistable persistable) {
        block18: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"insert", (Object)("Persistable=" + persistable));
            }
            if (this._deferredException == null) {
                try {
                    this._startTransaction();
                    PersistableImpl thePersistable = null;
                    CachedPersistableImpl cachedPersistable = null;
                    if (persistable instanceof PersistableImpl) {
                        thePersistable = (PersistableImpl)persistable;
                        thePersistable.addToStore(this._tran, this._objectStore);
                    } else if (persistable instanceof CachedPersistableImpl) {
                        cachedPersistable = (CachedPersistableImpl)persistable;
                        thePersistable = (PersistableImpl)cachedPersistable.getPersistable();
                        thePersistable.addToStore(this._tran, this._objectStore, persistable);
                    }
                }
                catch (LogFileFullException lffe) {
                    FFDCFilter.processException((Throwable)lffe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.insert", (String)"1:210:1.18", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"FILE_STORE_LOG_FULL_SIMS1573E");
                    this._deferredException = new PersistenceFullException("FILE_STORE_LOG_FULL_SIMS1573E", (Throwable)lffe);
                }
                catch (ObjectStoreFullException osfe) {
                    FFDCFilter.processException((Throwable)osfe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.insert", (String)"1:216:1.18", (Object)this);
                    if (this._objectStore.getStoreStrategy() == 0) {
                        SibTr.error((TraceComponent)tc, (String)"FILE_STORE_PERMANENT_STORE_FULL_SIMS1574E");
                        this._deferredException = new PersistenceFullException("FILE_STORE_PERMANENT_STORE_FULL_SIMS1574E", (Throwable)osfe);
                        break block18;
                    }
                    SibTr.error((TraceComponent)tc, (String)"FILE_STORE_TEMPORARY_STORE_FULL_SIMS1575E");
                    this._deferredException = new PersistenceFullException("FILE_STORE_TEMPORARY_STORE_FULL_SIMS1575E", (Throwable)osfe);
                }
                catch (ObjectManagerException ome) {
                    FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.insert", (String)"1:230:1.18", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Exception caught inserting item into object store!", (Object)ome);
                    }
                    this._deferredException = new PersistenceException("Exception caught inserting item into object store: " + ome.getMessage(), (Throwable)ome);
                }
                catch (PersistenceException pe) {
                    FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.insert", (String)"1:236:1.18", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"PersistenceException caught inserting item into object store!", (Object)((Object)pe));
                    }
                    this._deferredException = pe;
                }
                catch (SevereMessageStoreException smse) {
                    FFDCFilter.processException((Throwable)smse, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.insert", (String)"1:242:1.18", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Severe exception caught inserting item into object store!", (Object)((Object)smse));
                    }
                    this._deferredException = new PersistenceException("Exception caught inserting item into object store: " + smse.getMessage(), (Throwable)smse);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"No work attempted as an exception has already been thrown during this batch!");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"insert");
        }
    }

    @Override
    public void updateDataAndSize(Persistable persistable) {
        block18: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"updateDataAndSize", (Object)("Persistable=" + persistable));
            }
            if (this._deferredException == null) {
                try {
                    this._startTransaction();
                    PersistableImpl thePersistable = null;
                    CachedPersistableImpl cachedPersistable = null;
                    if (persistable instanceof PersistableImpl) {
                        thePersistable = (PersistableImpl)persistable;
                        thePersistable.updateDataOnly(this._tran, this._objectStore);
                    } else if (persistable instanceof CachedPersistableImpl) {
                        cachedPersistable = (CachedPersistableImpl)persistable;
                        thePersistable = (PersistableImpl)cachedPersistable.getPersistable();
                        thePersistable.updateDataOnly(this._tran, this._objectStore, persistable);
                    }
                }
                catch (LogFileFullException lffe) {
                    FFDCFilter.processException((Throwable)lffe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.updateDataAndSize", (String)"1:289:1.18", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"FILE_STORE_LOG_FULL_SIMS1573E");
                    this._deferredException = new PersistenceFullException("FILE_STORE_LOG_FULL_SIMS1573E", (Throwable)lffe);
                }
                catch (ObjectStoreFullException osfe) {
                    FFDCFilter.processException((Throwable)osfe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.updateDataAndSize", (String)"1:295:1.18", (Object)this);
                    if (this._objectStore.getStoreStrategy() == 0) {
                        SibTr.error((TraceComponent)tc, (String)"FILE_STORE_PERMANENT_STORE_FULL_SIMS1574E");
                        this._deferredException = new PersistenceFullException("FILE_STORE_PERMANENT_STORE_FULL_SIMS1574E", (Throwable)osfe);
                        break block18;
                    }
                    SibTr.error((TraceComponent)tc, (String)"FILE_STORE_TEMPORARY_STORE_FULL_SIMS1575E");
                    this._deferredException = new PersistenceFullException("FILE_STORE_TEMPORARY_STORE_FULL_SIMS1575E", (Throwable)osfe);
                }
                catch (ObjectManagerException ome) {
                    FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.updateDataAndSize", (String)"1:309:1.18", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Exception caught updating data in object store!", (Object)ome);
                    }
                    this._deferredException = new PersistenceException("Exception caught updating data in object store: " + ome.getMessage(), (Throwable)ome);
                }
                catch (PersistenceException pe) {
                    FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.updateDataAndSize", (String)"1:315:1.18", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Persistence exception caught updating data in object store!", (Object)((Object)pe));
                    }
                    this._deferredException = pe;
                }
                catch (SevereMessageStoreException smse) {
                    FFDCFilter.processException((Throwable)smse, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.updateDataAndSize", (String)"1:321:1.18", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Severe exception caught updating data in object store!", (Object)((Object)smse));
                    }
                    this._deferredException = new PersistenceException("Exception caught inserting item into object store: " + smse.getMessage(), (Throwable)smse);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"No work attempted as an exception has already been thrown during this batch!");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateDataAndSize");
        }
    }

    @Override
    public void updateLockIDOnly(Persistable persistable) {
        block16: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"updateLockIDOnly", (Object)("Persistable=" + persistable));
            }
            if (this._deferredException == null) {
                try {
                    this._startTransaction();
                    PersistableImpl thePersistable = null;
                    CachedPersistableImpl cachedPersistable = null;
                    if (persistable instanceof PersistableImpl) {
                        thePersistable = (PersistableImpl)persistable;
                        thePersistable.updateMetaDataOnly(this._tran);
                    } else if (persistable instanceof CachedPersistableImpl) {
                        cachedPersistable = (CachedPersistableImpl)persistable;
                        thePersistable = (PersistableImpl)cachedPersistable.getPersistable();
                        thePersistable.updateMetaDataOnly(this._tran, persistable);
                    }
                }
                catch (LogFileFullException lffe) {
                    FFDCFilter.processException((Throwable)lffe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.updateLockIDOnly", (String)"1:368:1.18", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"FILE_STORE_LOG_FULL_SIMS1573E");
                    this._deferredException = new PersistenceFullException("FILE_STORE_LOG_FULL_SIMS1573E", (Throwable)lffe);
                }
                catch (ObjectStoreFullException osfe) {
                    FFDCFilter.processException((Throwable)osfe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.updateLockIDOnly", (String)"1:374:1.18", (Object)this);
                    if (this._objectStore.getStoreStrategy() == 0) {
                        SibTr.error((TraceComponent)tc, (String)"FILE_STORE_PERMANENT_STORE_FULL_SIMS1574E");
                        this._deferredException = new PersistenceFullException("FILE_STORE_PERMANENT_STORE_FULL_SIMS1574E", (Throwable)osfe);
                        break block16;
                    }
                    SibTr.error((TraceComponent)tc, (String)"FILE_STORE_TEMPORARY_STORE_FULL_SIMS1575E");
                    this._deferredException = new PersistenceFullException("FILE_STORE_TEMPORARY_STORE_FULL_SIMS1575E", (Throwable)osfe);
                }
                catch (ObjectManagerException ome) {
                    FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.updateLockIDOnly", (String)"1:388:1.18", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Exception caught updating metadata in object store!", (Object)ome);
                    }
                    this._deferredException = new PersistenceException("Exception caught updating metadata in object store: " + ome.getMessage(), (Throwable)ome);
                }
                catch (PersistenceException pe) {
                    FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.updateLockIDOnly", (String)"1:394:1.18", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Persistence exception caught updating metadata in object store!", (Object)((Object)pe));
                    }
                    this._deferredException = pe;
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"No work attempted as an exception has already been thrown during this batch!");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLockIDOnly");
        }
    }

    @Override
    public void updateRedeliveredCountOnly(Persistable persistable) {
        block16: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"updateRedeliveredCountOnly", (Object)("Persistable=" + persistable));
            }
            if (this._deferredException == null) {
                try {
                    this._startTransaction();
                    PersistableImpl thePersistable = null;
                    CachedPersistableImpl cachedPersistable = null;
                    if (persistable instanceof PersistableImpl) {
                        thePersistable = (PersistableImpl)persistable;
                        thePersistable.updateMetaDataOnly(this._tran);
                    } else if (persistable instanceof CachedPersistableImpl) {
                        cachedPersistable = (CachedPersistableImpl)persistable;
                        thePersistable = (PersistableImpl)cachedPersistable.getPersistable();
                        thePersistable.updateMetaDataOnly(this._tran, persistable);
                    }
                }
                catch (LogFileFullException lffe) {
                    FFDCFilter.processException((Throwable)lffe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.updateRedeliveredCountOnly", (String)"1:368:1.17", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"FILE_STORE_LOG_FULL_SIMS1573E");
                    this._deferredException = new PersistenceFullException("FILE_STORE_LOG_FULL_SIMS1573E", (Throwable)lffe);
                }
                catch (ObjectStoreFullException osfe) {
                    FFDCFilter.processException((Throwable)osfe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.updateRedeliveredCountOnly", (String)"1:374:1.17", (Object)this);
                    if (this._objectStore.getStoreStrategy() == 0) {
                        SibTr.error((TraceComponent)tc, (String)"FILE_STORE_PERMANENT_STORE_FULL_SIMS1574E");
                        this._deferredException = new PersistenceFullException("FILE_STORE_PERMANENT_STORE_FULL_SIMS1574E", (Throwable)osfe);
                        break block16;
                    }
                    SibTr.error((TraceComponent)tc, (String)"FILE_STORE_TEMPORARY_STORE_FULL_SIMS1575E");
                    this._deferredException = new PersistenceFullException("FILE_STORE_TEMPORARY_STORE_FULL_SIMS1575E", (Throwable)osfe);
                }
                catch (ObjectManagerException ome) {
                    FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.updateRedeliveredCountOnly", (String)"1:388:1.17", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Exception caught updating metadata in object store!", (Object)ome);
                    }
                    this._deferredException = new PersistenceException("Exception caught updating metadata in object store: " + ome.getMessage(), (Throwable)ome);
                }
                catch (PersistenceException pe) {
                    FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.updateRedeliveredCountOnly", (String)"1:394:1.17", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Persistence exception caught updating metadata in object store!", (Object)((Object)pe));
                    }
                    this._deferredException = pe;
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"No work attempted as an exception has already been thrown during this batch!");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateRedeliveredCountOnly");
        }
    }

    @Override
    public void updateLogicalDeleteAndXID(Persistable persistable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLogicalDeleteAndXID", (Object)("Persistable=" + persistable));
        }
        if (this._deferredException == null) {
            PersistableImpl thePersistable = (PersistableImpl)persistable;
            if (thePersistable.isLogicallyDeleted()) {
                this.internalDelete(persistable);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"No work attempted as an exception has already been thrown during this batch!");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLogicalDeleteAndXID");
        }
    }

    @Override
    public void delete(Persistable persistable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"delete", (Object)("Persistable=" + persistable));
        }
        if (this._deferredException == null) {
            if (this._state == 0) {
                this.internalDelete(persistable);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"No work attempted as an exception has already been thrown during this batch!");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"delete");
        }
    }

    private void internalDelete(Persistable persistable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalDelete", (Object)("Persistable=" + persistable));
        }
        PersistableImpl thePersistable = (PersistableImpl)persistable;
        try {
            this._startTransaction();
            thePersistable.removeFromStore(this._tran);
        }
        catch (LogFileFullException lffe) {
            FFDCFilter.processException((Throwable)lffe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.internalDelete", (String)"1:557:1.18", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"FILE_STORE_LOG_FULL_SIMS1573E");
            this._deferredException = new PersistenceFullException("FILE_STORE_LOG_FULL_SIMS1573E", (Throwable)lffe);
        }
        catch (ObjectStoreFullException osfe) {
            FFDCFilter.processException((Throwable)osfe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.internalDelete", (String)"1:563:1.18", (Object)this);
            if (this._objectStore.getStoreStrategy() == 0) {
                SibTr.error((TraceComponent)tc, (String)"FILE_STORE_PERMANENT_STORE_FULL_SIMS1574E");
                this._deferredException = new PersistenceFullException("FILE_STORE_PERMANENT_STORE_FULL_SIMS1574E", (Throwable)osfe);
            } else {
                SibTr.error((TraceComponent)tc, (String)"FILE_STORE_TEMPORARY_STORE_FULL_SIMS1575E");
                this._deferredException = new PersistenceFullException("FILE_STORE_TEMPORARY_STORE_FULL_SIMS1575E", (Throwable)osfe);
            }
        }
        catch (ObjectManagerException ome) {
            FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.internalDelete", (String)"1:577:1.18", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Exception caught deleting from object store!", (Object)ome);
            }
            this._deferredException = new PersistenceException("Exception caught deleting from object store: " + ome.getMessage(), (Throwable)ome);
        }
        catch (PersistenceException pe) {
            FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.internalDelete", (String)"1:583:1.18", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Persistence exception caught deleting from object store!", (Object)((Object)pe));
            }
            this._deferredException = pe;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalDelete");
        }
    }

    @Override
    public void addIndoubtXID(PersistentTranId xid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addIndoubtXID", (Object)("XID=" + xid));
        }
        if (this._deferredException == null) {
            if (this._state == 0) {
                this._state = 1;
            } else {
                this._deferredException = new PersistenceException("Cannot PREPARE batch as it not in the correct state! State=" + _stateToString[this._state]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"No work attempted as an exception has already been thrown during this batch!");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addIndoubtXID");
        }
    }

    @Override
    public void updateXIDToCommitted(PersistentTranId xid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateXIDToCommitted", (Object)("XID=" + xid));
        }
        if (this._deferredException == null) {
            if (this._state == 0 || this._state == 2) {
                this._state = 3;
            } else {
                this._deferredException = new PersistenceException("Cannot COMMIT batch as it not in the correct state! State=" + _stateToString[this._state]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"No work attempted as an exception has already been thrown during this batch!");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateXIDToCommitted");
        }
    }

    @Override
    public void updateXIDToRolledback(PersistentTranId xid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateXIDToRolledback", (Object)("XID=" + xid));
        }
        if (this._deferredException == null) {
            if (this._state == 2) {
                this._state = 5;
            } else {
                this._deferredException = new PersistenceException("Cannot ROLLBACK batch as it not in the correct state! State=" + _stateToString[this._state]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"No work attempted as an exception has already been thrown during this batch!");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateXIDToRolledback");
        }
    }

    @Override
    public void executeBatch() throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"executeBatch");
        }
        if (this._deferredException != null) {
            block23: {
                if (this._tran != null) {
                    try {
                        Transaction t = this._tran;
                        this._xid = null;
                        this._tran = null;
                        t.backout(false);
                        this._state = 6;
                    }
                    catch (ObjectManagerException ome) {
                        FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.executeBatch", (String)"1:714:1.18", (Object)this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block23;
                        SibTr.event((TraceComponent)tc, (String)"Unexpected exception caught cleaning up transaction!", (Object)ome);
                    }
                }
            }
            PersistenceException e = this._deferredException;
            this._deferredException = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Deferred exception being thrown during executeBatch!", (Object)((Object)e));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"executeBatch");
            }
            throw e;
        }
        try {
            if (this._tran != null) {
                Transaction t = this._tran;
                switch (this._state) {
                    case 1: {
                        if (t.getXID() == null) {
                            PersistenceException pe = new PersistenceException("No XID associated at prepare time!");
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                SibTr.event((TraceComponent)tc, (String)"No XID associated at prepare time!");
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"executeBatch");
                            }
                            throw pe;
                        }
                        t.prepare();
                        this._state = 2;
                        break;
                    }
                    case 0: 
                    case 3: {
                        this._xid = null;
                        this._tran = null;
                        t.commit(false);
                        this._state = 4;
                        break;
                    }
                    case 5: {
                        this._xid = null;
                        this._tran = null;
                        t.backout(false);
                        this._state = 6;
                        break;
                    }
                    default: {
                        PersistenceException pe = new PersistenceException("BatchingContext not in correct state to executeUpdate! State=" + _stateToString[this._state]);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)("BatchingContext not in correct state to executeUpdate! State=" + _stateToString[this._state]));
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"executeBatch");
                        }
                        throw pe;
                    }
                }
            }
        }
        catch (ObjectManagerException ome) {
            FFDCFilter.processException((Throwable)ome, (String)"com.ibm.ws.sib.msgstore.persistence.objectManager.BatchingContextImpl.executeBatch", (String)"1:775:1.18", (Object)this);
            PersistenceException pe = new PersistenceException("Unexpected exception caught completing transaction: " + ome.getMessage(), (Throwable)ome);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Exception caught completing transaction!", (Object)ome);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"executeBatch");
            }
            throw pe;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"executeBatch");
        }
    }

    @Override
    public void clear() {
        this._state = 0;
        this._deferredException = null;
    }

    private void _startTransaction() throws ObjectManagerException {
        if (this._tran == null) {
            this._tran = this._objectManager.getTransaction();
        }
    }

    @Override
    public void setCapacity(int capacity) {
        this._capacity = capacity;
    }

    @Override
    public int getCapacity() {
        return this._capacity;
    }

    public void updateTickValueOnly(Persistable persistable) {
    }

    @Override
    public void deleteXID(PersistentTranId xid) {
    }

    @Override
    public void setUseEnlistedConnections(boolean useEnlistedConnections) {
    }
}

