/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.impl.JsDestinationAddressImpl;
import com.ibm.ws.sib.mfp.impl.JsMsgObject;
import com.ibm.ws.sib.mfp.impl.MessageImpl;
import com.ibm.ws.sib.mfp.schema.ControlAccess;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;

public class ControlMessageImpl
extends MessageImpl
implements ControlMessage {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = SibTr.register(ControlMessageImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final byte MEDIATED_FLAG = 1;
    private transient boolean gotFlags = false;
    private transient byte flags;

    ControlMessageImpl() {
    }

    ControlMessageImpl(int flag) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.setJmo(new JsMsgObject(ControlAccess.schema));
        this.jmo.setField(3, (byte)1);
        this.jmo.setChoiceField(103, 0);
        this.jmo.setChoiceField(104, 0);
    }

    ControlMessageImpl(JsMsgObject inJmo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this.jmo);
        }
        this.setJmo(inJmo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public final List<DataSlice> encodeFast(Object conn) throws MessageEncodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"encodeFast");
        }
        ArrayList<DataSlice> slices = new ArrayList<DataSlice>(1);
        slices.add(this.jmo.encodeSinglePartMessage(conn));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"encodeFast");
        }
        return slices;
    }

    @Override
    public boolean isControlMessage() {
        return true;
    }

    @Override
    public final ControlMessageType getControlMessageType() {
        Byte mType = (Byte)this.jmo.getField(0);
        return ControlMessageType.getControlMessageType(mType);
    }

    @Override
    public final Integer getPriority() {
        return (Integer)this.jmo.getField(1);
    }

    @Override
    public final Reliability getReliability() {
        Byte rType = (Byte)this.jmo.getField(2);
        return Reliability.getReliability(rType);
    }

    @Override
    public final boolean isMediated() {
        return this.getFlagValue((byte)1);
    }

    @Override
    public final SIBUuid8 getGuaranteedSourceMessagingEngineUUID() {
        byte[] b = (byte[])this.jmo.getField(7);
        if (b != null) {
            return new SIBUuid8(b);
        }
        return null;
    }

    @Override
    public final SIBUuid8 getGuaranteedTargetMessagingEngineUUID() {
        byte[] b = (byte[])this.jmo.getField(8);
        if (b != null) {
            return new SIBUuid8(b);
        }
        return null;
    }

    @Override
    public final SIBUuid12 getGuaranteedTargetDestinationDefinitionUUID() {
        byte[] b = (byte[])this.jmo.getField(9);
        if (b != null) {
            return new SIBUuid12(b);
        }
        return null;
    }

    @Override
    public final SIBUuid12 getGuaranteedStreamUUID() {
        byte[] b = (byte[])this.jmo.getField(10);
        if (b != null) {
            return new SIBUuid12(b);
        }
        return null;
    }

    @Override
    public final SIBUuid12 getGuaranteedGatheringTargetUUID() {
        byte[] b = (byte[])this.jmo.getField(102);
        if (b != null) {
            return new SIBUuid12(b);
        }
        return null;
    }

    @Override
    public final ProtocolType getGuaranteedProtocolType() {
        Byte value = (Byte)this.jmo.getField(11);
        return ProtocolType.getProtocolType(value);
    }

    @Override
    public byte getGuaranteedProtocolVersion() {
        Byte value = (Byte)this.jmo.getField(12);
        return value == null ? (byte)0 : value;
    }

    @Override
    public final String getGuaranteedCrossBusLinkName() {
        return (String)this.jmo.getField(13);
    }

    @Override
    public final SIBUuid8 getGuaranteedCrossBusSourceBusUUID() {
        byte[] b = (byte[])this.jmo.getField(14);
        if (b != null) {
            return new SIBUuid8(b);
        }
        return null;
    }

    @Override
    public JsDestinationAddress getRoutingDestination() {
        String name = (String)this.jmo.getField(4);
        if (name != null) {
            byte[] b = (byte[])this.jmo.getField(5);
            return new JsDestinationAddressImpl(name, false, b == null ? null : new SIBUuid8(b), (String)this.jmo.getField(6));
        }
        return null;
    }

    final void setControlMessageType(ControlMessageType value) {
        this.jmo.setField(0, value.toByte());
    }

    @Override
    public final void setPriority(int value) {
        this.jmo.setIntField(1, value);
    }

    @Override
    public final void setReliability(Reliability value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("setReliability to " + value));
        }
        this.jmo.setField(2, value.toByte());
    }

    @Override
    public final void setMediated(boolean value) {
        this.setFlagValue((byte)1, value);
    }

    @Override
    public final void setGuaranteedSourceMessagingEngineUUID(SIBUuid8 value) {
        if (value != null) {
            this.jmo.setField(7, value.toByteArray());
        } else {
            this.jmo.setField(7, null);
        }
    }

    @Override
    public final void setGuaranteedTargetMessagingEngineUUID(SIBUuid8 value) {
        if (value != null) {
            this.jmo.setField(8, value.toByteArray());
        } else {
            this.jmo.setField(8, null);
        }
    }

    @Override
    public final void setGuaranteedTargetDestinationDefinitionUUID(SIBUuid12 value) {
        if (value != null) {
            this.jmo.setField(9, value.toByteArray());
        } else {
            this.jmo.setField(9, null);
        }
    }

    @Override
    public final void setGuaranteedStreamUUID(SIBUuid12 value) {
        if (value != null) {
            this.jmo.setField(10, value.toByteArray());
        } else {
            this.jmo.setField(10, null);
        }
    }

    @Override
    public final void setGuaranteedGatheringTargetUUID(SIBUuid12 value) {
        if (value != null) {
            this.jmo.setField(102, value.toByteArray());
        } else {
            this.jmo.setField(112, 0);
        }
    }

    @Override
    public final void setGuaranteedProtocolType(ProtocolType value) {
        this.jmo.setField(11, value.toByte());
    }

    @Override
    public void setGuaranteedProtocolVersion(byte value) {
        this.jmo.setField(12, value);
    }

    @Override
    public final void setGuaranteedCrossBusLinkName(String value) {
        this.jmo.setField(13, value);
    }

    @Override
    public final void setGuaranteedCrossBusSourceBusUUID(SIBUuid8 value) {
        if (value != null) {
            this.jmo.setField(14, value.toByteArray());
        } else {
            this.jmo.setField(14, null);
        }
    }

    @Override
    public void setRoutingDestination(JsDestinationAddress value) {
        if (value != null) {
            this.jmo.setField(4, value.getDestinationName());
            if (value.getME() != null) {
                this.jmo.setField(5, value.getME().toByteArray());
            } else {
                this.jmo.setField(5, null);
            }
            this.jmo.setField(6, value.getBusName());
        } else {
            this.jmo.setChoiceField(103, 0);
        }
    }

    @Override
    void updateDataFields(int why) {
        super.updateDataFields(why);
        this.setFlags();
    }

    private final boolean getFlagValue(byte flagBit) {
        return (this.getFlags() & flagBit) != 0;
    }

    private final void setFlagValue(byte flagBit, boolean value) {
        this.flags = value ? (byte)(this.getFlags() | flagBit) : (byte)(this.getFlags() & ~flagBit);
    }

    private final byte getFlags() {
        if (!this.gotFlags) {
            this.flags = (Byte)this.jmo.getField(3);
            this.gotFlags = true;
        }
        return this.flags;
    }

    private final void setFlags() {
        if (this.gotFlags) {
            this.jmo.setField(3, this.flags);
            this.gotFlags = false;
        }
    }

    @Override
    public void getTraceSummaryLine(StringBuilder buff) {
        buff.append(this.getControlMessageType().toString().trim());
        buff.append(":flags=0x");
        buff.append(Integer.toHexString(this.getFlags() & 0xFF));
    }

    protected static void appendArray(StringBuilder buff, String name, long[] values) {
        buff.append(',');
        buff.append(name);
        buff.append("=[");
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    buff.append(',');
                }
                buff.append(values[i]);
            }
        }
        buff.append(']');
    }

    protected static void appendArray(StringBuilder buff, String name, int[] values) {
        buff.append(',');
        buff.append(name);
        buff.append("=[");
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    buff.append(',');
                }
                buff.append(values[i]);
            }
        }
        buff.append(']');
    }

    protected static void appendArray(StringBuilder buff, String name, String[] values) {
        buff.append(',');
        buff.append(name);
        buff.append("=[");
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    buff.append(',');
                }
                buff.append(values[i]);
            }
        }
        buff.append(']');
    }
}

