/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.admin.JsAdminUtils;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsDestinationAddressFactory;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class SIMPUtils {
    public static final int UUID_LENGTH_8 = 8;
    public static final int UUID_LENGTH_12 = 12;
    private static final TraceComponent tc = SibTr.register(SIMPUtils.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public static String pad(String s, int length) {
        if (s.length() < length) {
            StringBuffer a = new StringBuffer(length);
            a.append(s);
            for (int i = s.length(); i < length; ++i) {
                a = a.append(" ");
            }
            return a.toString();
        }
        if (s.length() > length) {
            return s.substring(0, length);
        }
        return s;
    }

    public static SIBUuid12 createSIBUuid12(String s) {
        return new SIBUuid12(SIMPUtils.pad(s, 12).getBytes());
    }

    public static JsDestinationAddress createJsSystemDestinationAddress(String prefix, SIBUuid8 meUuid) {
        JsDestinationAddressFactory addressFactory = (JsDestinationAddressFactory)MessageProcessor.getSingletonInstance("JsDestinationAddressFactory");
        return addressFactory.createJsSystemDestinationAddress(prefix, meUuid);
    }

    public static JsDestinationAddress createJsSystemDestinationAddress(String prefix, SIBUuid8 meUuid, String busName) {
        JsDestinationAddressFactory addressFactory = (JsDestinationAddressFactory)MessageProcessor.getSingletonInstance("JsDestinationAddressFactory");
        return addressFactory.createJsSystemDestinationAddress(prefix, meUuid, busName);
    }

    public static JsDestinationAddress createJsDestinationAddress(String name, SIBUuid8 meUuid) {
        JsDestinationAddressFactory addressFactory = (JsDestinationAddressFactory)MessageProcessor.getSingletonInstance("JsDestinationAddressFactory");
        return addressFactory.createJsDestinationAddress(name, meUuid != null, meUuid);
    }

    public static JsDestinationAddress createJsDestinationAddress(String name, SIBUuid8 meUuid, String busName) {
        JsDestinationAddressFactory addressFactory = (JsDestinationAddressFactory)MessageProcessor.getSingletonInstance("JsDestinationAddressFactory");
        return addressFactory.createJsDestinationAddress(name, meUuid != null, meUuid, busName);
    }

    public static JsDestinationAddress createJsDestinationAddress(String name, String busName, boolean localOnly) {
        JsDestinationAddressFactory addressFactory = (JsDestinationAddressFactory)MessageProcessor.getSingletonInstance("JsDestinationAddressFactory");
        return addressFactory.createJsDestinationAddress(name, localOnly, null, busName);
    }

    public static SIBUuid8 parseME(String destinationName) {
        int index;
        SIBUuid8 meUuid = null;
        if (destinationName != null && (destinationName.startsWith("_P") || destinationName.startsWith("_T") || destinationName.startsWith("_Q")) && (index = destinationName.indexOf(95, 2)) > 1) {
            String meSubstring;
            if (destinationName.startsWith("_P")) {
                meSubstring = destinationName.substring(index + 1);
            } else {
                int startPoint = index + 1;
                int finishPoint = startPoint + 16;
                meSubstring = destinationName.substring(startPoint, finishPoint);
            }
            meUuid = new SIBUuid8(meSubstring);
        }
        return meUuid;
    }

    public static String parseTempPrefix(String destinationName) {
        int index;
        String prefix = null;
        if ((destinationName != null && destinationName.startsWith("_T") || destinationName.startsWith("_Q")) && (index = destinationName.indexOf(95, 2)) > 1) {
            prefix = destinationName.substring(2, index);
        }
        return prefix;
    }

    public static String getStackTrace(Throwable exc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        exc.printStackTrace(pw);
        pw.flush();
        String stackTrace = baos.toString();
        char[] traceChars = new char[stackTrace.length()];
        stackTrace.getChars(0, stackTrace.length(), traceChars, 0);
        boolean notSpace = true;
        int pos = 0;
        for (int i = 0; i < stackTrace.length(); ++i) {
            if (Character.isSpaceChar(traceChars[i])) {
                if (notSpace) {
                    traceChars[pos++] = traceChars[i];
                }
                notSpace = false;
                continue;
            }
            if (!Character.isWhitespace(traceChars[i])) {
                notSpace = true;
                traceChars[pos++] = traceChars[i];
                continue;
            }
            if (!notSpace) continue;
            traceChars[pos++] = 32;
            notSpace = false;
        }
        return new String(traceChars, 0, pos);
    }

    public static String longArrayToString(long[] array) {
        String arrayStr = "[";
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                arrayStr = i == 0 ? arrayStr + array[i] : arrayStr + "," + array[i];
            }
        }
        arrayStr = arrayStr + "]";
        return arrayStr;
    }

    public static String messageHandleArrayToString(SIMessageHandle[] array) {
        String arrayStr = "[";
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                arrayStr = i == 0 ? arrayStr + array[i].toString() : arrayStr + "," + array[i].toString();
            }
        }
        arrayStr = arrayStr + "]";
        return arrayStr;
    }

    public static String getMENameFromUuid(String meUUID) {
        String meName = JsAdminUtils.getMENameByUuidForMessage((String)meUUID);
        if (meName == null) {
            meName = meUUID;
        }
        return meName;
    }

    public static String getRemoteGetKey(SIBUuid8 remoteUuid, SIBUuid12 gatheringTargetDestUuid) {
        String key = null;
        key = gatheringTargetDestUuid != null ? remoteUuid.toString() + gatheringTargetDestUuid.toString() : remoteUuid.toString() + "_DEFAULT_CONSUMER_SET";
        return key;
    }

    public static void setGuaranteedDeliveryProperties(ControlMessage msg, SIBUuid8 sourceMEUuid, SIBUuid8 targetMEUuid, SIBUuid12 streamId, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 targetDestUuid, ProtocolType protocolType, byte protocolVersion) {
        msg.setGuaranteedSourceMessagingEngineUUID(sourceMEUuid);
        msg.setGuaranteedTargetMessagingEngineUUID(targetMEUuid);
        msg.setGuaranteedStreamUUID(streamId);
        msg.setGuaranteedGatheringTargetUUID(gatheringTargetDestUuid);
        msg.setGuaranteedTargetDestinationDefinitionUUID(targetDestUuid);
        if (protocolType != null) {
            msg.setGuaranteedProtocolType(protocolType);
        }
        msg.setGuaranteedProtocolVersion(protocolVersion);
    }

    public static void setGuaranteedDeliveryProperties(JsMessage msg, SIBUuid8 sourceMEUuid, SIBUuid8 targetMEUuid, SIBUuid12 streamId, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 targetDestUuid, ProtocolType protocolType, byte protocolVersion) {
        msg.setGuaranteedSourceMessagingEngineUUID(sourceMEUuid);
        msg.setGuaranteedTargetMessagingEngineUUID(targetMEUuid);
        msg.setGuaranteedStreamUUID(streamId);
        msg.setGuaranteedGatheringTargetUUID(gatheringTargetDestUuid);
        msg.setGuaranteedTargetDestinationDefinitionUUID(targetDestUuid);
        if (protocolType != null) {
            msg.setGuaranteedProtocolType(protocolType);
        }
        msg.setGuaranteedProtocolVersion(protocolVersion);
    }
}

