/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.netty.internal.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.Callable;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class QuiesceHandler
extends ChannelDuplexHandler {
    public static final QuiesceEvent QUIESCE_EVENT = new QuiesceEvent();
    private static final TraceComponent tc = Tr.register(QuiesceHandler.class, (String)"Netty", (String)"io.openliberty.netty.internal.impl.resources.NettyFrameworkMessages");
    private static final Callable<Void> NO_OP_TASK = () -> null;
    private Callable<Void> quiesceTask;
    static final long serialVersionUID = 4355900510489736288L;

    public QuiesceHandler() {
        this.quiesceTask = NO_OP_TASK;
    }

    public QuiesceHandler(Callable<Void> quiesceTask) {
        this.quiesceTask = quiesceTask == null ? NO_OP_TASK : quiesceTask;
    }

    public void setQuiesceTask(Callable<Void> task) {
        this.quiesceTask = task == null ? NO_OP_TASK : task;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Added quiesce handler for channel " + ctx.channel() + " with callable: " + this.quiesceTask), (Object[])new Object[0]);
        }
        super.handlerAdded(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof QuiesceEvent) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received Quiesce Event for " + ctx.channel() + " with callable: " + this.quiesceTask), (Object[])new Object[0]);
            }
            this.handleQuiesce();
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    private void handleQuiesce() throws Exception {
        this.quiesceTask.call();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class QuiesceEvent {
        static final long serialVersionUID = 7930959850335684304L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        QuiesceEvent() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.netty.internal.impl.QuiesceHandler$QuiesceEvent", QuiesceEvent.class, null, null);
        }
    }
}

