/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.cmdline;

import com.ibm.ws.install.InstallKernel;
import com.ibm.ws.install.InstallKernelFactory;
import com.ibm.ws.install.internal.InstallKernelImpl;
import com.ibm.ws.install.internal.cmdline.ExeFindAction;
import com.ibm.ws.install.internal.cmdline.ExeHelpAction;
import com.ibm.ws.install.internal.cmdline.ExeInstallAction;
import com.ibm.ws.install.internal.cmdline.ExeUninstallAction;
import com.ibm.ws.kernel.boot.cmdline.ActionDefinition;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.boot.cmdline.ExitCode;
import com.ibm.ws.kernel.feature.internal.cmdline.ClasspathAction;
import com.ibm.ws.kernel.feature.internal.cmdline.FeatureListAction;
import com.ibm.ws.kernel.feature.internal.cmdline.FeatureToolException;
import com.ibm.ws.kernel.feature.internal.cmdline.ReturnCode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public enum ExeAction implements ActionDefinition
{
    install(new ExeInstallAction(), -1, "--to", "--when-file-exists", "--acceptLicense", "--viewLicenseAgreement", "--viewLicenseInfo", "--downloadOnly", "--location", "--offlineOnly", "--verbose", "name"),
    uninstall(new ExeUninstallAction(), -1, "--noPrompts", "--verbose", "name"),
    featureList((ActionHandler)new FeatureListAction(), 1, "--encoding", "--locale", "--productextension", "fileName"),
    find(new ExeFindAction(), 1, "--viewInfo", "--verbose", "searchString"),
    classpath((ActionHandler)new ClasspathAction(), 1, "--features", "fileName"),
    help(new ExeHelpAction(), 0, new String[0]);

    private List<String> commandOptions;
    private ActionHandler action;
    private int positionalOptions;

    private ExeAction(ActionHandler a, int count, String ... args) {
        this.commandOptions = Collections.unmodifiableList(Arrays.asList(args));
        this.action = a;
        this.positionalOptions = count;
    }

    public List<String> getCommandOptions() {
        return this.commandOptions;
    }

    public int numPositionalArgs() {
        return this.positionalOptions;
    }

    public ExitCode handleTask(Arguments args) {
        try {
            InstallKernel installKernel = InstallKernelFactory.getInstance();
            String verboseLevel = args.getOption("verbose");
            Level logLevel = Level.INFO;
            if (verboseLevel != null && verboseLevel.isEmpty()) {
                logLevel = Level.FINE;
            } else if (verboseLevel != null && verboseLevel.equalsIgnoreCase("debug")) {
                logLevel = Level.FINEST;
            }
            ((InstallKernelImpl)installKernel).enableConsoleLog(logLevel);
            return this.action.handleTask(System.out, System.err, args);
        }
        catch (FeatureToolException fte) {
            System.err.println(fte.getMessage());
            fte.printStackTrace();
            return fte.getReturnCode();
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return ReturnCode.RUNTIME_EXCEPTION;
        }
    }
}

