/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.appsecurity.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfigurationNotAvailableException;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaxRsSSLManager {
    private static final TraceComponent tc = Tr.register(JaxRsSSLManager.class, (String)"com.ibm.ws.jaxrs20.appsecurity", null);
    private static final Map<String, SSLSocketFactory> socketFactories = new HashMap<String, SSLSocketFactory>();
    private static final Map<String, SSLContext> sslContexts = new HashMap<String, SSLContext>();
    private static final JSSEHelper jsseHelper = JSSEHelper.getInstance();
    static final long serialVersionUID = 5163432067333665822L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static SSLSocketFactory getSSLSocketFactoryBySSLRef(String sslRef, String host, String port) {
        SSLSocketFactory sslSocketFactory = null;
        try {
            Map<String, Object> connectionInfo = JaxRsSSLManager.getConnectionInfo(host, port);
            SSLContext sslContext = JaxRsSSLManager.getSSLContext(sslRef, connectionInfo);
            if (sslContext == null) {
                return null;
            }
            boolean recache = false;
            Map<String, Object> map = sslContexts;
            synchronized (map) {
                SSLContext cachedSslContext = sslContexts.get(sslRef);
                if (sslContext == null || !sslContext.equals(cachedSslContext)) {
                    sslContexts.put(sslRef, sslContext);
                    recache = true;
                }
            }
            map = socketFactories;
            synchronized (map) {
                sslSocketFactory = socketFactories.get(sslRef);
                if (sslSocketFactory == null || recache) {
                    sslSocketFactory = sslContext.getSocketFactory();
                    socketFactories.put(sslRef, sslSocketFactory);
                }
            }
        }
        catch (SSLException connectionInfo) {
            FFDCFilter.processException((Throwable)connectionInfo, (String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager", (String)"76", null, (Object[])new Object[]{sslRef, host, port});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("configClientSSL failed to get the SSLSocketFactory with exception: " + e.toString()), (Object[])new Object[0]);
            }
            return null;
        }
        return sslSocketFactory;
    }

    private static Map<String, Object> getConnectionInfo(String host, String port) {
        HashMap<String, Object> connectionInfo = new HashMap<String, Object>();
        connectionInfo.put("com.ibm.ssl.direction", "outbound");
        connectionInfo.put("com.ibm.ssl.remoteHost", host);
        connectionInfo.put("com.ibm.ssl.remotePort", port);
        return connectionInfo;
    }

    /*
     * WARNING - void declaration
     */
    private static Properties getSSLProperties(final String sslRef, final Map<String, Object> connectionInfo) throws SSLException {
        Properties sslProps;
        try {
            sslProps = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){
                static final long serialVersionUID = 703621746367519474L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Properties run() throws SSLException {
                    return jsseHelper.getProperties(sslRef, connectionInfo, null);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager$1", 1.class, (String)"com.ibm.ws.jaxrs20.appsecurity", null);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void pae;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager", (String)"103", null, (Object[])new Object[]{sslRef, connectionInfo});
            Throwable cause = pae.getCause();
            throw (SSLException)cause;
        }
        return sslProps;
    }

    /*
     * WARNING - void declaration
     */
    private static SSLContext getSSLContext(final String sslRef, final Map<String, Object> connectionInfo) throws SSLException {
        Boolean sslCfgExists = null;
        if (sslRef != null) {
            try {
                sslCfgExists = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                    static final long serialVersionUID = 8787405917918590621L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Boolean run() throws SSLException {
                        return jsseHelper.doesSSLConfigExist(sslRef);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager$2", 2.class, (String)"com.ibm.ws.jaxrs20.appsecurity", null);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                void pae;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager", (String)"122", null, (Object[])new Object[]{sslRef, connectionInfo});
                Throwable cause = pae.getCause();
                throw (SSLException)cause;
            }
            if (!sslCfgExists.booleanValue()) {
                return null;
            }
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<SSLContext>(){
                static final long serialVersionUID = -1785304902243624855L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public SSLContext run() throws SSLConfigurationNotAvailableException, SSLException {
                    if (sslRef != null) {
                        return jsseHelper.getSSLContext(sslRef, connectionInfo, null, false);
                    }
                    return jsseHelper.getSSLContext(connectionInfo, JaxRsSSLManager.getSSLProperties(sslRef, connectionInfo));
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager$3", 3.class, (String)"com.ibm.ws.jaxrs20.appsecurity", null);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            FFDCFilter.processException((Throwable)pae, (String)"com.ibm.ws.jaxrs20.appsecurity.security.JaxRsSSLManager", (String)"143", null, (Object[])new Object[]{sslRef, connectionInfo});
            assert (SSLException.class.isAssignableFrom(SSLConfigurationNotAvailableException.class));
            throw (SSLException)pae.getCause();
        }
    }
}

