/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.util.Comparator;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.identitymaps.CacheId;

class CacheIdComparator
implements Comparator<CacheId> {
    CacheIdComparator() {
    }

    @Override
    public int compare(CacheId id1, CacheId id2) {
        if (id1 == id2) {
            return 0;
        }
        return this.compareObjectArrays(id1.primaryKey, id2.primaryKey);
    }

    private int compareObjectArrays(Object[] array1, Object[] array2) {
        if (array1.length == array2.length) {
            int index = 0;
            while (index < array1.length) {
                block12: {
                    Object value1 = array1[index];
                    Object value2 = array2[index];
                    if (value1 == null) {
                        if (value2 != null) {
                            return -1;
                        }
                    } else {
                        int result;
                        if (value2 == null) {
                            return 1;
                        }
                        Class<?> value1Class = value1.getClass();
                        if (value1Class.isArray()) {
                            Class<?> value2Class = value2.getClass();
                            if (value1Class == ClassConstants.APBYTE && value2Class == ClassConstants.APBYTE ? (result = this.compareByteArrays((byte[])value1, (byte[])value2)) != 0 : (value1Class == ClassConstants.APCHAR && value2Class == ClassConstants.APCHAR ? (result = this.compareCharArrays((char[])value1, (char[])value2)) != 0 : (result = this.compareObjectArrays((Object[])value1, (Object[])value2)) != 0)) {
                                return result;
                            }
                        } else {
                            try {
                                int compareTo = ((Comparable)value1).compareTo(value2);
                                if (compareTo != 0) {
                                    return compareTo;
                                }
                            }
                            catch (Exception exception) {
                                result = value1.hashCode() - value2.hashCode();
                                if (result == 0) break block12;
                                return result > 0 ? 1 : -1;
                            }
                        }
                    }
                }
                ++index;
            }
            return 0;
        }
        return array1.length > array2.length ? 1 : -1;
    }

    private int compareCharArrays(char[] array1, char[] array2) {
        if (array1.length == array2.length) {
            int index = 0;
            while (index < array1.length) {
                if (array1[index] != array2[index]) {
                    return array1[index] > array2[index] ? 1 : -1;
                }
                ++index;
            }
            return 0;
        }
        return array1.length > array2.length ? 1 : -1;
    }

    private int compareByteArrays(byte[] array1, byte[] array2) {
        if (array1.length == array2.length) {
            int index = 0;
            while (index < array1.length) {
                if (array1[index] != array2[index]) {
                    return array1[index] > array2[index] ? 1 : -1;
                }
                ++index;
            }
            return 0;
        }
        return array1.length > array2.length ? 1 : -1;
    }
}

