/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.module.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.module.internal.ModuleClassLoaderFactory;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.AltDDEntryGetter;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.metadata.extended.MetaDataGetter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ExtendedModuleInfoImpl
implements ExtendedModuleInfo,
MetaDataGetter<ModuleMetaData>,
AltDDEntryGetter {
    private static final TraceComponent tc = Tr.register(ExtendedModuleInfoImpl.class, (String)"app.manager", (String)"com.ibm.ws.app.manager.module.internal.resources.Messages");
    private final ApplicationInfo appInfo;
    private final String moduleName;
    private final String path;
    private final Container moduleContainer;
    private final Entry altDDEntry;
    private final List<ContainerInfo> moduleClassesContainers;
    private final ModuleClassLoaderFactory classLoaderFactory;
    private final ContainerInfo.Type containerInfoType;
    private ClassLoader classLoader;
    private ModuleMetaData moduleMetaData;
    private List<String> nestedModuleMetaDataTypes;
    private List<ModuleMetaData> nestedModuleMetaDataValues;
    static final long serialVersionUID = 3986734351620206554L;

    public ExtendedModuleInfoImpl(ApplicationInfo appInfo, String moduleName, String path, Container moduleContainer, Entry altDDEntry, List<ContainerInfo> moduleClassesContainers, ModuleClassLoaderFactory classLoaderFactory, ContainerInfo.Type containerInfoType, Class<? extends ModuleInfo> subtype) throws UnableToAdaptException {
        this.appInfo = appInfo;
        this.moduleName = moduleName;
        this.path = path;
        this.moduleContainer = moduleContainer;
        this.altDDEntry = altDDEntry;
        this.moduleClassesContainers = moduleClassesContainers;
        this.classLoaderFactory = classLoaderFactory;
        this.containerInfoType = containerInfoType;
        NonPersistentCache overlayCache = (NonPersistentCache)moduleContainer.adapt(NonPersistentCache.class);
        if (overlayCache != null) {
            overlayCache.addToCache(ModuleInfo.class, (Object)this);
            overlayCache.addToCache(subtype, (Object)this);
        } else if (!FrameworkState.isStopping()) {
            if (containerInfoType == ContainerInfo.Type.RAR_MODULE) {
                throw new UnableToAdaptException(Tr.formatMessage((TraceComponent)tc, (String)"error.cache.adapt.connector", (Object[])new Object[]{moduleName}));
            }
            throw new UnableToAdaptException(Tr.formatMessage((TraceComponent)tc, (String)"error.cache.adapt", (Object[])new Object[]{moduleName}));
        }
    }

    public void setMetaData(ModuleMetaData mmd) {
        this.moduleMetaData = mmd;
    }

    public String getName() {
        return this.moduleName;
    }

    public String getURI() {
        return this.path;
    }

    public Container getContainer() {
        return this.moduleContainer;
    }

    public Entry getAltDDEntry(ContainerInfo.Type type) {
        return type == this.containerInfoType ? this.altDDEntry : null;
    }

    public ModuleMetaData getMetaData() {
        return this.moduleMetaData;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.appInfo;
    }

    public synchronized ClassLoader getClassLoader() {
        if (this.classLoader == null && this.classLoaderFactory != null) {
            this.classLoader = this.classLoaderFactory.createModuleClassLoader((ModuleInfo)this, this.moduleClassesContainers);
        }
        return this.classLoader;
    }

    public synchronized void putNestedMetaData(String moduleType, ModuleMetaData nestedMetaData) {
        if (this.nestedModuleMetaDataTypes == null) {
            this.nestedModuleMetaDataTypes = new ArrayList<String>(2);
            this.nestedModuleMetaDataValues = new ArrayList<ModuleMetaData>(2);
        }
        this.nestedModuleMetaDataTypes.add(moduleType);
        this.nestedModuleMetaDataValues.add(nestedMetaData);
    }

    public synchronized ModuleMetaData getNestedMetaData(String moduleType) {
        int index;
        if (this.nestedModuleMetaDataTypes != null && (index = this.nestedModuleMetaDataTypes.indexOf(moduleType)) >= 0) {
            return this.nestedModuleMetaDataValues.get(index);
        }
        return null;
    }

    public synchronized List<ModuleMetaData> getNestedMetaData() {
        if (this.nestedModuleMetaDataTypes != null) {
            return Collections.unmodifiableList(this.nestedModuleMetaDataValues);
        }
        return Collections.emptyList();
    }
}

