/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.extension.CDIExtensionMetadataInternal;
import com.ibm.ws.container.service.metadata.extended.DeferredMetaDataFactory;
import com.ibm.ws.javaee.version.JavaEEVersion;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.resource.ResourceFactory;
import io.openliberty.cdi.spi.CDIExtensionMetadata;
import io.openliberty.concurrent.internal.cdi.ConcurrencyExtension;
import io.openliberty.concurrent.internal.qualified.QualifiedResourceFactories;
import io.openliberty.concurrent.internal.qualified.QualifiedResourceFactory;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import jakarta.enterprise.inject.spi.Extension;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, service={CDIExtensionMetadata.class, QualifiedResourceFactories.class})
public class ConcurrencyExtensionMetadata
implements CDIExtensionMetadata,
CDIExtensionMetadataInternal,
QualifiedResourceFactories {
    private static final TraceComponent tc = Tr.register(ConcurrencyExtensionMetadata.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.cdi.resources.CWWKCMessages");
    private static final Set<Class<?>> beanClasses = Set.of(ContextService.class, ManagedExecutorService.class, ManagedScheduledExecutorService.class, ManagedThreadFactory.class);
    @Reference(target="(&(id=DefaultContextService)(component.name=com.ibm.ws.context.service))", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected volatile ResourceFactory defaultContextServiceFactory;
    @Reference(target="(&(id=DefaultManagedExecutorService)(component.name=com.ibm.ws.concurrent.internal.ManagedExecutorServiceImpl))", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected volatile ResourceFactory defaultManagedExecutorFactory;
    @Reference(target="(&(id=DefaultManagedScheduledExecutorService)(component.name=com.ibm.ws.concurrent.internal.ManagedScheduledExecutorServiceImpl))", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected volatile ResourceFactory defaultManagedScheduledExecutorFactory;
    @Reference(target="(&(id=DefaultManagedThreadFactory)(component.name=com.ibm.ws.concurrent.internal.ManagedThreadFactoryService))", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected volatile ResourceFactory defaultManagedThreadFactoryFactory;
    public static Version eeVersion;
    @Reference(target="(deferredMetaData=MTF)")
    public volatile DeferredMetaDataFactory mtfMetadataFactory;
    private final Map<String, List<Map<List<String>, QualifiedResourceFactory>>> resourceFactories = new ConcurrentHashMap<String, List<Map<List<String>, QualifiedResourceFactory>>>();
    public static ScheduledExecutorService scheduledExecutor;
    static final long serialVersionUID = -3059292748697173868L;

    public void add(String jeeName, QualifiedResourceFactory.Type resourceType, List<String> qualifierNames, QualifiedResourceFactory resourceFactory) {
        Map<List<String>, QualifiedResourceFactory> qualifiersToResourceFactory;
        QualifiedResourceFactory conflict;
        List<Map<List<String>, QualifiedResourceFactory>> list = this.resourceFactories.get(jeeName);
        if (list == null) {
            list = List.of(new HashMap(), new HashMap(), new HashMap(), new HashMap());
            this.resourceFactories.put(jeeName, list);
        }
        if ((conflict = (qualifiersToResourceFactory = list.get(resourceType.ordinal())).put(qualifierNames, resourceFactory)) != null) {
            Set<String> names = Set.of(resourceFactory.getName(), conflict.getName());
            Tr.error((TraceComponent)tc, (String)"CWWKC1412.qualifier.conflict", (Object[])new Object[]{jeeName, resourceType, resourceFactory.getQualifiers(), names});
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1412.qualifier.conflict", (Object[])new Object[]{jeeName, resourceType, resourceFactory.getQualifiers(), names}));
        }
    }

    public boolean applicationBeansVisible() {
        return true;
    }

    public Set<Class<?>> getBeanClasses() {
        return beanClasses;
    }

    public Set<Class<? extends Extension>> getExtensions() {
        return Collections.singleton(ConcurrencyExtension.class);
    }

    public List<Map<List<String>, QualifiedResourceFactory>> removeAll(String jeeName) {
        return this.resourceFactories.remove(jeeName);
    }

    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected void setEEVersion(ServiceReference<JavaEEVersion> ref) {
        String version = (String)ref.getProperty("version");
        eeVersion = Version.parseVersion((String)version);
    }

    @Reference(target="(deferrable=false)")
    protected void setScheduledExecutor(ScheduledExecutorService svc) {
        scheduledExecutor = svc;
    }

    protected void unsetScheduledExecutor(ScheduledExecutorService svc) {
    }

    protected void unsetEEVersion(ServiceReference<JavaEEVersion> ref) {
    }
}

