/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annocache.AnnotationsBetaHelper;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.info.AnnotationInfo;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AnnotationScanner {
    private static final TraceComponent tc = Tr.register(AnnotationScanner.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static final String JAX_RS_APPLICATION_CLASS_NAME = "javax.ws.rs.core.Application";
    private static final String JAX_RS_APPLICATION_INIT_PARAM = "javax.ws.rs.Application";
    private static final String JAX_RS_APP_PATH_ANNOTATION_CLASS_NAME = "javax.ws.rs.ApplicationPath";
    private static final String JAX_RS_PATH_ANNOTATION_CLASS_NAME = "javax.ws.rs.Path";
    private static final String OPENAPI_SCHEMA_ANNOTATION_CLASS_NAME = "org.eclipse.microprofile.openapi.annotations.media.Schema";
    private static final String MP_REGISTER_REST_CLIENT = "org.eclipse.microprofile.rest.client.inject.RegisterRestClient";
    private static final List<String> ANNOTATION_CLASS_NAMES = Arrays.asList("javax.ws.rs.Path", "javax.ws.rs.ApplicationPath", "org.eclipse.microprofile.openapi.annotations.media.Schema");
    private final WebAnnotations webAnnotations;
    private String urlMapping;
    private final WebAppConfig appConfig;
    static final long serialVersionUID = -4229953823658161070L;

    public AnnotationScanner(ClassLoader classLoader, Container containerToAdapt) throws UnableToAdaptException {
        this.webAnnotations = AnnotationsBetaHelper.getWebAnnotations((Container)containerToAdapt);
        this.appConfig = ((WebModuleMetaData)containerToAdapt.adapt(WebModuleMetaData.class)).getConfiguration();
    }

    public boolean anyAnnotatedClasses() {
        return !this.getAnnotatedClassesNames().isEmpty();
    }

    private String getUrlMappingFromServlet(IServletConfig sconfig) {
        if (sconfig.getMappings() != null && sconfig.getMappings().size() > 0) {
            String urlMapping = (String)sconfig.getMappings().get(0);
            if (!urlMapping.startsWith("/")) {
                urlMapping = "/" + urlMapping;
            }
            if (urlMapping.endsWith("/*")) {
                urlMapping = urlMapping.substring(0, urlMapping.length() - 2);
            }
            if (urlMapping.endsWith("/")) {
                urlMapping = urlMapping.substring(0, urlMapping.length() - 1);
            }
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Found url mapping " + urlMapping + " in web.xml for " + sconfig.getServletName()), (Object[])new Object[0]);
            }
            return urlMapping;
        }
        return null;
    }

    private String getUrlMappingFromApp(String appName) throws UnableToAdaptException {
        AnnotationInfo aInf;
        ClassInfo cInf = this.webAnnotations.getClassInfo(appName);
        if (cInf != null && (aInf = cInf.getAnnotation(JAX_RS_APP_PATH_ANNOTATION_CLASS_NAME)) != null) {
            String annInfoVal = aInf.getValue("value").getStringValue();
            if (annInfoVal.isEmpty() || annInfoVal.equals("/")) {
                return "";
            }
            if (!annInfoVal.startsWith("/")) {
                annInfoVal = "/" + annInfoVal;
            }
            if (annInfoVal.endsWith("/*")) {
                annInfoVal = annInfoVal.substring(0, annInfoVal.length() - 2);
            }
            if (annInfoVal.endsWith("/")) {
                annInfoVal = annInfoVal.substring(0, annInfoVal.length() - 1);
            }
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Found url mapping " + annInfoVal + " in Application classs " + appName), (Object[])new Object[0]);
            }
            return annInfoVal;
        }
        return null;
    }

    private Set<String> getAllApplicationClasses() throws UnableToAdaptException {
        AnnotationTargets_Targets annotationTargets = this.webAnnotations.getAnnotationTargets();
        HashSet<String> applicationClasses = new HashSet<String>();
        applicationClasses.addAll(annotationTargets.getSubclassNames(JAX_RS_APPLICATION_CLASS_NAME));
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)"Found application classes: ", (Object[])new Object[]{applicationClasses});
        }
        return applicationClasses;
    }

    private String getServletForDefaultApplication() {
        IServletConfig servletConfig = this.appConfig.getServletInfo(JAX_RS_APPLICATION_CLASS_NAME);
        if (servletConfig != null) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)"Found servlet for javax.ws.rs.core.Application", (Object[])new Object[0]);
            }
            return this.getUrlMappingFromServlet(servletConfig);
        }
        return null;
    }

    private String findServletMappingForApp(String appClassName) throws UnableToAdaptException {
        if (appClassName == null) {
            return null;
        }
        IServletConfig servletConfig = this.appConfig.getServletInfo(appClassName);
        if (servletConfig != null) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)(appClassName + ": Found servlet " + servletConfig.getServletName() + " using servlet-name"), (Object[])new Object[0]);
            }
            return this.getUrlMappingFromServlet(servletConfig);
        }
        Iterator servletIterator = this.appConfig.getServletInfos();
        while (servletIterator.hasNext()) {
            servletConfig = (IServletConfig)servletIterator.next();
            String servletClass = servletConfig.getClassName();
            if (servletClass != null && servletClass.equals(appClassName)) {
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)(appClassName + ": Found servlet " + servletConfig.getServletName() + " using sevlet-class"), (Object[])new Object[0]);
                }
                return this.getUrlMappingFromServlet(servletConfig);
            }
            String initParam = servletConfig.getInitParameter(JAX_RS_APPLICATION_INIT_PARAM);
            if (initParam == null || !initParam.equals(appClassName)) continue;
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)(appClassName + ": Found servlet " + servletConfig.getServletName() + " using init-param"), (Object[])new Object[0]);
            }
            return this.getUrlMappingFromServlet(servletConfig);
        }
        return this.getUrlMappingFromApp(appClassName);
    }

    @FFDCIgnore(value={UnableToAdaptException.class})
    public synchronized Set<String> getAnnotatedClassesNames() {
        Set restAPIClasses;
        block2: {
            restAPIClasses = null;
            try {
                AnnotationTargets_Targets annotationTargets = this.webAnnotations.getAnnotationTargets();
                restAPIClasses = ANNOTATION_CLASS_NAMES.stream().flatMap(anno -> annotationTargets.getAnnotatedClasses(anno, AnnotationTargets_Targets.POLICY_SEED).stream()).collect(Collectors.toSet());
                Set mpRestClientClasses = annotationTargets.getAnnotatedClasses(MP_REGISTER_REST_CLIENT);
                restAPIClasses.removeAll(mpRestClientClasses);
            }
            catch (UnableToAdaptException e) {
                if (!OpenAPIUtils.isEventEnabled(tc)) break block2;
                Tr.event((TraceComponent)tc, (String)"Unable to get annotated class names", (Object[])new Object[0]);
            }
        }
        return Collections.unmodifiableSet(restAPIClasses);
    }

    public String getURLMapping(Set<String> classesToScan) {
        block11: {
            this.urlMapping = null;
            try {
                Set appClassNames = this.getAllApplicationClasses().stream().filter(classesToScan::contains).collect(Collectors.toSet());
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)"Application classes after filtering: ", (Object[])new Object[]{appClassNames});
                }
                if (appClassNames.size() < 2) {
                    String urlMapping = null;
                    if (appClassNames.size() == 0) {
                        if (OpenAPIUtils.isEventEnabled(tc)) {
                            Tr.event((TraceComponent)tc, (String)"Found no Application classes. Trying to find default app servlet", (Object[])new Object[0]);
                        }
                        urlMapping = this.getServletForDefaultApplication();
                    }
                    if (appClassNames.size() == 1) {
                        if (OpenAPIUtils.isEventEnabled(tc)) {
                            Tr.event((TraceComponent)tc, (String)"Found one Application class. Trying to find url mapping", (Object[])new Object[0]);
                        }
                        urlMapping = this.findServletMappingForApp((String)appClassNames.iterator().next());
                    }
                    this.urlMapping = urlMapping;
                } else if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)"Found multiple Application classes. This is not supported at this time.", (Object[])new Object[0]);
                }
            }
            catch (Exception appClassNames) {
                FFDCFilter.processException((Throwable)appClassNames, (String)"com.ibm.ws.microprofile.openapi.AnnotationScanner", (String)"242", (Object)this, (Object[])new Object[]{classesToScan});
                if (!OpenAPIUtils.isEventEnabled(tc)) break block11;
                Tr.event((TraceComponent)tc, (String)"Unable to get url mapping", (Object[])new Object[0]);
            }
        }
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("urlMapping=" + this.urlMapping), (Object[])new Object[0]);
        }
        return this.urlMapping;
    }
}

