/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.location.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.service.location.internal.InternalWsResource;
import com.ibm.ws.kernel.service.location.internal.LocalFileResource;
import com.ibm.ws.kernel.service.location.internal.ResourceIterators;
import com.ibm.ws.kernel.service.location.internal.SymbolRegistry;
import com.ibm.ws.kernel.service.location.internal.SymbolicRootResource;
import com.ibm.ws.kernel.service.location.internal.WsLocationAdminImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.MalformedLocationException;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class ResourceUtils {
    public static final List<String> EMPTY_STRING_LIST;
    static final long serialVersionUID = -9150482003096412475L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private ResourceUtils() {
        throw new AssertionError((Object)"This class is not instantiable");
    }

    static boolean isFileAChild(File parent, File child) {
        String pNormalized = PathUtils.normalize(parent.getAbsolutePath());
        String cNormalized = PathUtils.normalize(child.getAbsolutePath());
        if (cNormalized.length() <= pNormalized.length()) {
            return false;
        }
        return cNormalized.startsWith(pNormalized);
    }

    static InternalWsResource getChildResource(InternalWsResource parent, String child) {
        if (child == null || parent == null) {
            return null;
        }
        if ((child = PathUtils.normalizeDescendentPath(child)).length() == 0) {
            return null;
        }
        for (int i = 0; i < child.length() - 1; ++i) {
            if (child.charAt(i) != File.separatorChar && child.charAt(i) != '/') continue;
            throw new MalformedLocationException("Child name can not contain path separator characters");
        }
        File f = new File(parent.getNormalizedPath(), child);
        if (f.exists()) {
            String repPath = parent.getRawRepositoryPath();
            if (repPath != null) {
                repPath = repPath.endsWith("/") ? repPath + child : repPath + '/' + child;
            }
            return LocalFileResource.newResourceFromResource(parent.getNormalizedPath() + child, repPath, parent);
        }
        return null;
    }

    static Iterator<String> getChildren(InternalWsResource parent, File wrappedFile) {
        return new ResourceIterators.ChildIterator(wrappedFile, wrappedFile.list());
    }

    static Iterator<String> getChildren(InternalWsResource parent, File wrappedFile, final String regex) {
        String[] listFiles = wrappedFile.list(new FilenameFilter(){
            Pattern p;
            static final long serialVersionUID = -4000145580395215986L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;
            {
                this.p = Pattern.compile(regex);
            }

            @Override
            public boolean accept(File dir, String name) {
                File f = new File(dir, name);
                if (f.isDirectory()) {
                    name = name + '/';
                }
                Matcher m = this.p.matcher(name);
                return m.matches();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.location.internal.ResourceUtils$1", 1.class, (String)"locationService", (String)"com.ibm.ws.kernel.service.location.internal.resources.LocServiceMessages");
            }
        });
        return new ResourceIterators.ChildIterator(wrappedFile, listFiles);
    }

    static InternalWsResource getParentResource(InternalWsResource child, SymbolicRootResource root) {
        String parentPath = new File(child.getNormalizedPath()).getParent();
        if (parentPath == null) {
            return null;
        }
        parentPath = PathUtils.slashify(parentPath + '/');
        if (root.getNormalizedPath().equals(parentPath)) {
            return root;
        }
        if (root.contains(parentPath)) {
            String repositoryPath = child.getRawRepositoryPath();
            if (repositoryPath != null) {
                int last = child.isType(WsResource.Type.DIRECTORY) ? repositoryPath.length() - 2 : repositoryPath.length() - 1;
                repositoryPath = repositoryPath.substring(0, repositoryPath.lastIndexOf(47, last) + 1);
            }
            return LocalFileResource.newResourceFromResource(parentPath, repositoryPath, child);
        }
        return null;
    }

    static WsResource getRelativeResource(InternalWsResource base, String relativePath) {
        if (base == null) {
            throw new NullPointerException("Resolving relative resource requires a base");
        }
        if (relativePath == null) {
            return null;
        }
        String path = PathUtils.normalize(relativePath);
        if (PathUtils.pathIsAbsolute(path)) {
            return WsLocationAdminImpl.getInstance().resolveResource(relativePath);
        }
        String newPath = ResourceUtils.resolveRelativeUsingFile(base.getNormalizedPath(), relativePath);
        SymbolicRootResource root = base.getSymbolicRoot();
        if (root.getNormalizedPath().equals(newPath)) {
            return root;
        }
        if (root.contains(newPath)) {
            return LocalFileResource.newResourceFromResource(newPath, null, base);
        }
        SymbolicRootResource newRoot = SymbolRegistry.getRegistry().findRoot(newPath);
        return LocalFileResource.newResource(newPath, null, newRoot);
    }

    static String resolveRelativeUsingFile(String normalizedRoot, String relativePath) {
        if (normalizedRoot == null) {
            return null;
        }
        int n_length = normalizedRoot.length();
        if (n_length == 0) {
            return relativePath;
        }
        if (normalizedRoot.charAt(n_length - 1) == '/') {
            return PathUtils.normalize(normalizedRoot + relativePath);
        }
        int index = normalizedRoot.lastIndexOf(47);
        String root = normalizedRoot.substring(0, index + 1);
        return PathUtils.normalize(root + relativePath);
    }

    static String createRepositoryURI(InternalWsResource descendant, SymbolicRootResource root) {
        String normalizedPath = descendant.getNormalizedPath();
        String normalizedRoot = root.getNormalizedPath();
        String rootSymbolicPath = root.toRepositoryPath();
        if (root.contains(normalizedPath)) {
            String substr = normalizedPath.substring(normalizedRoot.length());
            StringBuilder uri = new StringBuilder(rootSymbolicPath.length() + substr.length());
            uri.append(rootSymbolicPath).append(substr);
            return uri.toString();
        }
        return descendant.toExternalURI().toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.service.location.internal.ResourceUtils", ResourceUtils.class, (String)"locationService", (String)"com.ibm.ws.kernel.service.location.internal.resources.LocServiceMessages");
        EMPTY_STRING_LIST = Collections.unmodifiableList(new ArrayList());
    }
}

