/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jdbc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.cm.AppDefinedResourceFactory;
import com.ibm.ws.jca.cm.ConnectionManagerService;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.jdbc.DataSourceService;
import com.ibm.ws.jdbc.internal.DataSourceDef;
import com.ibm.ws.jdbc.internal.JDBCDriverService;
import com.ibm.ws.jdbc.internal.JDBCDrivers;
import com.ibm.ws.jdbc.internal.PropertyService;
import com.ibm.ws.resource.ResourceFactory;
import com.ibm.ws.resource.ResourceFactoryBuilder;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.library.Library;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;

public class DataSourceResourceFactoryBuilder
implements ResourceFactoryBuilder {
    private static final String BASE_PROPERTIES_KEY = "properties.0.";
    private static final TraceComponent tc = Tr.register(DataSourceResourceFactoryBuilder.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final String CONFIG_DISPLAY_ID = "config.displayId";
    private static final String CONFIG_SOURCE = "config.source";
    private static final String FILE = "file";
    private static final String ID = "id";
    private final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("configAdmin");
    private ConnectorService connectorSvc;

    protected void activate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{context});
        }
        this.configAdminRef.activate(context);
    }

    public ResourceFactory createResourceFactory(Map<String, Object> props) throws Exception {
        Object value;
        String onConnect;
        String recoveryAuthDataRef;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createResourceFactory", (Object[])new Object[]{PropertyService.hidePasswords(props)});
        }
        Hashtable<String, String> cmSvcProps = new Hashtable<String, String>();
        Hashtable<String, Object> dsSvcProps = new Hashtable<String, Object>();
        Hashtable<String, Object> driverProps = new Hashtable<String, Object>();
        HashMap<String, Object> vendorProps = new HashMap<String, Object>();
        VariableRegistry variableRegistry = this.connectorSvc.getVariableRegistry();
        for (Map.Entry<String, Object> prop : props.entrySet()) {
            Object value2 = prop.getValue();
            if (value2 instanceof String) {
                value2 = variableRegistry.resolveRawString((String)value2);
            }
            vendorProps.put(prop.getKey(), value2);
        }
        String application = (String)vendorProps.remove("application");
        String declaringApplication = (String)vendorProps.remove("declaringApplication");
        String module = (String)vendorProps.remove("module");
        String component = (String)vendorProps.remove("component");
        String jndiName = (String)vendorProps.remove("jndiName");
        String dataSourceID = DataSourceResourceFactoryBuilder.getDataSourceID(application, module, component, jndiName);
        String conManagerID = dataSourceID + '/' + "connectionManager";
        String jdbcDriverID = dataSourceID + '/' + "jdbcDriver";
        String conManagerFilter = FilterUtils.createPropertyFilter((String)ID, (String)conManagerID);
        String jdbcDriverFilter = FilterUtils.createPropertyFilter((String)ID, (String)jdbcDriverID);
        StringBuilder filter = new StringBuilder(FilterUtils.createPropertyFilter((String)ID, (String)dataSourceID));
        filter.insert(filter.length() - 1, '*');
        if (!this.removeExistingConfigurations(filter.toString())) {
            throw new IllegalArgumentException(dataSourceID);
        }
        cmSvcProps.put(ID, conManagerID);
        cmSvcProps.put(CONFIG_DISPLAY_ID, conManagerID);
        driverProps.put(ID, jdbcDriverID);
        driverProps.put(CONFIG_DISPLAY_ID, jdbcDriverID);
        dsSvcProps.put(ID, dataSourceID);
        dsSvcProps.put(CONFIG_DISPLAY_ID, dataSourceID);
        dsSvcProps.put("jndiName", jndiName);
        dsSvcProps.put("jndiName.unique", dataSourceID);
        dsSvcProps.put("connectionManager.target", conManagerFilter);
        dsSvcProps.put("driver.target", jdbcDriverFilter);
        dsSvcProps.put("connectionManager.cardinality.minimum", 1);
        BundleContext bundleContext = DataSourceService.priv.getBundleContext(FrameworkUtil.getBundle(DataSourceResourceFactoryBuilder.class));
        String containerAuthDataRef = (String)vendorProps.remove("containerAuthDataRef");
        if (containerAuthDataRef != null) {
            String authDataFilter = FilterUtils.createPropertyFilter((String)ID, (String)containerAuthDataRef);
            ServiceReference[] refs = DataSourceService.priv.getServiceReferences(bundleContext, "com.ibm.websphere.security.auth.data.AuthData", authDataFilter);
            if (refs == null || refs.length == 0) {
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"PROP_SET_ERROR", (Object[])new Object[]{"containerAuthDataRef", "", containerAuthDataRef}));
            }
            dsSvcProps.put("containerAuthDataRef", new String[]{(String)refs[0].getProperty("service.pid")});
            dsSvcProps.put("containerAuthData.target", authDataFilter);
            dsSvcProps.put("containerAuthData.cardinality.minimum", 1);
        }
        if ((recoveryAuthDataRef = (String)vendorProps.remove("recoveryAuthDataRef")) != null) {
            String authDataFilter = FilterUtils.createPropertyFilter((String)ID, (String)recoveryAuthDataRef);
            ServiceReference[] refs = DataSourceService.priv.getServiceReferences(bundleContext, "com.ibm.websphere.security.auth.data.AuthData", authDataFilter);
            if (refs == null || refs.length == 0) {
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"PROP_SET_ERROR", (Object[])new Object[]{"recoveryAuthDataRef", "", recoveryAuthDataRef}));
            }
            dsSvcProps.put("recoveryAuthDataRef", new String[]{(String)refs[0].getProperty("service.pid")});
            dsSvcProps.put("recoveryAuthData.target", authDataFilter);
            dsSvcProps.put("recoveryAuthData.cardinality.minimum", 1);
        }
        if ((onConnect = (String)vendorProps.remove("onConnect")) != null) {
            dsSvcProps.put("onConnect", new String[]{onConnect});
        }
        if (application != null) {
            dsSvcProps.put("application", application);
            if (module != null) {
                dsSvcProps.put("module", module);
                if (component != null) {
                    dsSvcProps.put("component", component);
                }
            }
        }
        for (String name : DSConfig.DATA_SOURCE_PROPS) {
            value = vendorProps.remove(name);
            if (value == null) continue;
            dsSvcProps.put(name, value);
        }
        String className = (String)vendorProps.remove(DataSourceDef.className.name());
        String url = (String)vendorProps.remove(DataSourceDef.url.name());
        if (vendorProps.containsKey(DataSourceDef.databaseName.name()) || vendorProps.containsKey(DataSourceDef.portNumber.name())) {
            url = null;
        }
        className = this.updateWithLibraries(bundleContext, application, declaringApplication, className, url, driverProps, dsSvcProps);
        boolean isUCP = className.startsWith("oracle.ucp");
        for (String string : ConnectionManagerService.CONNECTION_MANAGER_PROPS) {
            if (isUCP && ConnectionManagerService.CONNECTION_MANAGER_DSD_PROPS.contains(string) || (value = vendorProps.remove(string)) == null) continue;
            cmSvcProps.put(string, (String)value);
        }
        if (!isUCP && (value = vendorProps.remove(DataSourceDef.initialPoolSize.name())) != null && (Integer)value > 0) {
            ConnectorService.logMessage((Level)Level.INFO, (String)"IGNORE_FEATURE_J2CA0240", (Object[])new Object[]{DataSourceDef.initialPoolSize.name(), jndiName});
        }
        if ((value = vendorProps.remove(DataSourceDef.maxStatements.name())) != null) {
            int n;
            Integer maxPoolSize = (Integer)(isUCP ? vendorProps.get(DataSourceDef.maxPoolSize.name()) : cmSvcProps.get(DataSourceDef.maxPoolSize.name()));
            int n2 = n = maxPoolSize == null || maxPoolSize <= 0 ? 0 : (Integer)value / maxPoolSize;
            if (isUCP) {
                vendorProps.put(DataSourceDef.maxStatements.name(), n);
            } else {
                dsSvcProps.put("statementCacheSize", n);
            }
        }
        if (!vendorProps.containsKey(DataSourceDef.serverName.name())) {
            if (url != null) {
                vendorProps.put("URL", url);
            } else if (!className.startsWith("org.apache.derby.jdbc.Embedded")) {
                vendorProps.put(DataSourceDef.serverName.name(), "localhost");
            }
        }
        PropertyService.parseDurationProperties(vendorProps, className, this.connectorSvc);
        PropertyService.parsePasswordProperties(vendorProps);
        dsSvcProps.put("properties.0.config.referenceType", "com.ibm.ws.jdbc.dataSource.properties");
        for (Map.Entry entry : vendorProps.entrySet()) {
            dsSvcProps.put(BASE_PROPERTIES_KEY + (String)entry.getKey(), entry.getValue());
        }
        StringBuilder dsFilter = new StringBuilder(200);
        dsFilter.append("(&").append(FilterUtils.createPropertyFilter((String)ID, (String)dataSourceID));
        dsFilter.append(FilterUtils.createPropertyFilter((String)"objectClass", (String)DataSourceService.class.getName())).append(")");
        AppDefinedResourceFactory appDefinedResourceFactory = new AppDefinedResourceFactory((ResourceFactoryBuilder)this, bundleContext, dataSourceID, dsFilter.toString(), declaringApplication);
        ConfigurationAdmin configAdmin = null;
        try {
            String bundleLocation = bundleContext.getBundle().getLocation();
            String jcaBundleLocation = DataSourceService.priv.getBundleContext(FrameworkUtil.getBundle(ConnectorService.class)).getBundle().getLocation();
            configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
            Configuration conMgrConfig = configAdmin.createFactoryConfiguration("com.ibm.ws.jca.connectionManager", jcaBundleLocation);
            conMgrConfig.update(cmSvcProps);
            dsSvcProps.put("connectionManagerRef", new String[]{conMgrConfig.getPid()});
            Configuration driverConfig = configAdmin.createFactoryConfiguration("com.ibm.ws.jdbc.jdbcDriver", bundleLocation);
            driverConfig.update(driverProps);
            dsSvcProps.put("jdbcDriverRef", new String[]{driverConfig.getPid()});
            Configuration dsSvcConfig = configAdmin.createFactoryConfiguration("com.ibm.ws.jdbc.dataSource", bundleLocation);
            dsSvcConfig.update(dsSvcProps);
        }
        catch (Exception x) {
            appDefinedResourceFactory.destroy();
            throw x;
        }
        catch (Error x) {
            appDefinedResourceFactory.destroy();
            throw x;
        }
        finally {
            if (configAdmin != null) {
                bundleContext.ungetService(this.configAdminRef.getReference());
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createResourceFactory", (Object)appDefinedResourceFactory);
        }
        return appDefinedResourceFactory;
    }

    protected void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"deactivate", (Object[])new Object[]{context});
        }
        this.configAdminRef.deactivate(context);
    }

    private static final String getDataSourceID(String application, String module, String component, String jndiName) {
        StringBuilder sb = new StringBuilder(jndiName.length() + 80);
        if (application != null) {
            sb.append("application").append('[').append(application).append(']').append('/');
            if (module != null) {
                sb.append("module").append('[').append(module).append(']').append('/');
                if (component != null) {
                    sb.append("component").append('[').append(component).append(']').append('/');
                }
            }
        }
        return sb.append("dataSource").append('[').append(jndiName).append(']').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeExistingConfigurations(String filter) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        BundleContext bundleContext = DataSourceService.priv.getBundleContext(FrameworkUtil.getBundle(DataSourceResourceFactoryBuilder.class));
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
        try {
            Configuration[] existingConfigurations = configAdmin.listConfigurations(filter);
            if (existingConfigurations != null) {
                for (Configuration config : existingConfigurations) {
                    Dictionary cfgProps = config.getProperties();
                    if (cfgProps != null && FILE.equals(cfgProps.get(CONFIG_SOURCE))) {
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"configuration found in server.xml: ", (Object[])new Object[]{config.getPid()});
                        }
                        boolean bl = false;
                        return bl;
                    }
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"removing", (Object[])new Object[]{config.getPid()});
                    }
                    config.delete();
                }
            }
        }
        finally {
            bundleContext.ungetService(this.configAdminRef.getReference());
        }
        return true;
    }

    protected void setConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setConfigAdmin", (Object[])new Object[]{ref});
        }
        this.configAdminRef.setReference(ref);
    }

    protected void setConnectorService(ConnectorService svc) {
        this.connectorSvc = svc;
    }

    protected void unsetConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetConfigAdmin", (Object[])new Object[]{ref});
        }
        this.configAdminRef.unsetReference(ref);
    }

    protected void unsetConnectorService(ConnectorService svc) {
        this.connectorSvc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String updateWithLibraries(BundleContext bundleContext, String applicationName, String declaringApplication, String className, String url, Hashtable<String, Object> driverProps, Hashtable<String, Object> dsSvcProps) throws Exception {
        String message;
        Set<String> searchedPackages;
        int[] dsTypeSearchOrder;
        boolean hasImplClassName;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateWithLibraries", (Object[])new Object[]{applicationName, className});
        }
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getServiceWithException();
        Configuration[] classloaderConfigs = null;
        ServiceReference[] refs = DataSourceService.priv.getServiceReferences(bundleContext, "com.ibm.wsspi.application.Application", FilterUtils.createPropertyFilter((String)"name", (String)declaringApplication));
        if (refs != null && refs.length > 0) {
            ServiceReference appRef = refs[0];
            String parentPid = (String)appRef.getProperty("service.pid");
            String sourcePid = (String)appRef.getProperty("ibm.extends.source.pid");
            if (sourcePid != null) {
                parentPid = sourcePid;
            }
            StringBuilder classloaderFilter = new StringBuilder(200);
            classloaderFilter.append("(&");
            classloaderFilter.append(FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)"com.ibm.ws.classloading.classloader"));
            classloaderFilter.append(FilterUtils.createPropertyFilter((String)"config.parentPID", (String)parentPid));
            classloaderFilter.append(')');
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"filter for classloaders", (Object[])new Object[]{classloaderFilter});
            }
            if (classloaderFilter.length() > 3) {
                classloaderConfigs = configAdmin.listConfigurations(classloaderFilter.toString());
            }
        }
        StringBuilder commonLibraryFilter = new StringBuilder(500);
        StringBuilder libraryFilter = new StringBuilder(500);
        commonLibraryFilter.append("(|");
        libraryFilter.append("(|");
        if (classloaderConfigs != null) {
            for (String string : classloaderConfigs) {
                Object commonLibraryRef;
                int n;
                Object privateLibraryRef;
                Dictionary classloaderProps = string.getProperties();
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"classloader", (Object[])new Object[]{classloaderProps});
                }
                if (applicationName != null) {
                    Object overrideLibraryRef = classloaderProps.get("overrideLibraryRef");
                    if (overrideLibraryRef != null && overrideLibraryRef instanceof String[]) {
                        for (String pid : (String[])overrideLibraryRef) {
                            libraryFilter.append(FilterUtils.createPropertyFilter((String)"service.pid", (String)pid));
                        }
                    }
                    if ((privateLibraryRef = classloaderProps.get("privateLibraryRef")) != null && privateLibraryRef instanceof String[]) {
                        String[] stringArray = (String[])privateLibraryRef;
                        n = stringArray.length;
                        for (int pid = 0; pid < n; ++pid) {
                            String pid2 = stringArray[pid];
                            libraryFilter.append(FilterUtils.createPropertyFilter((String)"service.pid", (String)pid2));
                        }
                    }
                }
                if ((commonLibraryRef = classloaderProps.get("commonLibraryRef")) == null || !(commonLibraryRef instanceof String[])) continue;
                privateLibraryRef = (String[])commonLibraryRef;
                int n2 = ((V)privateLibraryRef).length;
                for (n = 0; n < n2; ++n) {
                    Object pid = privateLibraryRef[n];
                    commonLibraryFilter.append(FilterUtils.createPropertyFilter((String)"service.pid", pid));
                }
            }
        }
        commonLibraryFilter.append(')');
        libraryFilter.append(')');
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"filters for libraries", (Object[])new Object[]{commonLibraryFilter, libraryFilter});
        }
        LinkedList libraryRefs = new LinkedList();
        if (commonLibraryFilter.length() > 3) {
            libraryRefs.addAll(DataSourceService.priv.getServiceReferences(bundleContext, Library.class, commonLibraryFilter.toString()));
        }
        if (libraryFilter.length() > 3) {
            libraryRefs.addAll(DataSourceService.priv.getServiceReferences(bundleContext, Library.class, libraryFilter.toString()));
        }
        if (libraryRefs.size() == 0) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No direct library refs found on datasource, using global shared lib", (Object[])new Object[0]);
            }
            StringBuilder globalLibFilter = new StringBuilder("(&");
            globalLibFilter.append(FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)"com.ibm.ws.classloading.sharedlibrary"));
            globalLibFilter.append(FilterUtils.createPropertyFilter((String)ID, (String)"global"));
            globalLibFilter.append(")");
            Collection globalLib = DataSourceService.priv.getServiceReferences(bundleContext, Library.class, globalLibFilter.toString());
            libraryRefs.addAll(globalLib);
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"libraries", (Object[])libraryRefs.toArray());
        }
        String[][] dsClassInfo = new String[3][2];
        boolean CLASS_NAME = false;
        boolean bl = true;
        TreeSet<String> searchedLibraryFiles = new TreeSet<String>();
        boolean bl2 = hasImplClassName = className != null && className.length() > 0;
        if (hasImplClassName) {
            if (XADataSource.class.getName().equals(className)) {
                dsTypeSearchOrder = new int[]{2};
                searchedPackages = new TreeSet<String>();
                hasImplClassName = false;
            } else if (ConnectionPoolDataSource.class.getName().equals(className)) {
                dsTypeSearchOrder = new int[]{1};
                searchedPackages = new TreeSet<String>();
                hasImplClassName = false;
            } else if (DataSource.class.getName().equals(className)) {
                dsTypeSearchOrder = new int[]{0};
                searchedPackages = new TreeSet<String>();
                hasImplClassName = false;
            } else if (Driver.class.getName().equals(className)) {
                dsTypeSearchOrder = null;
                searchedPackages = Collections.singleton("META-INF/services/java.sql.Driver");
                hasImplClassName = false;
            } else {
                dsTypeSearchOrder = null;
                searchedPackages = null;
            }
        } else if (url == null) {
            dsTypeSearchOrder = new int[]{2, 1, 0};
            searchedPackages = new TreeSet<String>();
        } else {
            dsTypeSearchOrder = null;
            searchedPackages = Collections.singleton("META-INF/services/java.sql.Driver");
        }
        for (ServiceReference libraryRef : libraryRefs) {
            Library library = (Library)DataSourceService.priv.getService(bundleContext, libraryRef);
            try {
                String libraryPid = (String)libraryRef.getProperty("service.pid");
                if (library == null) {
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"library not found", (Object[])new Object[]{libraryPid});
                    continue;
                }
                try {
                    ClassLoader loader = AdapterUtil.getClassLoaderWithPriv(library);
                    String type = null;
                    if (hasImplClassName) {
                        Class cl = DataSourceService.priv.loadClass(loader, className);
                        type = XADataSource.class.isAssignableFrom(cl) ? XADataSource.class.getName() : (ConnectionPoolDataSource.class.isAssignableFrom(cl) ? ConnectionPoolDataSource.class.getName() : (DataSource.class.isAssignableFrom(cl) ? DataSource.class.getName() : Driver.class.getName()));
                    } else {
                        searchedLibraryFiles.addAll(JDBCDriverService.getAbsolutePaths(library));
                        if (dsTypeSearchOrder == null) {
                            type = Driver.class.getName();
                            for (Driver driver : ServiceLoader.load(Driver.class, loader)) {
                                if (trace && tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)"trying driver", (Object[])new Object[]{driver});
                                }
                                try {
                                    if (driver.acceptsURL(url)) {
                                        if (trace && tc.isDebugEnabled()) {
                                            Tr.debug((Object)this, (TraceComponent)tc, (String)(driver + " accepts " + PropertyService.filterURL(url)), (Object[])new Object[0]);
                                        }
                                        className = driver.getClass().getName();
                                        break;
                                    }
                                    if (!trace || !tc.isDebugEnabled()) continue;
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)(driver + " does not accept " + PropertyService.filterURL(url)), (Object[])new Object[0]);
                                }
                                catch (SQLException x) {
                                    if (!trace || !tc.isDebugEnabled()) continue;
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)(driver + " does not accept " + PropertyService.filterURL(url)), (Object[])new Object[]{x});
                                }
                            }
                        } else {
                            int dsType;
                            AbstractMap.SimpleEntry<Integer, String> dsEntry = JDBCDrivers.inferDataSourceClassFromDriver(loader, searchedPackages, dsTypeSearchOrder);
                            if (dsEntry != null && dsClassInfo[dsType = dsEntry.getKey().intValue()][0] == null) {
                                dsClassInfo[dsType][0] = dsEntry.getValue();
                                dsClassInfo[dsType][1] = libraryPid;
                            }
                        }
                    }
                    if (className == null || type == null) continue;
                    driverProps.put("libraryRef", new String[]{libraryPid});
                    driverProps.put("sharedLib.target", FilterUtils.createPropertyFilter((String)"service.pid", (String)libraryPid));
                    driverProps.put(type, className);
                    dsSvcProps.put("type", type);
                    if (trace && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"updateWithLibraries", driverProps);
                    }
                    String string = className;
                    return string;
                }
                catch (ClassNotFoundException x) {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(className + " not found in"), (Object[])new Object[]{libraryPid});
                    }
                    searchedLibraryFiles.addAll(JDBCDriverService.getAbsolutePaths(library));
                }
                catch (Exception x) {
                    FFDCFilter.processException((Throwable)x, (String)DataSourceResourceFactoryBuilder.class.getName(), (String)"444", (Object[])new Object[]{libraryRef});
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)libraryRef.toString(), (Object[])new Object[]{x});
                    }
                    searchedLibraryFiles.addAll(JDBCDriverService.getAbsolutePaths(library));
                }
            }
            finally {
                bundleContext.ungetService(libraryRef);
            }
        }
        for (Object dsType : (Object)new int[]{2, 1, 0}) {
            if (dsClassInfo[dsType][0] == null) continue;
            String type = dsType == 2 ? XADataSource.class.getName() : (dsType == true ? ConnectionPoolDataSource.class.getName() : DataSource.class.getName());
            driverProps.put("libraryRef", new String[]{dsClassInfo[dsType][1]});
            driverProps.put("sharedLib.target", FilterUtils.createPropertyFilter((String)"service.pid", (String)dsClassInfo[dsType][1]));
            driverProps.put(type, dsClassInfo[dsType][0]);
            dsSvcProps.put("type", type);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updateWithLibraries", driverProps);
            }
            return dsClassInfo[dsType][0];
        }
        if (searchedPackages == null) {
            message = ConnectorService.getMessage((String)"MISSING_LIBRARY_J2CA8022", (Object[])new Object[]{declaringApplication, className, "dataSource", dsSvcProps.get("jndiName")});
        } else {
            ArrayList<String> types;
            ArrayList<String> arrayList = types = dsTypeSearchOrder == null ? Collections.singletonList("java.sql.Driver") : new ArrayList<String>(dsTypeSearchOrder.length);
            if (dsTypeSearchOrder != null) {
                block21: for (int dsType : dsTypeSearchOrder) {
                    switch (dsType) {
                        case 0: {
                            types.add("javax.sql.DataSource");
                            continue block21;
                        }
                        case 1: {
                            types.add("javax.sql.ConnectionPoolDataSource");
                            continue block21;
                        }
                        case 2: {
                            types.add("javax.sql.XADataSource");
                        }
                    }
                }
            }
            message = AdapterUtil.getNLSMessage("DSRA4001.no.suitable.driver.nested", types, dsSvcProps.get("jndiName"), searchedLibraryFiles, searchedPackages);
        }
        SQLNonTransientException x = new SQLNonTransientException(message);
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateWithLibraries", (Object)x);
        }
        throw x;
    }
}

