/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.validator;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.FunctionInfo;
import org.apache.jasper.compiler.ELNode;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
class FVVisitor
extends ELNode.Visitor {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.validator.ELValidator";
    ValidateResult result;
    Element jspElement;
    HashMap prefixToUriMap;
    static final long serialVersionUID = 3522090619581112044L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    FVVisitor(Element jspElement, ValidateResult result, HashMap prefixToUriMap) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.translator.visitor.validator.FVVisitor", "<init>", new Object[]{jspElement, result, prefixToUriMap});
        }
        this.jspElement = jspElement;
        this.result = result;
        this.prefixToUriMap = prefixToUriMap;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jsp.translator.visitor.validator.FVVisitor", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void visit(ELNode.Function func) throws JspTranslationException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.translator.visitor.validator.FVVisitor", "visit", new Object[]{func});
        }
        String prefix = func.getPrefix();
        String function = func.getName();
        String uri = null;
        if (prefix != null && this.prefixToUriMap != null) {
            uri = (String)this.prefixToUriMap.get(prefix);
            if (uri == null) {
                uri = this.jspElement.getNamespaceURI();
            }
            if (uri == null) {
                if (prefix == null) {
                    throw new JspTranslationException("jsp.error.noFunctionPrefix " + function);
                }
                throw new JspTranslationException("jsp.error.attribute.invalidPrefix " + prefix);
            }
            TagLibraryInfoImpl taglib = this.result.getTagLibMap().get(uri);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "FVVisitor.visit", "uri= [" + uri + "]");
                logger.logp(Level.FINER, CLASS_NAME, "FVVisitor.visit", "taglib= [" + (Object)((Object)taglib) + "]");
            }
            if (taglib == null) {
                throw new JspTranslationException("jsp.error.el.function.not.found", new Object[]{function, uri});
            }
            FunctionInfo funcInfo = null;
            funcInfo = taglib.getFunction(function);
            if (funcInfo == null) {
                throw new JspTranslationException("jsp.error.el.function.not.found", new Object[]{function, uri});
            }
            func.setUri(uri);
            func.setFunctionInfo(funcInfo);
            this.processSignature(func);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jsp.translator.visitor.validator.FVVisitor", "visit");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void processSignature(ELNode.Function func) throws JspTranslationException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.translator.visitor.validator.FVVisitor", "processSignature", new Object[]{func});
        }
        func.setMethodName(this.getMethod(func));
        func.setParameters(this.getParameters(func));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jsp.translator.visitor.validator.FVVisitor", "processSignature");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getMethod(ELNode.Function func) throws JspTranslationException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.translator.visitor.validator.FVVisitor", "getMethod", new Object[]{func});
        }
        FunctionInfo funcInfo = func.getFunctionInfo();
        String signature = funcInfo.getFunctionSignature();
        int start = signature.indexOf(32);
        if (start < 0) {
            throw new JspTranslationException("jsp.error.tld.fn.invalid.signature " + func.getPrefix() + " " + func.getName());
        }
        int end = signature.indexOf(40);
        if (end < 0) {
            throw new JspTranslationException("jsp.error.tld.fn.invalid.signature.parenexpected " + func.getPrefix() + " " + func.getName());
        }
        String string = signature.substring(start + 1, end).trim();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.jsp.translator.visitor.validator.FVVisitor", "getMethod", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String[] getParameters(ELNode.Function func) throws JspTranslationException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jsp.translator.visitor.validator.FVVisitor", "getParameters", new Object[]{func});
        }
        FunctionInfo funcInfo = func.getFunctionInfo();
        String signature = funcInfo.getFunctionSignature();
        ArrayList<String> params = new ArrayList<String>();
        int start = signature.indexOf(40) + 1;
        boolean lastArg = false;
        while (true) {
            String arg;
            int p;
            if ((p = signature.indexOf(44, start)) < 0) {
                p = signature.indexOf(41, start);
                if (p < 0) {
                    throw new JspTranslationException("jsp.error.tld.fn.invalid.signature " + func.getPrefix() + " " + func.getName());
                }
                lastArg = true;
            }
            if (!"".equals(arg = signature.substring(start, p).trim())) {
                params.add(arg);
            }
            if (lastArg) break;
            start = p + 1;
        }
        String[] stringArray = params.toArray(new String[params.size()]);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stringArray = stringArray;
            logger.exiting("com.ibm.ws.jsp.translator.visitor.validator.FVVisitor", "getParameters", stringArray);
        }
        return stringArray;
    }
}

