/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.persistent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import java.util.Dictionary;
import java.util.concurrent.TimeUnit;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
class Config {
    private static final TraceComponent tc = Tr.register(Config.class, (String)"persistentExecutor", (String)"com.ibm.ws.concurrent.persistent.resources.CWWKCMessages");
    final boolean enableTaskExecution;
    final String id;
    final long initialPollDelay;
    final String jndiName;
    final long missedTaskThreshold;
    final boolean pollingCoordination;
    final long pollInterval;
    final Integer pollSize;
    final long retryInterval;
    final int retryLimit;
    final String xpathId;
    static final long serialVersionUID = 2212739075253747785L;

    Config(Dictionary<String, ?> properties) {
        this.jndiName = (String)properties.get("jndiName");
        this.enableTaskExecution = (Boolean)properties.get("enableTaskExecution");
        boolean ignoreMin = Boolean.parseBoolean((String)properties.get("ignore.minimum.for.test.use.only"));
        this.initialPollDelay = (Long)properties.get("initialPollDelay");
        this.missedTaskThreshold = (Long)properties.get("missedTaskThreshold");
        Long pollIntrvl = this.enableTaskExecution ? (Long)properties.get("pollInterval") : null;
        boolean pollCoordination = Boolean.parseBoolean((String)properties.get("pollingCoordination.for.test.use.only"));
        this.pollingCoordination = this.enableTaskExecution && this.missedTaskThreshold > 0L && (pollIntrvl == null || pollCoordination);
        this.pollSize = this.enableTaskExecution ? (Integer)properties.get("pollSize") : null;
        Long retryIntrvl = (Long)properties.get("retryInterval");
        this.retryLimit = ((Short)properties.get("retryLimit")).shortValue();
        this.xpathId = (String)properties.get("config.displayId");
        this.id = this.xpathId.contains("]/persistentExecutor[") ? null : (String)properties.get("id");
        boolean pollIntervalDefaulted = false;
        if (pollIntrvl == null) {
            if (this.enableTaskExecution && this.missedTaskThreshold > 0L) {
                pollIntrvl = TimeUnit.SECONDS.toMillis(59L);
                pollIntervalDefaulted = true;
            } else {
                pollIntrvl = -1L;
            }
        }
        this.pollInterval = pollIntrvl;
        this.retryInterval = retryIntrvl == null ? (this.missedTaskThreshold > 0L ? -1L : TimeUnit.MINUTES.toMillis(1L)) : retryIntrvl;
        if (this.missedTaskThreshold != -1L && !ignoreMin && this.missedTaskThreshold < 100L || this.missedTaskThreshold > 9000L) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1520.out.of.range", (Object[])new Object[]{this.toString(this.missedTaskThreshold, TimeUnit.SECONDS), "missedTaskThreshold", "100s", "2h30m"}));
        }
        if (this.initialPollDelay < -1L) {
            throw new IllegalArgumentException("initialPollDelay: " + this.initialPollDelay + "ms");
        }
        if (this.pollInterval < -1L || this.missedTaskThreshold > 0L && !pollIntervalDefaulted && (!ignoreMin && this.pollInterval < 100000L && this.pollInterval != -1L || this.pollInterval > 9000000L)) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1520.out.of.range", (Object[])new Object[]{this.toString(this.pollInterval, TimeUnit.MILLISECONDS), "pollInterval", "100s", "2h30m"}));
        }
        if (this.retryInterval < 0L && this.missedTaskThreshold == -1L) {
            throw new IllegalArgumentException("retryInterval: " + this.retryInterval + "ms");
        }
        if (!(this.retryInterval < 0L || this.missedTaskThreshold <= 0L || this.retryInterval == TimeUnit.SECONDS.toMillis(300L) && "defaultEJBPersistentTimerExecutor".equals(this.id))) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1521.not.compatible", (Object[])new Object[]{"retryInterval", "missedTaskThreshold"}));
        }
    }

    public String toString() {
        return new StringBuilder(300).append("instance=").append(Integer.toHexString(System.identityHashCode(this))).append(",id=").append(this.id).append(",jndiName=").append(this.jndiName).append(",enableTaskExecution=").append(this.enableTaskExecution).append(",initialPollDelay=").append(this.initialPollDelay).append("ms,missedTaskThreshold=").append(this.missedTaskThreshold).append("s,pollingCoordination=").append(this.pollingCoordination).append(",pollInterval=").append(this.pollInterval).append("ms,pollSize=").append(this.pollSize).append(",retryInterval=").append(this.retryInterval).append("ms,retryLimit=").append(this.retryLimit).append(",xpathId=").append(this.xpathId).toString();
    }

    private String toString(long duration, TimeUnit unit) {
        long h;
        long m;
        long s;
        if (TimeUnit.MILLISECONDS.equals((Object)unit) && (s = duration / 1000L) * 1000L == duration) {
            duration = s;
            unit = TimeUnit.SECONDS;
        }
        if (TimeUnit.SECONDS.equals((Object)unit) && (m = duration / 60L) * 60L == duration) {
            duration = m;
            unit = TimeUnit.MINUTES;
        }
        if (TimeUnit.MINUTES.equals((Object)unit) && (h = duration / 60L) * 60L == duration) {
            duration = h;
            unit = TimeUnit.HOURS;
        }
        return duration + (unit == TimeUnit.MILLISECONDS ? "ms" : (unit == TimeUnit.SECONDS ? "s" : (unit == TimeUnit.MINUTES ? "m" : (unit == TimeUnit.HOURS ? "h" : "d"))));
    }
}

