/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OBPortableServer;

import java.util.Hashtable;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.Delegate;
import org.apache.yoko.orb.OB.BootManager_impl;
import org.apache.yoko.orb.OB.CollocatedServer;
import org.apache.yoko.orb.OB.InitialServiceManager;
import org.apache.yoko.orb.OB.LocationForward;
import org.apache.yoko.orb.OB.OAInterface;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.ObjectKey;
import org.apache.yoko.orb.OB.ObjectKeyData;
import org.apache.yoko.orb.OB.PIManager;
import org.apache.yoko.orb.OB.RefCountPolicyList;
import org.apache.yoko.orb.OB.ServerManager;
import org.apache.yoko.orb.OBPortableServer.CommunicationsConcurrencyPolicy;
import org.apache.yoko.orb.OBPortableServer.CommunicationsConcurrencyPolicyHelper;
import org.apache.yoko.orb.OBPortableServer.DirectServant;
import org.apache.yoko.orb.OBPortableServer.GIOPVersionPolicy;
import org.apache.yoko.orb.OBPortableServer.GIOPVersionPolicyHelper;
import org.apache.yoko.orb.OBPortableServer.POALocator;
import org.apache.yoko.orb.OBPortableServer.POAManager;
import org.apache.yoko.orb.OBPortableServer.POANameHasher;
import org.apache.yoko.orb.OBPortableServer.POAOAInterface_impl;
import org.apache.yoko.orb.OBPortableServer.POA_impl;
import org.apache.yoko.orb.OCI.Acceptor;
import org.apache.yoko.orb.PortableServer.PoaCurrentImpl;
import org.apache.yoko.util.Assert;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.GIOP.Version;
import org.omg.IOP.IOR;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;

public final class POAManager_impl
extends LocalObject
implements POAManager {
    static final Logger logger = Logger.getLogger(POAManager_impl.class.getName());
    private final ORBInstance orbInstance;
    private final Hashtable<POANameHasher, POA> poas;
    private volatile State state;
    private Acceptor[] acceptors;
    private final ServerManager serverManager;
    private final String id;
    String adapterManagerId;
    private final OAInterface oaInterface;
    private final Version giopVersion = new Version();
    private final BootManager_impl bootManager;
    private final POALocator poaLocator;
    private final String serverId;

    private boolean isInORBUpcall() {
        try {
            InitialServiceManager ism = this.orbInstance.getInitialServiceManager();
            PoaCurrentImpl current = (PoaCurrentImpl)ism.resolveInitialReferences("POACurrent");
            if (current._OB_inUpcall()) {
                return ((POA_impl)current.get_POA())._OB_ORBInstance() == this.orbInstance;
            }
        }
        catch (ClassCastException | InvalidName | NoContext throwable) {
            // empty catch block
        }
        return false;
    }

    private void waitPendingRequests() {
        this.poas.values().stream().map(POA_impl.class::cast).forEach(POA_impl::_OB_waitPendingRequests);
    }

    private void etherealizePOAs() {
        try {
            InitialServiceManager initialServiceManager = this.orbInstance.getInitialServiceManager();
            POA_impl rootPOA = (POA_impl)initialServiceManager.resolveInitialReferences("RootPOA");
            rootPOA._OB_etherealize(this);
        }
        catch (InvalidName invalidName) {
            // empty catch block
        }
    }

    public synchronized void activate() throws AdapterInactive {
        logger.fine("Activating POAManager " + this.id + " current state is " + this.state);
        switch (this.state.value()) {
            case 3: {
                throw new AdapterInactive();
            }
            case 1: {
                logger.fine("POAManager already active, returning");
                return;
            }
        }
        this.state = State.ACTIVE;
        this.notifyAll();
        this.serverManager.activate();
        this.oaInterface.activate();
        PIManager piManager = this.orbInstance.getPIManager();
        piManager.adapterManagerStateChange(this.adapterManagerId, this._OB_getAdapterState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hold_requests(boolean waitCompletion) throws AdapterInactive {
        POAManager_impl pOAManager_impl = this;
        synchronized (pOAManager_impl) {
            switch (this.state.value()) {
                case 3: {
                    throw new AdapterInactive();
                }
                case 0: {
                    return;
                }
            }
            if (waitCompletion && this.isInORBUpcall()) {
                throw new BAD_INV_ORDER("Invocation in progress", 0, CompletionStatus.COMPLETED_NO);
            }
            this.state = State.HOLDING;
            this.notifyAll();
            this.serverManager.hold();
            this.oaInterface.activate();
            PIManager piManager = this.orbInstance.getPIManager();
            piManager.adapterManagerStateChange(this.adapterManagerId, this._OB_getAdapterState());
        }
        if (waitCompletion) {
            this.waitPendingRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard_requests(boolean waitCompletion) throws AdapterInactive {
        POAManager_impl pOAManager_impl = this;
        synchronized (pOAManager_impl) {
            switch (this.state.value()) {
                case 3: {
                    throw new AdapterInactive();
                }
                case 2: {
                    return;
                }
            }
            if (waitCompletion && this.isInORBUpcall()) {
                throw new BAD_INV_ORDER("Invocation in progress", 0, CompletionStatus.COMPLETED_NO);
            }
            this.state = State.DISCARDING;
            this.notifyAll();
            this.oaInterface.discard();
            this.serverManager.activate();
            PIManager piManager = this.orbInstance.getPIManager();
            piManager.adapterManagerStateChange(this.adapterManagerId, this._OB_getAdapterState());
        }
        if (waitCompletion) {
            this.waitPendingRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(boolean etherealize, boolean waitCompletion) throws AdapterInactive {
        POAManager_impl pOAManager_impl = this;
        synchronized (pOAManager_impl) {
            if (this.state.value() == 3) {
                return;
            }
            if (waitCompletion && this.isInORBUpcall()) {
                throw new BAD_INV_ORDER("Invocation in progress", 0, CompletionStatus.COMPLETED_NO);
            }
            this.serverManager.destroy();
            this.acceptors = null;
            this.state = State.INACTIVE;
            this.notifyAll();
            PIManager piManager = this.orbInstance.getPIManager();
            piManager.adapterManagerStateChange(this.adapterManagerId, this._OB_getAdapterState());
        }
        if (waitCompletion) {
            this.waitPendingRequests();
        }
        if (etherealize) {
            this.etherealizePOAs();
        }
    }

    public State get_state() {
        return this.state;
    }

    public String get_id() {
        return this.id;
    }

    @Override
    public synchronized Acceptor[] get_acceptors() throws AdapterInactive {
        if (this.state.value() == 3) {
            throw new AdapterInactive();
        }
        Acceptor[] result = new Acceptor[this.acceptors.length];
        System.arraycopy(this.acceptors, 0, result, 0, this.acceptors.length);
        return result;
    }

    POAManager_impl(ORBInstance orbInstance, POALocator poaLocator, String id, String adapterManagerId, Acceptor[] acceptors, Policy[] policies) throws PolicyError {
        int concModel;
        this.orbInstance = orbInstance;
        this.poas = new Hashtable(63);
        this.state = State.HOLDING;
        this.acceptors = acceptors;
        this.id = id;
        this.adapterManagerId = adapterManagerId;
        this.poaLocator = poaLocator;
        this.serverId = Optional.of(orbInstance.getServerId()).filter(s -> !s.isEmpty()).orElse("_RootPOA");
        this.oaInterface = new POAOAInterface_impl(this, this.orbInstance);
        String rootKey = "yoko.orb.poamanager." + this.id + ".";
        Properties properties = orbInstance.getProperties();
        CommunicationsConcurrencyPolicy commsPolicy = null;
        GIOPVersionPolicy giopPolicy = null;
        block13: for (Policy policy : policies) {
            switch (policy.policy_type()) {
                case 1330577668: {
                    commsPolicy = CommunicationsConcurrencyPolicyHelper.narrow((Object)policy);
                    continue block13;
                }
                case 1330577670: {
                    giopPolicy = GIOPVersionPolicyHelper.narrow((Object)policy);
                    continue block13;
                }
                default: {
                    throw new PolicyError(2);
                }
            }
        }
        properties.keySet().stream().map(String.class::cast).forEach(key -> POAManager_impl.validateProp(rootKey, key));
        this.giopVersion.major = 1;
        this.giopVersion.minor = (byte)2;
        if (commsPolicy == null) {
            POAManager_impl.validateConcModel(properties, rootKey);
            concModel = 2;
        } else {
            switch (commsPolicy.value()) {
                case 0: {
                    concModel = 0;
                    break;
                }
                case 1: {
                    concModel = 2;
                    break;
                }
                default: {
                    throw new PolicyError(3);
                }
            }
        }
        if (giopPolicy == null) {
            POAManager_impl.extractGiopVersion(properties, rootKey, this.giopVersion);
        } else {
            switch (giopPolicy.value()) {
                case 0: {
                    this.giopVersion.major = 1;
                    this.giopVersion.minor = 0;
                    break;
                }
                case 1: {
                    this.giopVersion.major = 1;
                    this.giopVersion.minor = 1;
                    break;
                }
                case 2: {
                    this.giopVersion.major = 1;
                    this.giopVersion.minor = (byte)2;
                    break;
                }
                default: {
                    throw new PolicyError(3);
                }
            }
        }
        this.serverManager = new ServerManager(this.orbInstance, this.acceptors, this.oaInterface, concModel);
        this.bootManager = (BootManager_impl)orbInstance.getBootManager();
    }

    private static void validateConcModel(Properties properties, String rootKey) {
        String fullKey = rootKey + "conc_model";
        String value = properties.getProperty(fullKey);
        if (value == null && (value = properties.getProperty(fullKey = "yoko.orb.oa.conc_model")) == null) {
            return;
        }
        switch (value) {
            case "threaded": 
            case "thread_per_client": 
            case "thread_per_request": 
            case "thread_pool": {
                return;
            }
        }
        logger.warning(fullKey + ": unknown value");
    }

    private static void extractGiopVersion(Properties properties, String rootKey, Version giopVersion) {
        String fullKey = rootKey + "version";
        String value = properties.getProperty(fullKey);
        if (value == null && (value = properties.getProperty(fullKey = "yoko.orb.oa.version")) == null) {
            return;
        }
        switch (value) {
            case "1.0": {
                giopVersion.major = 1;
                giopVersion.minor = 0;
                return;
            }
            case "1.1": {
                giopVersion.major = 1;
                giopVersion.minor = 1;
                return;
            }
            case "1.2": {
                giopVersion.major = 1;
                giopVersion.minor = (byte)2;
                return;
            }
        }
        String err = fullKey + ": expected `1.0', `1.1' or `1.2'";
        logger.severe(err);
        throw new INITIALIZE(err);
    }

    private static void validateProp(String rootKey, String key) {
        String prop;
        if (key.equals("yoko.orb.oa.thread_pool")) {
            return;
        }
        if (key.startsWith(rootKey)) {
            prop = key.substring(rootKey.length());
        } else if (key.startsWith("yoko.orb.oa.")) {
            prop = key.substring("yoko.orb.oa.".length());
        } else {
            return;
        }
        switch (prop) {
            case "conc_model": {
                return;
            }
            case "endpoint": {
                return;
            }
            case "version": {
                return;
            }
        }
        String err = key + ": unknown property";
        logger.warning(err);
    }

    synchronized void _OB_addPOA(POA poa, String[] id) {
        POANameHasher idKey = new POANameHasher(id);
        logger.fine("Adding new poa with id " + idKey);
        Assert.ensure((!this.poas.containsKey(idKey) ? 1 : 0) != 0);
        this.poas.put(idKey, poa);
        this.poaLocator.add(poa, id);
    }

    synchronized void _OB_removePOA(String[] id) {
        POANameHasher idKey = new POANameHasher(id);
        logger.fine("Removing poa with id " + idKey);
        Assert.ensure((boolean)this.poas.containsKey(idKey));
        this.poas.remove(idKey);
        this.poaLocator.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectServant _OB_getDirectServant(byte[] key, RefCountPolicyList policies) throws LocationForward, AdapterInactive {
        if (this.state.value() == 3) {
            throw new AdapterInactive();
        }
        ObjectKeyData data = new ObjectKeyData();
        if (ObjectKey.ParseObjectKey(key, data)) {
            POA poa;
            POAManager_impl pOAManager_impl = this;
            synchronized (pOAManager_impl) {
                poa = this._OB_locatePOA(data);
            }
            if (poa != null) {
                return ((POA_impl)poa)._OB_getDirectServant(data.oid, policies);
            }
        }
        POAManager_impl pOAManager_impl = this;
        synchronized (pOAManager_impl) {
            IOR ior = this.bootManager._OB_locate(key);
            if (ior != null) {
                throw new LocationForward(ior, false);
            }
        }
        throw new OBJECT_NOT_EXIST("No POA for local servant");
    }

    POA _OB_locatePOA(ObjectKeyData data) throws LocationForward {
        POA_impl poaImpl;
        Assert.ensure((this.get_state() != State.INACTIVE ? 1 : 0) != 0);
        logger.fine("Searching for direct servant with key " + data);
        if (!data.serverId.equals(this.serverId)) {
            return null;
        }
        POANameHasher key = new POANameHasher(data.poaId);
        logger.fine("Searching for direct servant with poa key " + key);
        POA poa = this.poas.get(key);
        if (poa == null && (poa = this.poaLocator.locate(data)) != null) {
            logger.fine("Attempting to obtain a local reference to an object activated on a different POA");
            org.omg.PortableServer.POAManager manager = poa.the_POAManager();
            if (manager != this) {
                Object obj = poa.create_reference_with_id(data.oid, "");
                Delegate p = (Delegate)((ObjectImpl)obj)._get_delegate();
                IOR ior = p._OB_IOR();
                throw new LocationForward(ior, false);
            }
        }
        if (poa != null && !(poaImpl = (POA_impl)poa)._OB_poaMatches(data, false)) {
            logger.fine("POA located but object key data doesn't match");
            poa = null;
        }
        return poa;
    }

    public CollocatedServer _OB_getCollocatedServer() {
        return this.serverManager.getCollocatedServer();
    }

    public synchronized void _OB_validateState() {
        while (true) {
            switch (this.state.value()) {
                case 1: {
                    return;
                }
                case 2: 
                case 3: {
                    throw new TRANSIENT("POAManager is inactive or discarding requests", 0, CompletionStatus.COMPLETED_NO);
                }
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    Version _OB_getGIOPVersion() {
        return new Version(this.giopVersion.major, this.giopVersion.minor);
    }

    String _OB_getAdapterManagerId() {
        return this.adapterManagerId;
    }

    short _OB_getAdapterState() {
        switch (this.state.value()) {
            case 3: {
                return 3;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        throw Assert.fail();
    }

    public Acceptor[] _OB_getAcceptors() {
        Acceptor[] result = new Acceptor[this.acceptors.length];
        System.arraycopy(this.acceptors, 0, result, 0, this.acceptors.length);
        return result;
    }

    public ServerManager _OB_getServerManager() {
        return this.serverManager;
    }

    public OAInterface _OB_getOAInterface() {
        return this.oaInterface;
    }
}

