/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.client;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.ClientConnection;
import com.ibm.ws.sib.mfp.trm.TrmClientBootstrapRequest;
import com.ibm.ws.sib.mfp.trm.TrmFirstContactMessageType;
import com.ibm.ws.sib.mfp.trm.TrmMessageFactory;
import com.ibm.ws.sib.trm.client.ClientAttachProperties;
import com.ibm.ws.sib.trm.client.ClientHandler;
import com.ibm.ws.sib.trm.client.CredentialType;
import com.ibm.ws.sib.trm.client.Utils;
import com.ibm.ws.sib.utils.ras.SibTr;

class ClientBootstrapHandler
extends ClientHandler {
    public static final String $sccsid = "@(#) 1.46 SIB/ws/code/sib.trm.client.impl/src/com/ibm/ws/sib/trm/client/ClientBootstrapHandler.java, SIB.trm, WASX.SIB, aa1225.01 08/02/25 21:39:04 [7/2/12 05:58:42]";
    private static final String className = ClientBootstrapHandler.class.getName();
    private static final TraceComponent tc = SibTr.register(ClientBootstrapHandler.class, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.trm.CWSITMessages");
    private String bootstrapTransportChain;

    public ClientBootstrapHandler(ClientAttachProperties cap, CredentialType credentialType, String bootstrapTransportChain) {
        super(cap, credentialType);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ClientBootstrapHandler", (Object)new Object[]{cap, credentialType, bootstrapTransportChain});
        }
        this.bootstrapTransportChain = bootstrapTransportChain;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ClientBootstrapHandler", (Object)this);
        }
    }

    @Override
    public boolean connect(ClientConnection cc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"connect", (Object)new Object[]{cc});
        }
        boolean rc = true;
        try {
            TrmMessageFactory mf = TrmMessageFactory.getInstance();
            TrmClientBootstrapRequest cbr = mf.createNewTrmClientBootstrapRequest();
            cbr.setBusName(this.cap.getBusName());
            cbr.setCredentialType(this.credentialType.getCredentialType());
            cbr.setUserid(this.credentialType.getUserid());
            cbr.setPassword(this.credentialType.getPassword());
            cbr.setTargetGroupName(this.cap.getTargetGroupName());
            cbr.setTargetGroupType(this.cap.getTargetGroupType());
            cbr.setTargetSignificance(this.cap.getTargetSignificance());
            cbr.setConnectionProximity(this.cap.getConnectionProximity());
            cbr.setTargetTransportChain(this.cap.getTargetTransportChain());
            cbr.setBootstrapTransportChain(this.bootstrapTransportChain);
            cbr.setConnectionMode(this.cap.getConnectionMode());
            byte[] out = cbr.encode(cc);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)Utils.outBound("client bootstrap request"));
            }
            byte[] in = cc.trmHandshakeExchange(out);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)Utils.inBound("client bootstrap reply"));
            }
            this.fcm = mf.createInboundTrmFirstContactMessage(in, 0, in.length);
            if (this.fcm.getMessageType() != TrmFirstContactMessageType.CLIENT_BOOTSTRAP_REPLY) {
                Object[] objs = new Object[]{this.cap.getBusName(), this.fcm.getMessageType().toString(), TrmFirstContactMessageType.CLIENT_BOOTSTRAP_REPLY.toString()};
                SibTr.error((TraceComponent)tc, (String)"PROTOCOL_ERROR_CWSIT0038", (Object)objs);
                this.setException(new SIErrorException(nls.getFormattedMessage("PROTOCOL_ERROR_CWSIT0038", objs, null)));
                SibTr.exception((TraceComponent)tc, (Exception)this.getException());
                rc = false;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)(className + ".connect"), (String)"1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            this.setException(e);
            rc = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"connect", (Object)rc);
        }
        return rc;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source Info: @(#) 1.46 SIB/ws/code/sib.trm.client.impl/src/com/ibm/ws/sib/trm/client/ClientBootstrapHandler.java, SIB.trm, WASX.SIB, aa1225.01 08/02/25 21:39:04 [7/2/12 05:58:42]");
        }
    }
}

