/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.control;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.IntAble;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public enum ControlMessageType implements IntAble
{
    UNKNOWN(0, false),
    ACKEXPECTED(1, false),
    SILENCE(2, false),
    ACK(3, false),
    NACK(4, false),
    PREVALUE(5, false),
    ACCEPT(6, false),
    REJECT(7, false),
    DECISION(8, false),
    REQUEST(9),
    REQUESTACK(10),
    REQUESTHIGHESTGENERATEDTICK(11),
    HIGHESTGENERATEDTICK(12),
    RESETREQUESTACK(13),
    RESETREQUESTACKACK(14),
    BROWSEGET(15),
    BROWSEEND(16),
    BROWSESTATUS(17),
    COMPLETED(18),
    DECISIONEXPECTED(19),
    CREATESTREAM(20),
    AREYOUFLUSHED(21),
    FLUSHED(22),
    NOTFLUSHED(23),
    REQUESTFLUSH(24),
    REQUESTCARDINALITYINFO(25),
    CARDINALITYINFO(26),
    CREATEDURABLE(27),
    DELETEDURABLE(28),
    DURABLECONFIRM(29);

    private static final TraceComponent tc;
    private static final Map<Integer, ControlMessageType> types;
    private final Function<String, String> nameFormatter;
    private final Byte value;
    private final int intValue;

    private static String format(String name) {
        return String.format("%-27s", name);
    }

    private ControlMessageType(int aValue) {
        this(aValue, true);
    }

    private ControlMessageType(int aValue, boolean customFormatted) {
        this.nameFormatter = customFormatted ? ControlMessageType::format : s -> s;
        this.value = (byte)aValue;
        this.intValue = aValue;
    }

    public static final ControlMessageType getControlMessageType(Byte aValue) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Value = " + aValue));
        }
        return types.get(aValue.intValue());
    }

    public static final ControlMessageType getControlMessageType(int aValue) {
        return types.get(aValue);
    }

    public final Byte toByte() {
        return this.value;
    }

    @Override
    public final int toInt() {
        return this.intValue;
    }

    public final String toString() {
        return this.nameFormatter.apply(this.name());
    }

    static {
        tc = SibTr.register(ControlMessageType.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
        HashMap<Integer, ControlMessageType> map = new HashMap<Integer, ControlMessageType>();
        for (ControlMessageType type : ControlMessageType.values()) {
            map.put(type.toInt(), type);
        }
        types = Collections.unmodifiableMap(map);
    }
}

