/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.stats.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.request.probe.RequestProbeService;
import com.ibm.ws.request.timing.probeExtensionImpl.HungRequestProbeExtension;
import com.ibm.ws.request.timing.probeExtensionImpl.SlowRequestProbeExtension;
import com.ibm.ws.request.timing.stats.RequestTiming;
import com.ibm.wsspi.requestContext.RequestContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;

public class RequestTimingStatistics
implements RequestTiming {
    private static final TraceComponent tc = Tr.register(RequestTimingStatistics.class);
    private volatile SlowRequestProbeExtension slowRequestProbeExt = null;
    private volatile HungRequestProbeExtension hungRequestProbeExt = null;

    @Override
    public long getRequestCount(String type) {
        return this.hungRequestProbeExt.getTotalRequestCount(type);
    }

    @Override
    public long getActiveRequestCount(String type) {
        long activeRequestCounts = 0L;
        for (RequestContext requestcontext : RequestProbeService.getActiveRequests()) {
            if (!requestcontext.getRootEvent().getType().equals(type)) continue;
            ++activeRequestCounts;
        }
        return activeRequestCounts;
    }

    @Override
    public long getSlowRequestCount(String type) {
        return this.slowRequestProbeExt.getSlowRequestCount(type);
    }

    @Override
    public long getHungRequestCount(String type) {
        return this.hungRequestProbeExt.getHungRequestCount(type);
    }

    @Activate
    protected void activate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(" Deactivating " + this), (Object[])new Object[0]);
        }
    }

    protected void setHungRequestProbeExt(HungRequestProbeExtension probeExt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Setting probe extension : " + probeExt.getClass().getName()), (Object[])new Object[0]);
        }
        this.hungRequestProbeExt = probeExt;
    }

    protected void unsetHungRequestProbeExt(HungRequestProbeExtension probeExt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Unsetting probe extension : " + probeExt.getClass().getName()), (Object[])new Object[0]);
        }
        this.hungRequestProbeExt = null;
    }

    protected void setSlowRequestProbeExt(SlowRequestProbeExtension probeExt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Setting probe extension : " + probeExt.getClass().getName()), (Object[])new Object[0]);
        }
        this.slowRequestProbeExt = probeExt;
    }

    protected void unsetSlowRequestProbeExt(SlowRequestProbeExtension probeExt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Unsetting probe extension : " + probeExt.getClass().getName()), (Object[])new Object[0]);
        }
        this.slowRequestProbeExt = null;
    }
}

