/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.util;

import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.ws.crypto.util.UnsupportedConfigurationException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.wsspi.security.crypto.PasswordEncryptException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AesConfigFileParser {
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_NAME = "name";
    private static final String TAG_VARIABLE = "variable";

    public static Map<String, String> parseAesEncryptionFile(String aesConfigFilePath) throws PasswordEncryptException, UnsupportedConfigurationException, UnsupportedCryptoAlgorithmException {
        HashMap<String, String> props = new HashMap<String, String>();
        String base64Key = null;
        String passKey = null;
        if (ProductInfo.getBetaEdition()) {
            try {
                Map<String, String> encryptionVars = AesConfigFileParser.extractVariables(aesConfigFilePath);
                base64Key = encryptionVars.get("wlp.aes.encryption.key");
                passKey = encryptionVars.get("wlp.password.encryption.key");
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new PasswordEncryptException(e);
            }
        }
        if (base64Key == null && passKey == null) {
            throw new UnsupportedCryptoAlgorithmException();
        }
        if (base64Key != null && passKey != null) {
            throw new UnsupportedConfigurationException();
        }
        if (base64Key != null) {
            props.put("aes.key", base64Key);
        } else {
            props.put("crypto.key", passKey);
        }
        return props;
    }

    private static Map<String, String> extractVariables(String aesConfigFilePath) throws FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        Map<String, String> variables = AesConfigFileParser.isXmlFile(aesConfigFilePath) ? AesConfigFileParser.getXmlVariables(aesConfigFilePath) : AesConfigFileParser.getPropertyVariables(aesConfigFilePath);
        return variables;
    }

    private static Map<String, String> getPropertyVariables(String aesConfigFilePath) throws IOException {
        HashMap<String, String> variables = new HashMap<String, String>();
        Properties props = new Properties();
        try (FileInputStream fs = new FileInputStream(aesConfigFilePath);){
            props.load(fs);
            for (String name : props.stringPropertyNames()) {
                variables.put(name, props.getProperty(name));
            }
        }
        return variables;
    }

    private static Map<String, String> getXmlVariables(String aesConfigFilePath) throws SAXException, IOException, ParserConfigurationException {
        HashMap<String, String> variables = new HashMap<String, String>();
        DocumentBuilder docBuilder = AesConfigFileParser.getQuietDocBuilder();
        Document doc = docBuilder.parse(new File(aesConfigFilePath));
        Element element = doc.getDocumentElement();
        NodeList varList = element.getElementsByTagName(TAG_VARIABLE);
        for (int j = 0; j < varList.getLength(); ++j) {
            Node vl = varList.item(j);
            if (vl.getNodeType() != 1) continue;
            Element vlElement = (Element)vl;
            String varName = vlElement.getAttribute(ATTR_NAME);
            String varVal = vlElement.getAttribute(ATTR_VALUE).isEmpty() ? null : vlElement.getAttribute(ATTR_VALUE);
            variables.put(varName, varVal);
        }
        return variables;
    }

    private static DocumentBuilder getQuietDocBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbFactory.setXIncludeAware(false);
        dbFactory.setExpandEntityReferences(false);
        DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
        docBuilder.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
            }
        });
        return docBuilder;
    }

    private static boolean isXmlFile(String aesConfigFilePath) throws FileNotFoundException, ParserConfigurationException {
        boolean isXML;
        try {
            DocumentBuilder docBuilder = AesConfigFileParser.getQuietDocBuilder();
            docBuilder.parse(new File(aesConfigFilePath));
            isXML = true;
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException | SAXException e) {
            isXML = false;
        }
        catch (ParserConfigurationException e) {
            throw e;
        }
        return isXML;
    }
}

