/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.generator;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.feature.internal.generator.FeatureListException;
import com.ibm.ws.kernel.feature.internal.generator.FeatureListOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ArgumentProcessor {
    private static final String NLS_PROPS = "com.ibm.ws.config.internal.resources.ConfigMessages";
    private static final String NLS_OPTIONS = "com.ibm.ws.config.internal.resources.ConfigOptions";
    public static final ResourceBundle messages;
    public static final ResourceBundle options;
    private static final String JAR_NAME = "ws-featurelist.jar";
    private final FeatureListOptions flOptions = new FeatureListOptions();
    private final String[] args;
    static final long serialVersionUID = 4439336443678772789L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ArgumentProcessor(String[] args) {
        this.args = (String[])args.clone();
    }

    public FeatureListOptions getOptions() {
        for (int i = 0; i < this.args.length; ++i) {
            String arg = this.args[i];
            String argToLower = arg.toLowerCase();
            if (arg.startsWith("-")) {
                if (argToLower.contains("-help")) {
                    System.out.println(MessageFormat.format(options.getString("briefUsage"), JAR_NAME));
                    System.out.println();
                    this.showUsageInfo();
                    this.flOptions.setReturnCode(FeatureListOptions.ReturnCode.HELP_ACTION);
                    return this.flOptions;
                }
                if (argToLower.contains("-encoding")) {
                    this.flOptions.setEncoding(this.getArgumentValue(this.args[i]));
                    continue;
                }
                if (argToLower.contains("-locale")) {
                    this.flOptions.setLocale(new LocaleArgument(this.args[i]).getLocale());
                    continue;
                }
                if (argToLower.contains("-productextension")) {
                    this.flOptions.setProductName(this.getArgumentValue(this.args[i]));
                    continue;
                }
                System.out.println(MessageFormat.format(messages.getString("error.unknownArgument"), arg));
                System.out.println();
                this.flOptions.setReturnCode(FeatureListOptions.ReturnCode.BAD_ARGUMENT);
                continue;
            }
            if (this.flOptions.getOutputFile() != null) {
                System.out.println(MessageFormat.format(messages.getString("error.unknownArgument"), arg));
                this.flOptions.setReturnCode(FeatureListOptions.ReturnCode.BAD_ARGUMENT);
                continue;
            }
            this.flOptions.setOutputFile(arg);
            this.flOptions.setReturnCode(FeatureListOptions.ReturnCode.GENERATE_ACTION);
        }
        if (this.flOptions.getOutputFile() == null) {
            System.out.println(messages.getString("error.targetRequired"));
            this.flOptions.setReturnCode(FeatureListOptions.ReturnCode.BAD_ARGUMENT);
        }
        return this.flOptions;
    }

    private String getArgumentValue(String arg) {
        int idx = arg.lastIndexOf("=");
        if (idx < 1) {
            throw new FeatureListException(MessageFormat.format(messages.getString("error.invalidArgument"), arg));
        }
        return arg.substring(idx + 1);
    }

    private void showUsageInfo() {
        String[] optionKeys = new String[]{"option-key.encoding", "option-key.locale", "option-key.productExtension"};
        String okpfx = "option-key.";
        String odpfx = "option-desc.";
        System.out.println(options.getString("use.options"));
        System.out.println();
        for (String optionKey : optionKeys) {
            String option = optionKey.substring("option-key.".length());
            System.out.println(options.getString(optionKey));
            System.out.println(options.getString("option-desc." + option));
            System.out.println();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.generator.ArgumentProcessor", ArgumentProcessor.class, null, null);
        messages = ResourceBundle.getBundle(NLS_PROPS);
        options = ResourceBundle.getBundle(NLS_OPTIONS);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class LocaleArgument {
        private final Locale locale;
        static final long serialVersionUID = 7652717652331046212L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public LocaleArgument(String arg) {
            String localeVal = ArgumentProcessor.this.getArgumentValue(arg);
            if (localeVal != null) {
                int index = localeVal.indexOf(95);
                String lang = index == -1 ? localeVal : localeVal.substring(0, index);
                this.locale = index == -1 ? new Locale(lang) : new Locale(lang, localeVal.substring(index + 1));
            } else {
                this.locale = Locale.ROOT;
            }
        }

        public Locale getLocale() {
            return this.locale;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.generator.ArgumentProcessor$LocaleArgument", LocaleArgument.class, null, null);
        }
    }
}

