/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.validator;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.bean.BeanRepository;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl;
import com.ibm.ws.jsp.taglib.TagLibraryCache;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.utils.JspId;
import com.ibm.ws.jsp.translator.utils.JspTranslatorUtil;
import com.ibm.ws.jsp.translator.utils.TagFileId;
import com.ibm.ws.jsp.translator.visitor.JspVisitor;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.validator.ELValidator;
import com.ibm.ws.jsp.translator.visitor.validator.PageDataImpl;
import com.ibm.ws.jsp.translator.visitor.validator.TagCountResult;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateResult;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.el.lang.ELArithmetic;
import org.apache.el.lang.ELSupport;
import org.apache.jasper.compiler.ELNode;
import org.apache.jasper.compiler.ELParser;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public abstract class ValidateVisitor
extends JspVisitor {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.validator.ValidateVisitor";
    public static final String[] ATTR_STANDARD_ACTIONS = new String[]{"useBean", "setProperty", "getProperty", "include", "forward", "param", "plugin", "invoke", "doBody", "element", "output"};
    public static final String[] BODY_STANDARD_ACTIONS = new String[]{"useBean", "setProperty", "getProperty", "include", "forward", "param", "params", "plugin", "element", "output", "fallback"};
    private static final String[] includeAttrNames = new String[]{"page", "flush"};
    private static final String[] forwardAttrNames = new String[]{"page"};
    private static final String[] useBeanAttrNames = new String[]{"id", "scope", "class", "beanName", "type"};
    private static final String[] setPropertyAttrNames = new String[]{"name", "property", "param", "value"};
    private static final String[] getPropertyAttrNames = new String[]{"name", "property"};
    private static final String[] paramAttrNames = new String[]{"name", "value"};
    private static final String[] pluginAttrNames = new String[]{"type", "code", "codebase", "align", "archive", "height", "hspace", "jreversion", "name", "vspace", "title", "width", "nspluginurl", "iepluginurl", "mayscript"};
    private static final String[] attributeAttrNames = new String[]{"name", "trim"};
    private static final String[] attributeAttrNames21MR2 = new String[]{"name", "trim", "omit"};
    private static final String[] elementAttrNames = new String[]{"name"};
    private static final String[] outputAttrNames = new String[]{"omit-xml-declaration", "doctype-root-element", "doctype-system", "doctype-public"};
    private static final String[] includeRuntimeAttrNames = new String[]{"page"};
    private static final String[] forwardRuntimeAttrNames = new String[]{"page"};
    private static final String[] setPropertyRuntimeAttrNames = new String[]{"value"};
    private static final String[] useBeanRuntimeAttrNames = new String[]{"beanName"};
    private static final String[] pluginRuntimeAttrNames = new String[]{"height", "width"};
    private static final String[] paramRuntimeAttrNames = new String[]{"value"};
    private static final String[] includeRequiredAttrs = new String[]{"page"};
    private static final String[] forwardRequiredAttrs = new String[]{"page"};
    private static final String[] useBeanRequiredAttrsClass = new String[]{"class", "id"};
    private static final String[] useBeanRequiredAttrsType = new String[]{"type", "id"};
    private static final String[] setPropertyRequiredAttrs = new String[]{"name", "property"};
    private static final String[] getPropertyRequiredAttrs = new String[]{"name", "property"};
    private static final String[] paramAttrsRequiredAttrs = new String[]{"name", "value"};
    private static final String[] pluginAttrsRequiredAttrs = new String[]{"type", "code", "codebase"};
    private static final String[] attributeRequiredAttrs = new String[]{"name"};
    private static final String[] elementRequiredAttrs = new String[]{"name"};
    protected ValidateResult result;
    protected TagLibraryCache tagLibraryCache;
    protected Stack tagCountStack;
    private Vector dupVector;
    private HashMap<String, Integer> scriptVars;
    private HashMap<String, String> prefixToUriMap;
    protected String jspUri;
    protected TagCountResult tagCountResult;
    protected boolean dupFlag;
    protected JspOptions jspOptions;
    protected boolean evalQuotedAndEscapedExpression;
    static final long serialVersionUID = 5138154172656739216L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ValidateVisitor(JspVisitorUsage visitorUsage, JspConfiguration jspConfiguration, JspCoreContext context, HashMap resultMap, JspVisitorInputMap inputMap) throws JspCoreException {
        super(visitorUsage, jspConfiguration, context, resultMap, inputMap);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{visitorUsage, jspConfiguration, context, resultMap, inputMap});
        }
        this.result = null;
        this.tagLibraryCache = null;
        this.tagCountStack = new Stack();
        this.dupVector = new Vector();
        this.scriptVars = new HashMap();
        this.prefixToUriMap = new HashMap();
        this.jspUri = null;
        this.tagCountResult = null;
        this.dupFlag = false;
        this.jspOptions = null;
        this.evalQuotedAndEscapedExpression = false;
        this.tagLibraryCache = (TagLibraryCache)inputMap.get("TagLibraryCache");
        this.jspUri = (String)inputMap.get("JspUri");
        this.tagCountResult = (TagCountResult)resultMap.get("TagCount");
        this.jspOptions = (JspOptions)inputMap.get("JspOptions");
        this.evalQuotedAndEscapedExpression = this.jspOptions.isEvalQuotedAndEscapedExpression();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "ValidateVisitor", "evalQuotedAndEscapedExpression =[" + this.evalQuotedAndEscapedExpression + "]");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspVisitorResult getResult() throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getResult", new Object[0]);
        }
        List staticIncludeDependencies = (List)this.inputMap.get("StaticIncludeDependencyList");
        this.result.getDependencyList().addAll(staticIncludeDependencies);
        List tagFileDependencies = (List)this.inputMap.get("TagFileDependencies");
        for (TagFileId tagFileId : tagFileDependencies) {
            TagFileInfo tfi;
            TagLibraryInfoImpl tli = this.tagLibraryCache.getTagLibraryInfo(tagFileId.getUri(), tagFileId.getPrefix(), this.jspUri);
            if (tli.isContainer()) {
                tfi = tli.getTagFile(tagFileId.getTagName());
                this.result.getDependencyList().add(tfi.getPath());
                continue;
            }
            if (!tli.getInputSource().getAbsoluteURL().getProtocol().equals("file")) continue;
            tfi = tli.getTagFile(tagFileId.getTagName());
            this.result.getDependencyList().add(tfi.getPath());
        }
        this.getBeanRepository();
        ValidateResult validateResult = this.result;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            validateResult = validateResult;
            logger.exiting(CLASS_NAME, "getResult", validateResult);
        }
        return validateResult;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private BeanRepository getBeanRepository() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getBeanRepository", new Object[0]);
        }
        if (this.result.getBeanRepository() == null) {
            this.result.setBeanRepository(new BeanRepository(this.context.getJspClassloaderContext().getClassLoader()));
        }
        BeanRepository beanRepository = this.result.getBeanRepository();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            beanRepository = beanRepository;
            logger.exiting(CLASS_NAME, "getBeanRepository", beanRepository);
        }
        return beanRepository;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspParamsStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspParamsStart", new Object[]{jspElement});
        }
        Node parent = jspElement.getParentNode();
        if (parent.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
            if (!parent.getLocalName().equals("plugin") && !parent.getLocalName().equals("body")) {
                throw new JspTranslationException(jspElement, "jsp.params.invalid.parent");
            }
        } else {
            throw new JspTranslationException(jspElement, "jsp.params.invalid.parent");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspParamsStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspFallbackStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspFallbackStart", new Object[]{jspElement});
        }
        Node parent = jspElement.getParentNode();
        if (parent.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
            if (!parent.getLocalName().equals("plugin") && !parent.getLocalName().equals("body")) {
                throw new JspTranslationException(jspElement, "jsp.fallback.invalid.parent");
            }
        } else {
            throw new JspTranslationException(jspElement, "jsp.fallback.invalid.parent");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspFallbackStart");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspParamStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspParamStart", new Object[]{jspElement});
        }
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, paramAttrsRequiredAttrs);
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, paramAttrNames);
        ELValidator.validateRuntimeExpressions(jspElement, paramRuntimeAttrNames, Object.class, this.jspConfiguration, this.result, this.context, this.prefixToUriMap);
        this.validateEmptyBody(jspElement);
        Node parent = jspElement.getParentNode();
        String parentName = jspElement.getParentNode().getLocalName();
        if (!parent.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) throw new JspTranslationException(jspElement, "jsp.param.invalid.parent");
        if (!parentName.equals("include") && !parentName.equals("forward") && !parentName.equals("params") && !parentName.equals("body")) throw new JspTranslationException(jspElement, "jsp.param.invalid.parent");
        String name = this.getAttributeValue(jspElement, "name");
        if (name.equals("")) {
            throw new JspTranslationException(jspElement, "jsp.param.name.empty");
        }
        if (logger == null || !logger.isLoggable(Level.FINER)) return;
        logger.exiting(CLASS_NAME, "visitJspParamStart");
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitCustomTagStart(Element jspElement) throws JspCoreException {
        ValidationMessage[] validationMessages;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitCustomTagStart", new Object[]{jspElement});
        }
        ValidateVisitor.getAttributeList(jspElement);
        String uri = jspElement.getNamespaceURI();
        String prefix = jspElement.getPrefix();
        String tagName = jspElement.getLocalName();
        boolean isTagFile = false;
        if (uri.startsWith("urn:jsptld:")) {
            uri = uri.substring(uri.indexOf("urn:jsptld:") + 11);
        } else if (uri.startsWith("urn:jsptagdir:")) {
            uri = uri.substring(uri.indexOf("urn:jsptagdir:") + 14);
        }
        ValidateTagInfo vti = this.getTagInfo(jspElement, uri, prefix, tagName);
        if (vti == null) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting(CLASS_NAME, "visitCustomTagStart");
            }
            return;
        }
        TagInfo ti = vti.getTagInfo();
        isTagFile = vti.isTagFile();
        TagLibraryInfoImpl tli = vti.getTLI();
        ti.setTagLibrary((TagLibraryInfo)tli);
        TagAttributeInfo[] attributes = ti.getAttributes();
        this.validateCustomTagAttributes(jspElement, attributes);
        CustomTagInstance cti = this.validateCustomTagAttributeValues(jspElement, attributes, ti.hasDynamicAttributes(), tli);
        Hashtable attribs = cti.getAttributes();
        boolean isScriptless = cti.isScriptless();
        StringBuffer varNameSuffix = new StringBuffer();
        varNameSuffix.append(uri);
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i].isRequired() && !attribs.containsKey(attributes[i].getName())) {
                throw new JspTranslationException(jspElement, "jsp.error.missing.attribute", new Object[]{attributes[i].getName()});
            }
            if (attributes[i].isRequired() || !attribs.containsKey(attributes[i].getName())) continue;
            varNameSuffix.append("_" + attributes[i].getName());
        }
        if (JspTranslatorUtil.hasBody(jspElement) || JspTranslatorUtil.hasJspBody(jspElement)) {
            varNameSuffix.append("_jspxhasbody");
        }
        String tmpValueToBeHashed = varNameSuffix.toString();
        varNameSuffix = new StringBuffer("_" + tmpValueToBeHashed.hashCode());
        Enumeration e = attribs.keys();
        while (e.hasMoreElements()) {
            boolean found = false;
            String attr = (String)e.nextElement();
            for (int i = 0; i < attributes.length; ++i) {
                if (!attributes[i].getName().equals(attr)) continue;
                found = true;
                break;
            }
            if (found || ti.hasDynamicAttributes()) continue;
            throw new JspTranslationException(jspElement, "jsp.error.bad.attribute", new Object[]{attr});
        }
        TagData tagData = new TagData(attribs);
        if (!ti.isValid(tagData)) {
            throw new JspTranslationException(jspElement, "jsp.error.invalid.attributes");
        }
        TagExtraInfo tei = ti.getTagExtraInfo();
        if (tei != null) {
            tei.setTagInfo(ti);
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "visitCustomTagStart", "tei.getTagInfo().getTagLibrary().getTagLibraryInfos() =[" + tei.getTagInfo().getTagLibrary().getTagLibraryInfos() + "]");
            }
            if (tei.getVariableInfo(tagData) != null && tei.getVariableInfo(tagData).length > 0 && ti.getTagVariableInfos().length > 0) {
                throw new JspTranslationException(jspElement, "jsp.error.non_null_tei_and_var_subelems");
            }
        }
        if ((validationMessages = ti.validate(tagData)) != null && validationMessages.length > 0) {
            StringBuffer errMsg = new StringBuffer();
            for (int i = 0; i < validationMessages.length; ++i) {
                if (validationMessages[i] == null) continue;
                errMsg.append("<p>");
                errMsg.append(validationMessages[i].getId());
                errMsg.append(": ");
                errMsg.append(validationMessages[i].getMessage());
                errMsg.append("</p>");
            }
            throw new JspTranslationException(jspElement, "jsp.error.tei.invalid.attributes", new Object[]{uri, tagName, errMsg.toString()});
        }
        if (isScriptless) {
            isScriptless = this.areChildrenScriptless(jspElement);
        }
        TagVariableInfo[] tagVarInfos = ti.getTagVariableInfos();
        VariableInfo[] varInfos = ti.getVariableInfo(tagData);
        if (varInfos == null) {
            varInfos = new VariableInfo[]{};
        }
        boolean hasScriptingVars = varInfos.length > 0 || tagVarInfos.length > 0;
        Integer tagCount = (Integer)this.tagCountResult.getCountMap().get(jspElement);
        if (tagCount == null) {
            tagCount = 0;
        }
        Vector atBeginVars = this.setScriptingVars(tagVarInfos, varInfos, tagData, 1, tagCount);
        Vector nestedVars = this.setScriptingVars(tagVarInfos, varInfos, tagData, 0, tagCount);
        this.result.addCollectTagData(jspElement, isScriptless, hasScriptingVars, atBeginVars, null, nestedVars, tagData, varNameSuffix.toString());
        if (this.tagLibraryCache.getTagClassInfo(ti) == null && !isTagFile) {
            Class<?> tagClass = null;
            try {
                tagClass = this.context.getJspClassloaderContext().getClassLoader().loadClass(ti.getTagClassName());
                this.tagLibraryCache.addTagClassInfo(ti, tagClass);
            }
            catch (Exception ex) {
                throw new JspTranslationException(jspElement, "jsp.error.unable.loadclass", new Object[]{ti.getTagClassName()});
            }
        }
        this.tagCountStack.push(this.tagCountResult.getCountMap().get(jspElement));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitCustomTagStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitCustomTagEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitCustomTagEnd", new Object[]{jspElement});
        }
        ValidateResult.CollectedTagData collectedTagData = this.result.getCollectedTagData(jspElement);
        String uri = jspElement.getNamespaceURI();
        String prefix = jspElement.getPrefix();
        String tagName = jspElement.getLocalName();
        if (uri.startsWith("urn:jsptld:")) {
            uri = uri.substring(uri.indexOf("urn:jsptld:") + 11);
        } else if (uri.startsWith("urn:jsptagdir:")) {
            uri = uri.substring(uri.indexOf("urn:jsptagdir:") + 14);
        }
        TagLibraryInfoImpl tli = this.result.getTagLibMap().get(uri);
        if (tli != null) {
            this.tagCountStack.pop();
            TagInfo ti = tli.getTag(tagName);
            if (ti == null) {
                TagFileInfo tfi = tli.getTagFile(tagName);
                ti = tfi.getTagInfo();
            }
            TagVariableInfo[] tagVarInfos = ti.getTagVariableInfos();
            VariableInfo[] varInfos = ti.getVariableInfo(collectedTagData.getTagData());
            if (varInfos == null) {
                varInfos = new VariableInfo[]{};
            }
            Integer tagCount = (Integer)this.tagCountResult.getCountMap().get(jspElement);
            Vector atEndVars = this.setScriptingVars(tagVarInfos, varInfos, collectedTagData.getTagData(), 2, tagCount == null ? 0 : tagCount);
            if (this.dupFlag) {
                Vector dupVector = this.getDuplicateVars();
                collectedTagData.setAtEndDuplicateVars(dupVector);
                this.dupFlag = false;
            }
            collectedTagData.setAtEndScriptingVars(atEndVars);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitCustomTagEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspRootStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspRootStart", new Object[]{jspElement});
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitJspRootStart", "enter visitJspRootStart() =[" + jspElement.getNodeValue() + "]");
        }
        if (jspElement.getParentNode().getNodeType() != 9) {
            throw new JspTranslationException(jspElement, "jsp.error.root.must.be.top");
        }
        NamedNodeMap attributes = jspElement.getAttributes();
        if (attributes != null) {
            if (!jspElement.hasAttribute("version")) {
                throw new JspTranslationException(jspElement, "jsp.error.root.invalid.version", new Object[]{"none found"});
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                if (attribute.getNodeName().startsWith("xmlns:")) {
                    String prefix = attribute.getNodeName();
                    prefix = prefix.substring(prefix.indexOf(":") + 1);
                    String uri = attribute.getNodeValue();
                    if (uri.startsWith("urn:jsptld:")) {
                        uri = uri.substring(uri.indexOf("urn:jsptld:") + 11);
                    } else if (uri.startsWith("urn:jsptagdir:")) {
                        uri = uri.substring(uri.indexOf("urn:jsptagdir:") + 14);
                    }
                    if (uri.equals("http://java.sun.com/JSP/Page") || uri.equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
                    TagLibraryInfoImpl tli = this.tagLibraryCache.getTagLibraryInfo(uri, prefix, this.jspUri);
                    if (tli != null) {
                        if (tli.getInputSource() instanceof JspInputSourceContainerImpl) {
                            if (!this.tagLibraryCache.getImplicitTagLibPrefixMap().containsValue(uri)) {
                                this.result.getDependencyList().add(tli.getTldFilePath());
                            }
                        } else if (tli.getTldFilePath() != null && tli.getInputSource().getAbsoluteURL().getProtocol().equals("file") && !this.tagLibraryCache.getImplicitTagLibPrefixMap().containsValue(uri)) {
                            this.result.getDependencyList().add(tli.getTldFilePath());
                        }
                        if (this.result.getTagLibMap().containsKey(uri)) continue;
                        this.result.getTagLibMap().put(uri, tli);
                        tli.setTagLibMap(this.result.getTagLibMap());
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "visitJspRootStart", "getTagLibraryInfos() =[" + tli.getTagLibraryInfos() + "]");
                        }
                        this.prefixToUriMap.put(prefix, uri);
                        this.validateTagLib(jspElement.getOwnerDocument(), uri, prefix, tli);
                        continue;
                    }
                    if (this.jspConfiguration.isXml()) continue;
                    throw new JspTranslationException(jspElement, "jsp.error.tld.not.found", new Object[]{uri, prefix});
                }
                if (!attribute.getNodeName().equals("version") || attribute.getNodeValue().equals("1.2") || attribute.getNodeValue().equals("2.0") || attribute.getNodeValue().equals("2.1")) continue;
                throw new JspTranslationException(jspElement, "jsp.error.root.invalid.version", new Object[]{attribute.getNodeValue()});
            }
        } else {
            throw new JspTranslationException(jspElement, "jsp.root.has.no.attributes");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspRootStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspUseBeanStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspUseBeanStart", new Object[]{jspElement});
        }
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement);
        try {
            this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, useBeanRequiredAttrsClass);
        }
        catch (JspCoreException jce) {
            this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, useBeanRequiredAttrsType);
        }
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, useBeanAttrNames);
        ELValidator.validateRuntimeExpressions(jspElement, useBeanRuntimeAttrNames, String.class, this.jspConfiguration, this.result, this.context, this.prefixToUriMap);
        String nameAttrValue = this.getAttributeValue(jspElement, "id");
        String scopeAttrValue = this.getAttributeValue(jspElement, "scope");
        String classAttrValue = this.getAttributeValue(jspElement, "class");
        String typeAttrValue = this.getAttributeValue(jspElement, "type");
        String beanNameAttrValue = this.getAttributeValue(jspElement, "beanName");
        if (nameAttrValue.equals("")) {
            throw new JspTranslationException(jspElement, "jsp.error.usebean.missing.attribute");
        }
        if (classAttrValue.equals("") && typeAttrValue.equals("")) {
            throw new JspTranslationException(jspElement, "jsp.error.usebean.missing.type");
        }
        if (this.getBeanRepository().checkVariable(nameAttrValue)) {
            throw new JspTranslationException(jspElement, "jsp.error.usebean.duplicate", new Object[]{nameAttrValue});
        }
        if (!classAttrValue.equals("") && !beanNameAttrValue.equals("")) {
            throw new JspTranslationException(jspElement, "jsp.error.usebean.not.both", new Object[]{classAttrValue, beanNameAttrValue});
        }
        if (!classAttrValue.equals("") && !typeAttrValue.equals("")) {
            try {
                Class<?> classAttrClass = Class.forName(classAttrValue, true, this.context.getJspClassloaderContext().getClassLoader());
                Class<?> typeAttrClass = Class.forName(typeAttrValue, true, this.context.getJspClassloaderContext().getClassLoader());
                if (!typeAttrClass.isAssignableFrom(classAttrClass)) {
                    throw new JspTranslationException(jspElement, "jsp.error.usebean.class.must.be.assignable.to.type", new Object[]{classAttrValue, typeAttrValue, jspElement.getTagName()});
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new JspTranslationException(jspElement, "jsp.error.usebean.cannot.locate.class.to.validate.assignable", new Object[]{classAttrValue, typeAttrValue, jspElement.getTagName()}, cnfe);
            }
        }
        String clsname = null;
        clsname = classAttrValue != null && !classAttrValue.equals("") ? classAttrValue : typeAttrValue;
        if (scopeAttrValue.equals("") || scopeAttrValue.equals("page")) {
            this.getBeanRepository().addPageBean(nameAttrValue, clsname);
        } else if (scopeAttrValue.equals("request")) {
            this.getBeanRepository().addRequestBean(nameAttrValue, clsname);
        } else if (scopeAttrValue.equals("session")) {
            this.getBeanRepository().addSessionBean(nameAttrValue, clsname);
        } else if (scopeAttrValue.equals("application")) {
            this.getBeanRepository().addApplicationBean(nameAttrValue, clsname);
        } else {
            throw new JspTranslationException(jspElement, "jsp.error.usebean.invalid.scope", new Object[]{scopeAttrValue});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspUseBeanStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspExpressionStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspExpressionStart", new Object[]{jspElement});
        }
        Node n = jspElement.getFirstChild();
        if (n.getNodeType() == 4) {
            if (this.jspConfiguration.scriptingInvalid()) {
                throw new JspTranslationException(jspElement, "jsp.error.expressions.disabled.for.translation.unit");
            }
        } else {
            throw new JspTranslationException(jspElement, "jsp.error.expression.contains.no.cdata");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspExpressionStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspScriptletStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspScriptletStart", new Object[]{jspElement});
        }
        Node n = jspElement.getFirstChild();
        if (n.getNodeType() == 4) {
            if (this.jspConfiguration.scriptingInvalid()) {
                throw new JspTranslationException(jspElement, "jsp.error.scriptlets.disabled.for.translation.unit");
            }
        } else {
            throw new JspTranslationException(jspElement, "jsp.error.scriptlet.contains.no.cdata");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspScriptletStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspDeclarationStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspDeclarationStart", new Object[]{jspElement});
        }
        Node n = jspElement.getFirstChild();
        if (n.getNodeType() == 4) {
            if (this.jspConfiguration.scriptingInvalid()) {
                throw new JspTranslationException(jspElement, "jsp.error.declarations.disabled.for.translation.unit");
            }
        } else {
            throw new JspTranslationException(jspElement, "jsp.error.declaration.contains.no.cdata");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspDeclarationStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspTextStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspTextStart", new Object[]{jspElement});
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitJspTextStart", "jspElement =[" + jspElement + "]");
        }
        for (int i = 0; i < jspElement.getChildNodes().getLength(); ++i) {
            Node n = jspElement.getChildNodes().item(i);
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "visitJspTextStart", "Node n =[" + n + "]");
                logger.logp(Level.FINER, CLASS_NAME, "visitJspTextStart", "Node n TYPE =[" + n.getNodeType() + "]");
            }
            if (n.getNodeType() == 4) {
                CDATASection cdata = (CDATASection)n;
                this.visitJspELTextStart(jspElement, cdata.getData(), String.class);
                continue;
            }
            if (n.getNodeType() == 7) continue;
            throw new JspTranslationException(jspElement, "jsp.error.jsptext.has.child.elements");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspTextStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspIncludeStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspIncludeStart", new Object[]{jspElement});
        }
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, includeRequiredAttrs);
        String flushString = this.getAttributeValue(jspElement, "flush");
        if (!(flushString.equals("") || flushString.equalsIgnoreCase("false") || flushString.equalsIgnoreCase("true"))) {
            throw new JspTranslationException(jspElement, "jsp.error.include.flush.invalid.value", new Object[]{flushString});
        }
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, includeAttrNames);
        ELValidator.validateRuntimeExpressions(jspElement, includeRuntimeAttrNames, String.class, this.jspConfiguration, this.result, this.context, this.prefixToUriMap);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspIncludeStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspGetPropertyStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspGetPropertyStart", new Object[]{jspElement});
        }
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, getPropertyRequiredAttrs);
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, getPropertyAttrNames);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspGetPropertyStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspForwardStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspForwardStart", new Object[]{jspElement});
        }
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, forwardRequiredAttrs);
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, forwardAttrNames);
        ELValidator.validateRuntimeExpressions(jspElement, forwardRuntimeAttrNames, String.class, this.jspConfiguration, this.result, this.context, this.prefixToUriMap);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspForwardStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspPluginStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspPluginStart", new Object[]{jspElement});
        }
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, pluginAttrsRequiredAttrs);
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, pluginAttrNames);
        ELValidator.validateRuntimeExpressions(jspElement, pluginRuntimeAttrNames, String.class, this.jspConfiguration, this.result, this.context, this.prefixToUriMap);
        String typeValue = this.getAttributeValue(jspElement, "type");
        if (!typeValue.equals("applet") && !typeValue.equals("bean")) {
            throw new JspTranslationException(jspElement, "jsp.error.plugin.invalid.type", new Object[]{typeValue});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspPluginStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspSetPropertyStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspSetPropertyStart", new Object[]{jspElement});
        }
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, setPropertyRequiredAttrs);
        this.validateAttributes(specifiedStandardActionAttrs, jspElement, setPropertyAttrNames);
        ELValidator.validateRuntimeExpressions(jspElement, setPropertyRuntimeAttrNames, Object.class, this.jspConfiguration, this.result, this.context, this.prefixToUriMap);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspSetPropertyStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspAttributeStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspAttributeStart", new Object[]{jspElement});
        }
        Node parent = jspElement.getParentNode();
        if (parent.getNodeType() == 1) {
            String uri;
            Element parentElement = (Element)parent;
            String name = jspElement.getAttribute("name");
            String prefix = null;
            if (name.indexOf(58) != -1) {
                prefix = name.substring(0, name.indexOf(58));
                name = name.substring(name.indexOf(58) + 1);
            }
            if ((uri = this.prefixToUriMap.get(parentElement.getPrefix())) == null) {
                String actionName = parentElement.getLocalName();
                boolean validActionFound = false;
                for (int i = 0; i < ATTR_STANDARD_ACTIONS.length; ++i) {
                    if (!actionName.equals(ATTR_STANDARD_ACTIONS[i])) continue;
                    validActionFound = true;
                    break;
                }
                if (!validActionFound) {
                    throw new JspTranslationException(jspElement, "jsp.error.jsp.attribute.invalid.parent");
                }
                if (prefix != null && !parentElement.getLocalName().equals("element") && !parentElement.getPrefix().equals(prefix)) {
                    throw new JspTranslationException(jspElement, "jsp.error.jsp.attribute.prefix.mismatch", new Object[]{parentElement.getPrefix(), prefix});
                }
            } else if (prefix != null) {
                String tagName = parentElement.getLocalName();
                TagLibraryInfoImpl tli = this.result.getTagLibMap().get(uri);
                TagInfo ti = tli.getTag(tagName);
                if (!ti.hasDynamicAttributes() && !parentElement.getPrefix().equals(prefix)) {
                    throw new JspTranslationException(jspElement, "jsp.error.jsp.attribute.prefix.mismatch", new Object[]{parentElement.getPrefix(), prefix});
                }
            }
        } else {
            throw new JspTranslationException(jspElement, "jsp.error.jsp.attribute.invalid.parent");
        }
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, attributeRequiredAttrs);
        if (Float.valueOf(this.jspConfiguration.getJspVersion()).floatValue() >= JspConfiguration.twoPointOne.floatValue()) {
            this.validateAttributes(specifiedStandardActionAttrs, jspElement, attributeAttrNames21MR2);
        } else {
            this.validateAttributes(specifiedStandardActionAttrs, jspElement, attributeAttrNames);
        }
        NodeList childNodes = jspElement.getChildNodes();
        int numberChilds = childNodes.getLength();
        for (int i = 0; i < numberChilds; ++i) {
            Element childElement;
            Node currentNode = childNodes.item(i);
            if (currentNode.getNodeType() != 1 || (childElement = (Element)currentNode).getNamespaceURI() == null || !childElement.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !childElement.getLocalName().equals("attribute")) continue;
            throw new JspTranslationException(jspElement, "jsp.error.jsp.attribute.defined.value.jsp.attribute");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspAttributeStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspElementStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspElementStart", new Object[]{jspElement});
        }
        List specifiedStandardActionAttrs = ValidateVisitor.getAttributeList(jspElement, true);
        this.validateRequiredAttributes(jspElement, specifiedStandardActionAttrs, elementRequiredAttrs);
        this.validateAttributes(jspElement, elementAttrNames);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspElementStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspOutputStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspOutputStart", new Object[]{jspElement});
        }
        if (!this.jspConfiguration.isXml()) {
            throw new JspTranslationException(jspElement, "jsp.error.jspoutput.xml.only");
        }
        this.validateAttributes(jspElement, outputAttrNames);
        if (jspElement.hasChildNodes()) {
            throw new JspTranslationException(jspElement, "jsp.error.output.has.body");
        }
        Attr docTypeDeclElement = jspElement.getAttributeNode("omit-xml-declaration");
        Attr docTypeRootElement = jspElement.getAttributeNode("doctype-root-element");
        Attr docTypePublicElement = jspElement.getAttributeNode("doctype-public");
        Attr docTypeSystemElement = jspElement.getAttributeNode("doctype-system");
        if (docTypeSystemElement == null) {
            if (docTypeRootElement != null) {
                throw new JspTranslationException(jspElement, "jsp.error.no.doctype-system.attr");
            }
            if (docTypePublicElement != null) {
                throw new JspTranslationException(jspElement, "jsp.error.no.doctype-system.attr");
            }
        } else if (docTypeRootElement == null) {
            throw new JspTranslationException(jspElement, "jsp.error.no.doctype-root-element.attr");
        }
        boolean allowJspOutputElementMismatch = JspOptions.ALLOWJSPOUTPUTELEMENTMISMATCH;
        JspOptions jspOptions = (JspOptions)this.inputMap.get("JspOptions");
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitJspOutputStart", "jspOptions =[" + jspOptions + "]");
        }
        if (jspOptions != null) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "visitJspOutputStart", "jspOptions.isAllowJspOutputElementMismatch():  [" + jspOptions.isAllowJspOutputElementMismatch() + "]");
            }
            allowJspOutputElementMismatch = jspOptions.isAllowJspOutputElementMismatch();
        }
        if (!allowJspOutputElementMismatch) {
            String omitXmlDecl = null;
            if (docTypeDeclElement != null) {
                omitXmlDecl = docTypeDeclElement.getValue();
            }
            String doctypeRoot = null;
            if (docTypeRootElement != null) {
                doctypeRoot = docTypeRootElement.getValue();
            }
            String doctypePublic = null;
            if (docTypePublicElement != null) {
                doctypePublic = docTypePublicElement.getValue();
            }
            String doctypeSystem = null;
            if (docTypeSystemElement != null) {
                doctypeSystem = docTypeSystemElement.getValue();
            }
            String omitXmlDeclOld = this.result.getOmitXmlDecl();
            String doctypeRootOld = this.result.getDoctypeRoot();
            String doctypePublicOld = this.result.getDoctypePublic();
            String doctypeSystemOld = this.result.getDoctypeSystem();
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "visitJspOutputStart", "omitXmlDecl =[" + omitXmlDecl + "] omitXmlDeclOld =[" + omitXmlDeclOld + "]  ");
                logger.logp(Level.FINER, CLASS_NAME, "visitJspOutputStart", "doctypeRoot =[" + doctypeRoot + "] doctypeRootOld =[" + doctypeRootOld + "]  ");
                logger.logp(Level.FINER, CLASS_NAME, "visitJspOutputStart", "doctypePublic =[" + doctypePublic + "] doctypePublicOld =[" + doctypePublicOld + "]  ");
                logger.logp(Level.FINER, CLASS_NAME, "visitJspOutputStart", "doctypeSystem =[" + doctypeSystem + "] doctypeSystemOld =[" + doctypeSystemOld + "]  ");
            }
            if (omitXmlDecl != null && omitXmlDeclOld != null && !omitXmlDecl.equals(omitXmlDeclOld)) {
                throw new JspTranslationException(jspElement, "jsp.error.jspoutput.conflict", new Object[]{"omit-xml-declaration", omitXmlDeclOld, omitXmlDecl});
            }
            if (doctypeRoot != null && doctypeRootOld != null && !doctypeRoot.equals(doctypeRootOld)) {
                throw new JspTranslationException(jspElement, "jsp.error.jspoutput.conflict", new Object[]{"doctype-root-element", doctypeRootOld, doctypeRoot});
            }
            if (doctypePublic != null && doctypePublicOld != null && !doctypePublic.equals(doctypePublicOld)) {
                throw new JspTranslationException(jspElement, "jsp.error.jspoutput.conflict", new Object[]{"doctype-public", doctypePublicOld, doctypePublic});
            }
            if (doctypeSystem != null && doctypeSystemOld != null && !doctypeSystem.equals(doctypeSystemOld)) {
                throw new JspTranslationException(jspElement, "jsp.error.jspoutput.conflict", new Object[]{"doctype-system", doctypeSystemOld, doctypeSystem});
            }
            if (omitXmlDecl != null) {
                this.result.setOmitXmlDecl(omitXmlDecl);
            }
            if (doctypeRoot != null) {
                this.result.setDoctypeRoot(doctypeRoot);
            }
            if (doctypeSystem != null) {
                this.result.setDoctypeSystem(doctypeSystem);
            }
            if (doctypePublic != null) {
                this.result.setDoctypePublic(doctypePublic);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspOutputStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitCDataTag(CDATASection cdata) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitCDataTag", new Object[]{cdata});
        }
        this.visitJspELTextStart((Element)cdata.getParentNode(), cdata.getData(), String.class);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitCDataTag");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspBodyStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspBodyStart", new Object[]{jspElement});
        }
        Node parent = jspElement.getParentNode();
        if (parent.getNodeType() != 1) throw new JspTranslationException(jspElement, "jsp.error.jsp.body.invalid.parent");
        Element parentElement = (Element)parent;
        String uri = this.prefixToUriMap.get(parentElement.getPrefix());
        if (uri == null) {
            String actionName = parentElement.getLocalName();
            boolean validActionFound = false;
            for (int i = 0; i < BODY_STANDARD_ACTIONS.length; ++i) {
                if (!actionName.equals(BODY_STANDARD_ACTIONS[i])) continue;
                validActionFound = true;
                break;
            }
            if (!validActionFound) {
                if (!actionName.equals("root")) throw new JspTranslationException(jspElement, "jsp.error.jsp.body.invalid.parent");
                if (!this.jspConfiguration.isXml()) {
                    throw new JspTranslationException(jspElement, "jsp.error.jsp.body.invalid.parent");
                }
            }
        } else {
            String tagName = parentElement.getLocalName();
            TagLibraryInfoImpl tli = this.result.getTagLibMap().get(uri);
            TagInfo ti = tli.getTag(tagName);
            if (ti != null && ti.getBodyContent().equalsIgnoreCase("empty")) {
                throw new JspTranslationException(jspElement, "jsp.error.jsp.body.parent.nobody");
            }
        }
        if (logger == null || !logger.isLoggable(Level.FINER)) return;
        logger.exiting(CLASS_NAME, "visitJspBodyStart");
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitIncludeDirectiveStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitIncludeDirectiveStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitIncludeDirectiveStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitTagDirectiveStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitTagDirectiveStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitTagDirectiveStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitAttributeDirectiveStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitAttributeDirectiveStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitAttributeDirectiveStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitVariableDirectiveStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitVariableDirectiveStart", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitVariableDirectiveStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitUninterpretedTagStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitUninterpretedTagStart", new Object[]{jspElement});
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "jspElement =[" + jspElement + "]");
        }
        String uri = jspElement.getNamespaceURI();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "uri =[" + uri + "]");
        }
        if (uri != null) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "uri =[" + uri + "]");
            }
            if (uri.startsWith("urn:jsptld:")) {
                uri = uri.substring(uri.indexOf("urn:jsptld:") + 11);
            } else if (uri.startsWith("urn:jsptagdir:")) {
                uri = uri.substring(uri.indexOf("urn:jsptagdir:") + 14);
            }
            TagLibraryInfoImpl tli = this.result.getTagLibMap().get(uri);
            if (tli == null) {
                tli = this.tagLibraryCache.getTagLibraryInfo(uri, "", this.jspUri);
                if (tli != null) {
                    jspElement.setPrefix("");
                    this.visitCustomTagStart(jspElement);
                }
            } else {
                jspElement.setPrefix("");
                this.visitCustomTagStart(jspElement);
            }
        }
        NamedNodeMap nodeAttrs = jspElement.getAttributes();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "nodeAttrs = [" + nodeAttrs + "]");
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "nodeAttrs.getLength() = [" + nodeAttrs.getLength() + "]");
        }
        for (int i = 0; i < nodeAttrs.getLength(); ++i) {
            Attr attr = (Attr)nodeAttrs.item(i);
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagStart", "nodeAttrs attr = [" + attr + "]");
            }
            this.visitJspELTextStart(jspElement, attr.getValue(), String.class);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitUninterpretedTagStart");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspParamEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspParamEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspParamEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspGetPropertyEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspGetPropertyEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspGetPropertyEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspRootEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspRootEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspRootEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspFallbackEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspFallbackEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspFallbackEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspUseBeanEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspUseBeanEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspUseBeanEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspForwardEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspForwardEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspForwardEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspPluginEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspPluginEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspPluginEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspSetPropertyEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspSetPropertyEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspSetPropertyEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitIncludeDirectiveEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitIncludeDirectiveEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitIncludeDirectiveEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspExpressionEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspExpressionEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspExpressionEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitPageDirectiveEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitPageDirectiveEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitPageDirectiveEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspIncludeEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspIncludeEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspIncludeEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspScriptletEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspScriptletEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspScriptletEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspDeclarationEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspDeclarationEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspDeclarationEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspTextEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspTextEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspTextEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspParamsEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspParamsEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspParamsEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspAttributeEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspAttributeEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspAttributeEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspElementEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspElementEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspElementEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspBodyEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspBodyEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspBodyEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspInvokeEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspInvokeEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspInvokeEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspDoBodyEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspDoBodyEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspDoBodyEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitTagDirectiveEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitTagDirectiveEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitTagDirectiveEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitAttributeDirectiveEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitAttributeDirectiveEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitAttributeDirectiveEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitVariableDirectiveEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitVariableDirectiveEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitVariableDirectiveEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspOutputEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspOutputEnd", new Object[]{jspElement});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspOutputEnd");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitUninterpretedTagEnd(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitUninterpretedTagEnd", new Object[]{jspElement});
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagEnd", "jspElement =[" + jspElement + "]");
        }
        String uri = jspElement.getNamespaceURI();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitUninterpretedTagEnd", "uri =[" + uri + "]");
        }
        if (uri != null) {
            if (uri.startsWith("urn:jsptld:")) {
                uri = uri.substring(uri.indexOf("urn:jsptld:") + 11);
            } else if (uri.startsWith("urn:jsptagdir:")) {
                uri = uri.substring(uri.indexOf("urn:jsptagdir:") + 14);
            }
            TagLibraryInfoImpl tli = this.result.getTagLibMap().get(uri);
            if (tli != null) {
                jspElement.setPrefix("");
                this.visitCustomTagEnd(jspElement);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitUninterpretedTagEnd");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Vector setScriptingVars(TagVariableInfo[] tagVarInfos, VariableInfo[] varInfos, TagData tagData, int scope, int tagCount) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setScriptingVars", new Object[]{tagVarInfos, varInfos, tagData, scope, tagCount});
        }
        if (tagVarInfos.length == 0 && varInfos.length == 0) {
            Vector vector = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                vector = vector;
                logger.exiting(CLASS_NAME, "setScriptingVars", vector);
            }
            return vector;
        }
        Vector<Object> vec = new Vector<Object>();
        Integer ownRange = null;
        ownRange = scope == 1 || scope == 2 ? (this.tagCountStack.size() > 0 ? (Integer)this.tagCountStack.peek() : new Integer(Integer.MAX_VALUE)) : new Integer(tagCount);
        if (varInfos.length > 0) {
            for (int i = 0; i < varInfos.length; ++i) {
                if (varInfos[i].getScope() != scope || !varInfos[i].getDeclare()) continue;
                String varName = varInfos[i].getVarName();
                Integer currentRange = this.scriptVars.get(varName);
                if (currentRange != null && scope != 0) {
                    this.dupFlag = true;
                    this.setDuplicateVars(varInfos[i]);
                }
                if (currentRange != null && ownRange.compareTo(currentRange) <= 0) continue;
                this.scriptVars.put(varName, ownRange);
                vec.add(varInfos[i]);
            }
        } else {
            for (int i = 0; i < tagVarInfos.length; ++i) {
                if (tagVarInfos[i].getScope() != scope || !tagVarInfos[i].getDeclare()) continue;
                String varName = tagVarInfos[i].getNameGiven();
                if (varName == null && (varName = tagData.getAttributeString(tagVarInfos[i].getNameFromAttribute())) == null) {
                    throw new JspTranslationException("jsp.error.scripting.variable.missing_name", new Object[]{tagVarInfos[i].getNameFromAttribute()});
                }
                Integer currentRange = this.scriptVars.get(varName);
                if (currentRange != null && ownRange.compareTo(currentRange) <= 0) continue;
                this.scriptVars.put(varName, ownRange);
                vec.add(tagVarInfos[i]);
            }
        }
        Vector<Object> vector = vec;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            vector = vector;
            logger.exiting(CLASS_NAME, "setScriptingVars", vector);
        }
        return vector;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setDuplicateVars(VariableInfo varInfo) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setDuplicateVars", new Object[]{varInfo});
        }
        boolean alreadyDup = false;
        VariableInfo var = null;
        String varInfoVarName = varInfo.getVarName();
        for (int x = 0; x < this.dupVector.size(); ++x) {
            var = (VariableInfo)this.dupVector.get(x);
            if (!var.getVarName().equals(varInfoVarName)) continue;
            alreadyDup = true;
            break;
        }
        if (!alreadyDup) {
            this.dupVector.addElement(varInfo);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setDuplicateVars");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Vector getDuplicateVars() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getDuplicateVars", new Object[0]);
        }
        Vector vector = this.dupVector;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            vector = vector;
            logger.exiting(CLASS_NAME, "getDuplicateVars", vector);
        }
        return vector;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void validateTagLib(Document jspDocument, String uri, String prefix, TagLibraryInfoImpl tli) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "validateTagLib", new Object[]{jspDocument, uri, prefix, tli});
        }
        TagLibraryValidator tlv = tli.getTagLibraryValidator();
        if (tlv != null) {
            ClassLoader originalClassLoader = ThreadContextHelper.getContextClassLoader();
            ThreadContextHelper.setClassLoader((ClassLoader)this.context.getJspClassloaderContext().getClassLoader());
            try {
                ValidationMessage[] validationMessages = tlv.validate(prefix, uri, (PageData)new PageDataImpl(jspDocument, this.tagLibraryCache));
                ThreadContextHelper.setClassLoader((ClassLoader)originalClassLoader);
                if (validationMessages != null && validationMessages.length > 0) {
                    StringBuffer errMsg = new StringBuffer();
                    for (int i = 0; i < validationMessages.length; ++i) {
                        if (validationMessages[i] == null) continue;
                        errMsg.append("<p>");
                        if (validationMessages[i].getId() != null) {
                            JspId jspId = new JspId(validationMessages[i].getId());
                            errMsg.append("File [" + jspId.getFilePath() + "] ");
                            errMsg.append("Line [" + jspId.getStartSourceLineNum() + "] ");
                            errMsg.append("Column [" + jspId.getStartSourceColNum() + "] ");
                        }
                        errMsg.append(validationMessages[i].getMessage());
                        errMsg.append("</p>");
                    }
                    throw new JspTranslationException("jsp.error.tlv.invalid.page", new Object[]{uri, errMsg.toString()});
                }
            }
            catch (Throwable e) {
                throw new JspCoreException(e);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "validateTagLib");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void validateAttributes(List attributeList, Element jspElement, String[] validAttrs) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "validateAttributes", new Object[]{attributeList, jspElement, validAttrs});
        }
        for (int i = 0; i < attributeList.size(); ++i) {
            String attr = (String)attributeList.get(i);
            if (attr.equals("jsp:id") || attr.startsWith("xmlns")) continue;
            boolean valid = false;
            for (int j = 0; j < validAttrs.length; ++j) {
                if (!attr.equals(validAttrs[j])) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            throw new JspTranslationException(jspElement, "jsp.error.unknown.attribute", new Object[]{attr, jspElement.getTagName()});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "validateAttributes");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void validateAttributes(Element jspElement, String[] validAttrs) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "validateAttributes", new Object[]{jspElement, validAttrs});
        }
        NamedNodeMap attrs = jspElement.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String uri = attr.getNamespaceURI();
            String fullName = attr.getNodeName();
            if (uri != null && attr.getLocalName().equals("id") && uri.equals("http://java.sun.com/JSP/Page") || fullName.startsWith("xmlns")) continue;
            boolean valid = false;
            for (int j = 0; j < validAttrs.length; ++j) {
                if (!attr.getNodeName().equals(validAttrs[j])) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            throw new JspTranslationException(jspElement, "jsp.error.unknown.attribute", new Object[]{attr.getNodeName(), jspElement.getTagName()});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "validateAttributes");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void validateEmptyBody(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "validateEmptyBody", new Object[]{jspElement});
        }
        NodeList childNodes = jspElement.getChildNodes();
        if (childNodes != null) {
            CDATASection cdata = null;
            Element childElement = null;
            String value = null;
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node n = childNodes.item(j);
                if (n.getNodeType() == 4) {
                    cdata = (CDATASection)n;
                    value = cdata.getData();
                    if (value.trim().length() <= 0) continue;
                    throw new JspTranslationException(jspElement, "jsp.error.jspbody.emptybody.only", new Object[]{jspElement.getNodeName(), "[" + n.getNodeName() + "] : " + value});
                }
                if (!(n instanceof Element) || (childElement = (Element)n).getNamespaceURI().equals("http://java.sun.com/JSP/Page") && childElement.getLocalName().equals("attribute")) continue;
                throw new JspTranslationException(jspElement, "jsp.error.jspbody.emptybody.only", new Object[]{jspElement.getNodeName(), childElement.getNamespaceURI() + " : " + childElement.getLocalName()});
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "validateEmptyBody");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspELTextStart(Element jspElement, String cdata, Class expectedType) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspELTextStart", new Object[]{jspElement, cdata, expectedType});
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitJspELTextStart", "cdata =[" + cdata + "]");
            logger.logp(Level.FINER, CLASS_NAME, "visitJspELTextStart", "cdata.indexOf('${') =[" + cdata.indexOf("${") + "]");
            logger.logp(Level.FINER, CLASS_NAME, "visitJspELTextStart", "cdata.indexOf('#{') =[" + cdata.indexOf("#{") + "]");
        }
        if (cdata.indexOf("${") == -1 && cdata.indexOf("#{") == -1) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting(CLASS_NAME, "visitJspELTextStart");
            }
            return;
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitJspELTextStart", "calling ELValidator.getELExpressions");
        }
        String[] expressions = ELValidator.getELExpressions(cdata, this.jspConfiguration, this.evalQuotedAndEscapedExpression);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "visitJspELTextStart", "expressions returned: [" + expressions + "]");
        }
        if (expressions != null) {
            for (int i = 0; i < expressions.length; ++i) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "visitJspELTextStart", "about to validate expression: [" + expressions[i] + "]");
                }
                ELValidator.validateELExpression(jspElement, expressions[i], expectedType, this.jspConfiguration, this.result, this.context, this.prefixToUriMap);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspELTextStart");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getAttributeValue(Element element, String attributeName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getAttributeValue", new Object[]{element, attributeName});
        }
        String attributeValue = element.getAttribute(attributeName);
        if (attributeValue.equals("")) {
            NodeList nl = element.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Element e;
                Node n = nl.item(i);
                if (n.getNodeType() != 1 || (e = (Element)n).getNamespaceURI() == null || !e.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !e.getLocalName().equals("attribute")) continue;
                String name = e.getAttribute("name");
                if (name.indexOf(58) != -1) {
                    name = name.substring(name.indexOf(58) + 1);
                }
                if (!name.equals(attributeName)) continue;
                Node attrChildNode = e.getFirstChild();
                CDATASection cdata = null;
                if (attrChildNode.getNodeType() == 4) {
                    cdata = (CDATASection)attrChildNode;
                } else if (attrChildNode instanceof Element && attrChildNode.getNamespaceURI().equals("http://java.sun.com/JSP/Page") && attrChildNode.getLocalName().equals("text")) {
                    Element jspElement = (Element)attrChildNode;
                    cdata = (CDATASection)jspElement.getFirstChild();
                }
                attributeValue = cdata.getData();
                if (e.getAttribute("trim").equals("false")) continue;
                attributeValue = attributeValue.trim();
            }
        }
        if (attributeValue == null) {
            attributeValue = "";
        }
        String string = attributeValue;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getAttributeValue", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static List getAttributeList(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getAttributeList", new Object[]{jspElement});
        }
        List list = ValidateVisitor.getAttributeList(jspElement, false);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting(CLASS_NAME, "getAttributeList", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static List getAttributeList(Element jspElement, boolean ignoreDuplicates) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getAttributeList", new Object[]{jspElement, ignoreDuplicates});
        }
        ArrayList<String> attributeList = new ArrayList<String>(11);
        NamedNodeMap nnmTop = jspElement.getAttributes();
        for (int i = 0; i < nnmTop.getLength(); ++i) {
            Node parentNode = nnmTop.item(i);
            String nodeName = parentNode.getNodeName();
            if (nodeName.equals("jsp:id")) continue;
            if (attributeList.contains(nodeName)) {
                if (ignoreDuplicates) continue;
                throw new JspTranslationException(jspElement, "jsp.error.multiple.attribute.definitions", new Object[]{nodeName, jspElement.getTagName()});
            }
            attributeList.add(nodeName);
        }
        NodeList nl = jspElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e;
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || (e = (Element)n).getNamespaceURI() == null || !e.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !e.getLocalName().equals("attribute")) continue;
            NamedNodeMap nnmChild = e.getAttributes();
            String nodeName = e.getAttribute("name");
            if (nodeName.indexOf(58) != -1) {
                nodeName = nodeName.substring(nodeName.indexOf(58) + 1);
            }
            if (attributeList.contains(nodeName)) {
                if (ignoreDuplicates) continue;
                throw new JspTranslationException(jspElement, "jsp.error.multiple.attribute.definitions", new Object[]{nodeName, jspElement.getTagName()});
            }
            attributeList.add(nodeName);
        }
        ArrayList<String> arrayList = attributeList;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting(CLASS_NAME, "getAttributeList", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected CustomTagInstance validateCustomTagAttributeValues(Element jspElement, TagAttributeInfo[] attributes, boolean hasDynamicAttributes, TagLibraryInfoImpl tli) throws JspCoreException {
        boolean checkDeferred;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "validateCustomTagAttributeValues", new Object[]{jspElement, attributes, hasDynamicAttributes, tli});
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "Entry");
        }
        Hashtable<String, Object> attributeMap = new Hashtable<String, Object>(11);
        boolean isScriptless = true;
        boolean bl = checkDeferred = !this.jspConfiguration.isDeferredSyntaxAllowedAsLiteral();
        if (tli.getRequiredVersion() != null) {
            checkDeferred = checkDeferred && !tli.getRequiredVersion().equals("2.0") && !tli.getRequiredVersion().equals("1.2");
        }
        NamedNodeMap nnmTop = jspElement.getAttributes();
        for (int i = 0; i < nnmTop.getLength(); ++i) {
            Node parentNode = nnmTop.item(i);
            String nodeName = parentNode.getNodeName();
            String nodeValue = parentNode.getNodeValue();
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "nodeName =[" + nodeName + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "nodeValue =[" + nodeValue + "]");
            }
            if (nodeName.equals("jsp:id") || nodeName.startsWith("xmlns")) continue;
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "NOT jsp:id and NOT xmlns");
            }
            TagAttributeInfo tai = this.getTagAttributeInfo(attributes, nodeName);
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "attributes [" + attributes + "] nodeName [" + nodeName + "]  nodeValue [" + nodeValue + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "tai [" + tai + "]");
            }
            boolean dynamicDeferredMethod = false;
            String dynamicDeferredMethodSignature = null;
            if (tai == null && !hasDynamicAttributes) {
                throw new JspTranslationException(jspElement, "jsp.error.unable.locate.tagname", new Object[]{nodeName});
            }
            isScriptless = this.validateCustomTagAttribute(jspElement, attributeMap, isScriptless, checkDeferred, nodeName, tai, nodeValue, dynamicDeferredMethod, dynamicDeferredMethodSignature);
        }
        NodeList nl = jspElement.getChildNodes();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "nl.getLength() =[" + nl.getLength() + "]");
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "n.getNodeName() =[" + n.getNodeName() + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "n.getNodeType() =[" + n.getNodeType() + "]");
            }
            if (n.getNodeType() != 1) continue;
            Element e = (Element)n;
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "e.getNamespaceURI() =[" + e.getNamespaceURI() + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "e.getLocalName() =[" + e.getLocalName() + "]");
            }
            if (e.getNamespaceURI() == null || !e.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !e.getLocalName().equals("attribute")) continue;
            String nodeName = e.getAttribute("name");
            if (nodeName.indexOf(":") != -1) {
                nodeName = nodeName.substring(nodeName.indexOf(58) + 1);
            }
            boolean trim = true;
            if (!e.getAttribute("trim").equals("")) {
                trim = Boolean.valueOf(e.getAttribute("trim"));
            }
            NodeList childAttributeNodeList = e.getChildNodes();
            TagAttributeInfo tai = this.getTagAttributeInfo(attributes, nodeName);
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "attributes [" + attributes + "] nodeName [" + nodeName + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "tai [" + tai + "]");
            }
            boolean isFragment = false;
            boolean dynamicDeferredMethod = false;
            String dynamicDeferredMethodSignature = null;
            if (tai == null) {
                if (!hasDynamicAttributes) {
                    throw new JspTranslationException(jspElement, "jsp.error.unable.locate.tagname", new Object[]{nodeName});
                }
            } else {
                isFragment = tai.isFragment();
            }
            if (e.hasChildNodes()) {
                int numChildren = childAttributeNodeList.getLength();
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "numChildren =[" + numChildren + "]");
                }
                if (numChildren == 1) {
                    Node childAttrNode = e.getFirstChild();
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "childAttrNode.getNodeName(): " + childAttrNode.getNodeName());
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "childAttrNode.getNodeType(): " + childAttrNode.getNodeType());
                    }
                    if (childAttrNode.getNodeType() == 4) {
                        CDATASection cdata = (CDATASection)childAttrNode;
                        String nodeValue = cdata.getData();
                        if (trim) {
                            nodeValue = nodeValue.trim();
                        }
                        isScriptless = this.validateCustomTagAttribute(jspElement, attributeMap, isScriptless, checkDeferred, nodeName, tai, nodeValue, dynamicDeferredMethod, dynamicDeferredMethodSignature);
                        continue;
                    }
                    if (childAttrNode.getNodeType() != 1) continue;
                    if (!this.areChildrenScriptless(e)) {
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "Element children are not scriptless.");
                        }
                        if (tai != null && !tai.canBeRequestTime()) {
                            throw new JspTranslationException(jspElement, "jsp.error.attribute.cannot.be.request.time", new Object[]{nodeName, childAttrNode.getNodeValue()});
                        }
                        isScriptless = false;
                        attributeMap.put(nodeName, TagData.REQUEST_TIME_VALUE);
                        continue;
                    }
                    attributeMap.put(nodeName, TagData.REQUEST_TIME_VALUE);
                    continue;
                }
                int childrenWithValues = 0;
                boolean previousCData = false;
                for (int child = 0; child < numChildren; ++child) {
                    Node currNode = childAttributeNodeList.item(child);
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "currNode.getNodeName(): " + currNode.getNodeName());
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "currNode.getNodeType(): " + currNode.getNodeType());
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "currNode.getNodeValue(): " + currNode.getNodeValue());
                    }
                    if (currNode.getNodeType() == 4) {
                        CDATASection cdata = (CDATASection)currNode;
                        String nodeValue = cdata.getData();
                        if (trim) {
                            nodeValue = nodeValue.trim();
                        }
                        if (nodeValue.length() <= 0) continue;
                        if (!previousCData) {
                            ++childrenWithValues;
                        }
                        previousCData = true;
                        continue;
                    }
                    if (currNode.getNodeType() == 1) {
                        Element e1 = (Element)currNode;
                        if (this.areChildrenScriptless(e)) continue;
                        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues 2", "2. Element children are not scriptless.");
                        }
                        if (tai != null && !tai.canBeRequestTime()) {
                            throw new JspTranslationException(jspElement, "jsp.error.attribute.cannot.be.request.time", new Object[]{nodeName, currNode.getNodeValue()});
                        }
                        isScriptless = false;
                        continue;
                    }
                    ++childrenWithValues;
                }
                if (isFragment && childrenWithValues > 1) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "childrenWithValues =[" + childrenWithValues + "]");
                    }
                    throw new JspTranslationException(jspElement, "jsp.error.attribute.cannot.be.request.time.fragment", new Object[]{nodeName});
                }
                attributeMap.put(nodeName, TagData.REQUEST_TIME_VALUE);
                continue;
            }
            attributeMap.put(nodeName, "");
        }
        CustomTagInstance customTagInstance = new CustomTagInstance(attributeMap, isScriptless);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            customTagInstance = customTagInstance;
            logger.exiting(CLASS_NAME, "validateCustomTagAttributeValues", customTagInstance);
        }
        return customTagInstance;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean validateCustomTagAttribute(Element jspElement, Hashtable attributeMap, boolean isScriptless, boolean checkDeferred, String nodeName, TagAttributeInfo tai, String nodeValue, boolean dynamicDeferredMethod, String dynamicDeferredMethodSignature) throws JspTranslationException, JspCoreException {
        boolean expression;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "validateCustomTagAttribute", new Object[]{jspElement, attributeMap, isScriptless, checkDeferred, nodeName, tai, nodeValue, dynamicDeferredMethod, dynamicDeferredMethodSignature});
        }
        boolean isExpr = JspTranslatorUtil.isExpression(nodeValue);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "about to call JspTranslatorUtil.isELInterpreterInput(nodeValue, jspConfiguration)");
        }
        boolean isElExpr = JspTranslatorUtil.isELInterpreterInput(nodeValue, this.jspConfiguration, checkDeferred);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "isExpr =[" + isExpr + "] isElExpr= [" + isElExpr + "]");
            if (tai != null) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "tai.canBeRequestTime() =[" + tai.canBeRequestTime() + "] tai.isDeferredMethod()= [" + tai.isDeferredMethod() + "] tai.isDeferredValue()= [" + tai.isDeferredValue() + "]");
            } else {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "tai is null, must be a dynamic attribute");
            }
        }
        boolean elExpression = false;
        boolean deferred = false;
        boolean deferredValueIsLiteral = this.jspConfiguration.isDeferredSyntaxAllowedAsLiteral();
        ELNode.Nodes el = null;
        if (!(isExpr || this.jspConfiguration.elIgnored() || this.jspConfiguration.elIgnoredSetTrueInPage() || this.jspConfiguration.elIgnoredSetTrueInPropGrp())) {
            el = ELParser.parse(nodeValue);
            Iterator<ELNode> nodes = el.iterator();
            while (nodes.hasNext()) {
                ELNode node = nodes.next();
                if (!(node instanceof ELNode.Root)) continue;
                if (((ELNode.Root)node).getType() == '$') {
                    elExpression = true;
                    continue;
                }
                if (!checkDeferred || ((ELNode.Root)node).getType() != '#') continue;
                elExpression = true;
                deferred = true;
            }
        }
        boolean bl = expression = isExpr || elExpression;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "nodeValue [" + nodeValue + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "deferred [" + deferred + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "deferredValueIsLiteral [" + deferredValueIsLiteral + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "checkDeferred [" + checkDeferred + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "expression [" + expression + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "isExpr [" + isExpr + "]");
            logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "jspConfiguration.elIgnored() [" + this.jspConfiguration.elIgnored() + "]");
        }
        boolean thisIsADynamicAttribute = false;
        if (tai == null) {
            thisIsADynamicAttribute = true;
        }
        if (thisIsADynamicAttribute || tai.canBeRequestTime() || checkDeferred && (tai.isDeferredMethod() || tai.isDeferredValue())) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "in tai check nodeValue [" + nodeValue + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "in tai check deferred [" + deferred + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "in tai check deferredValueIsLiteral [" + deferredValueIsLiteral + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "in tai check checkDeferred [" + checkDeferred + "]");
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "in tai check expression [" + expression + "]");
            }
            String expectedType = null;
            boolean taiIsDeferredMethod = dynamicDeferredMethod;
            boolean taiIsDeferredValue = deferred;
            String taiGetMethodSignature = dynamicDeferredMethodSignature;
            String taiGetExpectedTypeName = "java.lang.Object";
            String taiGetName = nodeName;
            boolean taiCanBeRequestTime = true;
            if (tai != null) {
                taiIsDeferredMethod = tai.isDeferredMethod();
                taiIsDeferredValue = tai.isDeferredValue();
                taiGetMethodSignature = tai.getMethodSignature();
                taiGetExpectedTypeName = tai.getExpectedTypeName();
                taiGetName = tai.getName();
                taiCanBeRequestTime = tai.canBeRequestTime();
            }
            if (!expression) {
                if (taiIsDeferredMethod) {
                    String m = taiGetMethodSignature;
                    if (m != null) {
                        int rti = m.trim().indexOf(32);
                        if (rti > 0) {
                            expectedType = m.substring(0, rti).trim();
                        }
                    } else {
                        expectedType = "java.lang.Object";
                    }
                }
                if (taiIsDeferredValue) {
                    expectedType = taiGetExpectedTypeName;
                }
                if (expectedType != null) {
                    Class expectedClass = String.class;
                    try {
                        expectedClass = JspTranslatorUtil.toClass(expectedType, this.context.getJspClassloaderContext().getClassLoader());
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new JspTranslationException(jspElement, "jsp.error.unknown_attribute_type", new Object[]{taiGetName, expectedType});
                    }
                    try {
                        ValidateVisitor.ELCheckType(nodeValue, expectedClass);
                    }
                    catch (Exception excep) {
                        throw new JspTranslationException(jspElement, "jsp.error.coerce_to_type", new Object[]{taiGetName, expectedType, nodeValue});
                    }
                }
                attributeMap.put(nodeName, nodeValue);
            } else {
                if (isExpr) {
                    isScriptless = false;
                }
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "isScriptless =[" + isScriptless + "]");
                }
                if (deferred && !taiIsDeferredMethod && !taiIsDeferredValue) {
                    throw new JspTranslationException(jspElement, "jsp.error.attribute.cannot.be.request.time", new Object[]{nodeName, nodeValue});
                }
                if (!deferred && !taiCanBeRequestTime) {
                    throw new JspTranslationException(jspElement, "jsp.error.attribute.cannot.be.request.time", new Object[]{nodeName, nodeValue});
                }
                if (elExpression) {
                    expectedType = taiGetExpectedTypeName;
                    if (expectedType == null) {
                        expectedType = "java.lang.Object";
                    }
                    if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttribute", "about to call validateELExpression, expectedType =[" + expectedType + "]");
                    }
                    ELValidator.validateELExpression(jspElement, nodeValue, expectedType, this.jspConfiguration, this.context, this.result, this.prefixToUriMap);
                }
                attributeMap.put(nodeName, TagData.REQUEST_TIME_VALUE);
            }
        } else {
            if (expression) {
                throw new JspTranslationException(jspElement, "jsp.error.attribute.cannot.be.request.time", new Object[]{nodeName, nodeValue});
            }
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "validateCustomTagAttributeValues", "Adding to attribute map nodeName =[" + nodeName + "] nodeValue =[" + nodeValue + "]");
            }
            attributeMap.put(nodeName, nodeValue);
        }
        boolean bl2 = isScriptless;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl2 = bl2;
            logger.exiting(CLASS_NAME, "validateCustomTagAttribute", bl2);
        }
        return bl2;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static final void ELCheckType(Object obj, Class<?> type) throws ELException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "ELCheckType", new Object[]{obj, type});
        }
        if (String.class.equals(type)) {
            ELSupport.coerceToString(null, (Object)obj);
        }
        if (ELArithmetic.isNumberType(type)) {
            ELSupport.coerceToNumber(null, (Object)obj, type);
        }
        if (Character.class.equals(type) || Character.TYPE == type) {
            ELSupport.coerceToCharacter(null, (Object)obj);
        }
        if (Boolean.class.equals(type) || Boolean.TYPE == type) {
            ELSupport.coerceToBoolean(null, (Object)obj, (boolean)true);
        }
        if (type.isEnum()) {
            ELSupport.coerceToEnum(null, (Object)obj, type);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "ELCheckType");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void validateRequiredAttributes(Element jspElement, List specifiedActionAttrs, String[] requiredAttrs) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "validateRequiredAttributes", new Object[]{jspElement, specifiedActionAttrs, requiredAttrs});
        }
        for (int i = 0; i < requiredAttrs.length; ++i) {
            if (specifiedActionAttrs.contains(requiredAttrs[i])) continue;
            throw new JspTranslationException(jspElement, "jsp.error.missing.required.attribute", new Object[]{requiredAttrs[i], jspElement.getTagName()});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "validateRequiredAttributes");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void validateCustomTagAttributes(Element jspElement, TagAttributeInfo[] attributes) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "validateCustomTagAttributes", new Object[]{jspElement, attributes});
        }
        NodeList nl = jspElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e;
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || (e = (Element)n).getNamespaceURI() == null || !e.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !e.getLocalName().equals("attribute")) continue;
            NamedNodeMap nnmChild = e.getAttributes();
            String nodeName = e.getAttribute("name");
            if (nodeName.indexOf(":") != -1) {
                nodeName = nodeName.substring(nodeName.indexOf(58) + 1);
            }
            for (int attrIndex = 0; attrIndex < attributes.length; ++attrIndex) {
                TagAttributeInfo tai = attributes[attrIndex];
                String taiName = tai.getName();
                if (taiName == null || !taiName.equals(nodeName) || !tai.isFragment()) continue;
                NodeList attrNodeList = e.getChildNodes();
                for (int attrNodesIndex = 0; attrNodesIndex < attrNodeList.getLength(); ++attrNodesIndex) {
                    Element attrNodeElement;
                    Node attrNode = attrNodeList.item(attrNodesIndex);
                    if (attrNode.getNodeType() != 1 || (attrNodeElement = (Element)attrNode).getNamespaceURI() == null || !attrNodeElement.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !attrNodeElement.getLocalName().equals("scriptlet") && !attrNodeElement.getLocalName().equals("expression") && !attrNodeElement.getLocalName().equals("declaration")) continue;
                    throw new JspTranslationException(jspElement, "jsp.error.attribute.fragment.cannot.be.scriplet", new Object[]{attrNodeElement.getNodeName()});
                }
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "validateCustomTagAttributes");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected TagAttributeInfo getTagAttributeInfo(TagAttributeInfo[] attributes, String nodeName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getTagAttributeInfo", new Object[]{attributes, nodeName});
        }
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equals(nodeName)) continue;
            TagAttributeInfo tagAttributeInfo = attributes[i];
            if (logger != null && logger.isLoggable(Level.FINER)) {
                tagAttributeInfo = tagAttributeInfo;
                logger.exiting(CLASS_NAME, "getTagAttributeInfo", tagAttributeInfo);
            }
            return tagAttributeInfo;
        }
        TagAttributeInfo tagAttributeInfo = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            tagAttributeInfo = tagAttributeInfo;
            logger.exiting(CLASS_NAME, "getTagAttributeInfo", tagAttributeInfo);
        }
        return tagAttributeInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean areChildrenScriptless(Element jspElement) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "areChildrenScriptless", new Object[]{jspElement});
        }
        NodeList nl = jspElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            Element e = (Element)n;
            if (e.getNamespaceURI() != null && e.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
                if (e.getLocalName().equals("scriptlet") || e.getLocalName().equals("expression") || e.getLocalName().equals("declaration")) {
                    boolean bl = false;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        bl = bl;
                        logger.exiting(CLASS_NAME, "areChildrenScriptless", bl);
                    }
                    return bl;
                }
                for (int j = 0; j < ATTR_STANDARD_ACTIONS.length; ++j) {
                    if (!e.getLocalName().equals(ATTR_STANDARD_ACTIONS[j])) continue;
                    NamedNodeMap attrs = e.getAttributes();
                    if (attrs != null) {
                        for (int k = 0; k < attrs.getLength(); ++k) {
                            if (!JspTranslatorUtil.isExpression(attrs.item(k).getNodeValue(), true)) continue;
                            boolean bl = false;
                            if (logger != null && logger.isLoggable(Level.FINER)) {
                                bl = bl;
                                logger.exiting(CLASS_NAME, "areChildrenScriptless", bl);
                            }
                            return bl;
                        }
                    }
                    if (this.areChildrenScriptless(e)) continue;
                    boolean bl = false;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        bl = bl;
                        logger.exiting(CLASS_NAME, "areChildrenScriptless", bl);
                    }
                    return bl;
                }
                continue;
            }
            if (this.areChildrenScriptless(e)) continue;
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "areChildrenScriptless", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "areChildrenScriptless", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ValidateTagInfo getTagInfo(Element jspElement, String uri, String prefix, String tagName) throws JspCoreException {
        TagInfo ti;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getTagInfo", new Object[]{jspElement, uri, prefix, tagName});
        }
        TagLibraryInfoImpl tli = this.result.getTagLibMap().get(uri);
        boolean isTagFile = false;
        if (tli == null) {
            tli = this.tagLibraryCache.getTagLibraryInfo(uri, prefix, this.jspUri);
            if (tli != null) {
                if (tli.getTldFilePath() != null && (tli.isContainer() || !tli.isContainer() && tli.getInputSource().getAbsoluteURL().getProtocol().equals("file")) && !this.tagLibraryCache.getImplicitTagLibPrefixMap().containsValue(uri)) {
                    this.result.getDependencyList().add(tli.getTldFilePath());
                }
                this.result.getTagLibMap().put(uri, tli);
                tli.setTagLibMap(this.result.getTagLibMap());
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getTagInfo", "getTagLibraryInfos() =[" + tli.getTagLibraryInfos() + "]");
                }
                this.prefixToUriMap.put(prefix, uri);
                this.validateTagLib(jspElement.getOwnerDocument(), uri, prefix, tli);
            } else {
                if (!this.jspConfiguration.isXml()) {
                    if (!uri.equalsIgnoreCase("http://java.sun.com/JSP/Page")) {
                        throw new JspTranslationException(jspElement, "jsp.error.tld.not.found", new Object[]{uri, prefix});
                    }
                    ValidateTagInfo validateTagInfo = null;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        validateTagInfo = validateTagInfo;
                        logger.exiting(CLASS_NAME, "getTagInfo", validateTagInfo);
                    }
                    return validateTagInfo;
                }
                ValidateTagInfo validateTagInfo = null;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    validateTagInfo = validateTagInfo;
                    logger.exiting(CLASS_NAME, "getTagInfo", validateTagInfo);
                }
                return validateTagInfo;
            }
        }
        if ((ti = tli.getTag(tagName)) == null) {
            TagFileInfo tfi = tli.getTagFile(tagName);
            if (tfi == null) {
                throw new JspTranslationException(jspElement, "jsp.error.tagfile.not.found", new Object[]{tagName});
            }
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getTagInfo", "prefix : " + prefix + "; tagName : " + tagName + " = Tag file path : " + tfi.getPath());
            }
            ti = tfi.getTagInfo();
            this.tagLibraryCache.addTagFileClassInfo(tfi);
            isTagFile = true;
        }
        ValidateTagInfo validateTagInfo = new ValidateTagInfo(ti, tli, isTagFile);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            validateTagInfo = validateTagInfo;
            logger.exiting(CLASS_NAME, "getTagInfo", validateTagInfo);
        }
        return validateTagInfo;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean shouldSkipChildrenForThisVisitor() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "shouldSkipChildrenForThisVisitor", new Object[0]);
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "shouldSkipChildrenForThisVisitor", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isElementTagDependent(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isElementTagDependent", new Object[]{jspElement});
        }
        String uri = jspElement.getNamespaceURI();
        String prefix = jspElement.getPrefix();
        String tagName = jspElement.getLocalName();
        ValidateTagInfo vti = this.getTagInfo(jspElement, uri, prefix, tagName);
        if (vti == null) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "isElementTagDependent", bl);
            }
            return bl;
        }
        String bodyContent = vti.getTagInfo().getBodyContent();
        if (bodyContent == null) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "isElementTagDependent", bl);
            }
            return bl;
        }
        boolean bl = bodyContent.equalsIgnoreCase("tagdependent");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isElementTagDependent", bl);
        }
        return bl;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    protected class ValidateTagInfo {
        private TagInfo tagInfo;
        private TagLibraryInfoImpl tli;
        private boolean tagFile;
        static final long serialVersionUID = -1136151992719194571L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected ValidateTagInfo(TagInfo tagInfo, TagLibraryInfoImpl tli, boolean tagFile) {
            this.tagInfo = tagInfo;
            this.tli = tli;
            this.tagFile = tagFile;
        }

        protected TagInfo getTagInfo() {
            return this.tagInfo;
        }

        protected TagLibraryInfoImpl getTLI() {
            return this.tli;
        }

        protected boolean isTagFile() {
            return this.tagFile;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.visitor.validator.ValidateVisitor$ValidateTagInfo", ValidateTagInfo.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    protected class CustomTagInstance {
        private Hashtable attributes;
        private boolean isScriptless = true;
        static final long serialVersionUID = -7804117311608998404L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected CustomTagInstance(Hashtable attrs, boolean isScriptless) {
            this.attributes = attrs;
            this.isScriptless = isScriptless;
        }

        protected Hashtable getAttributes() {
            return this.attributes;
        }

        protected boolean isScriptless() {
            return this.isScriptless;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.visitor.validator.ValidateVisitor$CustomTagInstance", CustomTagInstance.class, null, null);
        }
    }
}

