/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.shared.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import jakarta.faces.FacesException;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="log", fieldDesc="Ljava/util/logging/Logger;")
public class WSFacesUtil {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = WSFacesUtil.class.getName();
    static final long serialVersionUID = -6882124233578423160L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSFacesUtil() {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.shared.util.WSFacesUtil", "<init>", new Object[0]);
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting("com.ibm.ws.jsf.shared.util.WSFacesUtil", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String removeExtraPathInfo(String pathInfo) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.shared.util.WSFacesUtil", "removeExtraPathInfo", new Object[]{pathInfo});
        }
        log.logp(Level.FINE, CLASS_NAME, "removeExtraPathInfo", "pathInfo " + pathInfo);
        if (pathInfo == null) {
            String string = null;
            if (log != null && log.isLoggable(Level.FINER)) {
                string = string;
                log.exiting("com.ibm.ws.jsf.shared.util.WSFacesUtil", "removeExtraPathInfo", string);
            }
            return string;
        }
        int semicolon = pathInfo.indexOf(59);
        if (semicolon != -1) {
            pathInfo = pathInfo.substring(0, semicolon);
        }
        if (pathInfo.trim().length() == 0) {
            String string = null;
            if (log != null && log.isLoggable(Level.FINER)) {
                string = string;
                log.exiting("com.ibm.ws.jsf.shared.util.WSFacesUtil", "removeExtraPathInfo", string);
            }
            return string;
        }
        log.logp(Level.FINE, CLASS_NAME, "removeExtraPathInfo", "modified pathInfo " + pathInfo);
        String string = pathInfo;
        if (log != null && log.isLoggable(Level.FINER)) {
            string = string;
            log.exiting("com.ibm.ws.jsf.shared.util.WSFacesUtil", "removeExtraPathInfo", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static ClassLoader getClassLoader(final Object defaultObject) {
        ClassLoader cl;
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.shared.util.WSFacesUtil", "getClassLoader", new Object[]{defaultObject});
        }
        if (System.getSecurityManager() != null) {
            try {
                cl = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){
                    static final long serialVersionUID = -8602500780173301504L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public ClassLoader run() throws PrivilegedActionException {
                        return defaultObject.getClass().getClassLoader();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsf.shared.util.WSFacesUtil$1", 1.class, null, null);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw new FacesException((Throwable)pae);
            }
        } else {
            cl = defaultObject.getClass().getClassLoader();
        }
        ClassLoader classLoader = cl;
        if (log != null && log.isLoggable(Level.FINER)) {
            classLoader = classLoader;
            log.exiting("com.ibm.ws.jsf.shared.util.WSFacesUtil", "getClassLoader", classLoader);
        }
        return classLoader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static ClassLoader getContextClassLoader(IServletContext webapp) throws Exception {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering("com.ibm.ws.jsf.shared.util.WSFacesUtil", "getContextClassLoader", new Object[]{webapp});
        }
        ClassLoader classLoader = null;
        if (System.getSecurityManager() != null) {
            final IServletContext _webapp = webapp;
            classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){
                static final long serialVersionUID = -2263007287683520752L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Object run() throws MalformedURLException {
                    return _webapp.getClassLoader();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsf.shared.util.WSFacesUtil$2", 2.class, null, null);
                }
            });
        } else {
            classLoader = webapp.getClassLoader();
        }
        ClassLoader classLoader2 = classLoader;
        if (log != null && log.isLoggable(Level.FINER)) {
            classLoader2 = classLoader2;
            log.exiting("com.ibm.ws.jsf.shared.util.WSFacesUtil", "getContextClassLoader", classLoader2);
        }
        return classLoader2;
    }
}

