/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics50.http;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.http.monitor.HttpStatAttributes;
import io.openliberty.http.monitor.metrics.HTTPMetricAdapter;
import io.openliberty.microprofile.metrics50.SharedMetricRegistries;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={HTTPMetricAdapter.class, ApplicationStateListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE)
public class MPMetricsHTTPMetricsAdapterImpl
implements HTTPMetricAdapter,
ApplicationStateListener {
    static SharedMetricRegistries sharedMetricRegistries;
    private static final TraceComponent tc;
    private static final String NO_APP_NAME_IDENTIFIER = "io.openliberty.microprofile.metrics50.internal.http.no.app.name";
    private static Map<String, Map<String, Tag[]>> appNameToTagsMap;
    static final long serialVersionUID = 1893393049747672866L;

    @Activate
    public void activate() {
    }

    @Reference
    public void setSharedMetricRegistries(SharedMetricRegistries sharedMetricRegistry) {
        sharedMetricRegistries = sharedMetricRegistry;
    }

    public void updateHttpMetrics(HttpStatAttributes httpStatAttributes, Duration duration) {
        if (sharedMetricRegistries == null) {
            return;
        }
        MetricRegistry vendorRegistry = sharedMetricRegistries.getOrCreate("vendor");
        Metadata md = new MetadataBuilder().withName("http.server.request.duration").withDescription("Duration of HTTP server requests.").build();
        String appName = this.getApplicationName();
        appName = appName == null ? NO_APP_NAME_IDENTIFIER : appName;
        String keyID = httpStatAttributes.getHttpStatID();
        Map attributesMap = appNameToTagsMap.computeIfAbsent(appName, x -> new ConcurrentHashMap());
        Tag[] tags = attributesMap.computeIfAbsent(keyID, x -> this.retrieveTags(httpStatAttributes));
        Timer httpTimer = vendorRegistry.timer(md, tags);
        httpTimer.update(duration);
    }

    private Tag[] retrieveTags(HttpStatAttributes httpStatAttributes) {
        Tag requestMethodTag = new Tag("http_request_method", httpStatAttributes.getRequestMethod());
        Tag urlSchemeTag = new Tag("url_scheme", httpStatAttributes.getScheme());
        int status = httpStatAttributes.getResponseStatus();
        Tag responseStatusTag = new Tag("http_response_status_code", status == -1 ? "" : Integer.toString(status));
        String httpRoute = httpStatAttributes.getHttpRoute();
        Tag httpRouteTag = new Tag("http_route", httpRoute == null ? "" : httpRoute);
        Tag networkProtocolVersionTag = new Tag("network_protocol_version", httpStatAttributes.getNetworkProtocolVersion());
        Tag serverNameTag = new Tag("server_address", httpStatAttributes.getServerName());
        Tag serverPortTag = new Tag("server_port", String.valueOf(httpStatAttributes.getServerPort()));
        String errorType = httpStatAttributes.getErrorType();
        Tag errorTypeTag = new Tag("error_type", errorType == null ? "" : errorType);
        Tag[] ret = new Tag[]{requestMethodTag, urlSchemeTag, responseStatusTag, httpRouteTag, networkProtocolVersionTag, serverNameTag, serverPortTag, errorTypeTag};
        return ret;
    }

    private String getApplicationName() {
        J2EEName name;
        ComponentMetaData metaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (metaData != null && (name = metaData.getJ2EEName()) != null) {
            return name.getApplication();
        }
        return null;
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        String appName = appInfo.getDeploymentName();
        Map<String, Tag[]> map = appNameToTagsMap.remove(appName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.format("Detected that application %s has stopped. Removed a corresponding Map<String, Attributes> entry? [%b]", appName, map != null), (Object[])new Object[0]);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        tc = Tr.register(MPMetricsHTTPMetricsAdapterImpl.class, null, null);
        appNameToTagsMap = new ConcurrentHashMap<String, Map<String, Tag[]>>();
    }
}

