/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.exceptions;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.oidcclientcore.utils.Utils;
import java.util.Date;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class StateTimestampException
extends Exception {
    public static final TraceComponent tc = Tr.register(StateTimestampException.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    private static final long serialVersionUID = 1L;
    private final String state;
    private final long timestampFromStateValue;
    private final long now;
    private final long minDate;
    private final long maxDate;

    public StateTimestampException(String state, long now, long minDate, long maxDate) {
        this.state = state;
        this.timestampFromStateValue = Utils.convertNormalizedTimeStampToLong(state);
        this.now = now;
        this.minDate = minDate;
        this.maxDate = maxDate;
    }

    private String getDateString(long date) {
        return new Date(date).toInstant().toString();
    }

    @Override
    public String getMessage() {
        return Tr.formatMessage((TraceComponent)tc, (String)"STATE_VALUE_IN_CALLBACK_OUTSIDE_ALLOWED_TIME_FRAME", (Object[])new Object[]{this.state, this.getDateString(this.timestampFromStateValue), this.getDateString(this.minDate), this.getDateString(this.maxDate), this.getDateString(this.now)});
    }
}

