/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.richclient.framework.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBufferPool;
import com.ibm.ws.sib.jfapchannel.framework.IOReadCompletedCallback;
import com.ibm.ws.sib.jfapchannel.framework.IOReadRequestContext;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.richclient.buffer.impl.RichByteBufferPool;
import com.ibm.ws.sib.jfapchannel.richclient.framework.impl.CFWIOBaseContext;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import java.io.IOException;
import java.util.Arrays;

public class CFWIOReadRequestContext
extends CFWIOBaseContext
implements IOReadRequestContext {
    private static final TraceComponent tc = SibTr.register(CFWIOReadRequestContext.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private TCPReadRequestContext readCtx = null;

    public CFWIOReadRequestContext(NetworkConnection conn, TCPReadRequestContext readCtx) {
        super(conn);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{conn, readCtx});
        }
        this.readCtx = readCtx;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public void setBuffer(WsByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBuffer", (Object)buffer);
        }
        if (buffer != null) {
            this.readCtx.setBuffer((com.ibm.wsspi.bytebuffer.WsByteBuffer)buffer.getUnderlyingBuffer());
        } else {
            this.readCtx.setBuffer(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBuffer");
        }
    }

    @Override
    public void setBuffers(WsByteBuffer[] buffers) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBuffers", (Object)Arrays.toString(buffers));
        }
        if (buffers != null) {
            com.ibm.wsspi.bytebuffer.WsByteBuffer[] tcpBuffers = new com.ibm.wsspi.bytebuffer.WsByteBuffer[buffers.length];
            for (int x = 0; x < buffers.length; ++x) {
                tcpBuffers[x] = (com.ibm.wsspi.bytebuffer.WsByteBuffer)buffers[x].getUnderlyingBuffer();
            }
            this.readCtx.setBuffers(tcpBuffers);
        } else {
            this.readCtx.setBuffers(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBuffers");
        }
    }

    @Override
    public WsByteBuffer getBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBuffer");
        }
        WsByteBuffer jfapByteBuffer = ((RichByteBufferPool)WsByteBufferPool.getInstance()).wrap(this.readCtx.getBuffer());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBuffer", (Object)jfapByteBuffer);
        }
        return jfapByteBuffer;
    }

    @Override
    public WsByteBuffer[] getBuffers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBuffers");
        }
        Object[] jfapByteBuffers = null;
        com.ibm.wsspi.bytebuffer.WsByteBuffer[] tcpBuffers = this.readCtx.getBuffers();
        if (tcpBuffers != null) {
            jfapByteBuffers = new WsByteBuffer[tcpBuffers.length];
            int nonNullCount = 0;
            for (int x = 0; x < tcpBuffers.length; ++x) {
                if (tcpBuffers[x] == null) continue;
                jfapByteBuffers[nonNullCount++] = ((RichByteBufferPool)WsByteBufferPool.getInstance()).wrap(tcpBuffers[x]);
            }
            if (nonNullCount < tcpBuffers.length) {
                WsByteBuffer[] compactedArray = new WsByteBuffer[nonNullCount];
                System.arraycopy(jfapByteBuffers, 0, compactedArray, 0, nonNullCount);
                jfapByteBuffers = compactedArray;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBuffers", (Object)Arrays.toString(jfapByteBuffers));
        }
        return jfapByteBuffers;
    }

    @Override
    public NetworkConnection read(int amountToRead, final IOReadCompletedCallback completionCallback, boolean forceQueue, int timeout) {
        VirtualConnection vc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"read", (Object)new Object[]{amountToRead, completionCallback, forceQueue, timeout});
        }
        NetworkConnection retConn = null;
        final CFWIOReadRequestContext me = this;
        TCPReadCompletedCallback callback = new TCPReadCompletedCallback(){

            public void complete(VirtualConnection vc, TCPReadRequestContext ctx) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"complete", (Object)new Object[]{vc, ctx});
                }
                completionCallback.complete(CFWIOReadRequestContext.this.getNetworkConnectionInstance(vc), me);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"complete");
                }
            }

            public void error(VirtualConnection vc, TCPReadRequestContext ctx, IOException ioException) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"error", (Object)new Object[]{vc, ctx, ioException});
                }
                completionCallback.error(CFWIOReadRequestContext.this.getNetworkConnectionInstance(vc), me, ioException);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"error");
                }
            }
        };
        if (timeout == -1) {
            timeout = -1;
        }
        if ((vc = this.readCtx.read((long)amountToRead, callback, forceQueue, timeout)) != null) {
            retConn = this.getNetworkConnectionInstance(vc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"read", (Object)retConn);
        }
        return retConn;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/jfapchannel/framework/impl/CFWIOReadRequestContext.java, SIB.comms, WASX.SIB, uu1215.01 1.4");
        }
    }
}

