/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.inbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.inputstream.HttpInputStreamConnectWeb;
import com.ibm.ws.http.channel.inputstream.HttpInputStreamObserver;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.http.channel.exception.IllegalHttpBodyException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.openliberty.http.netty.compression.HttpContentDecompressor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.zip.DataFormatException;

public class HttpInputStreamImpl
extends HttpInputStreamConnectWeb {
    private static final TraceComponent tc = Tr.register(HttpInputStreamImpl.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    protected HttpInboundServiceContext isc;
    protected WsByteBuffer buffer;
    private IOException error;
    protected boolean closed;
    protected long bytesRead;
    private long bytesToCaller;
    private boolean dataAlreadyReadFromChannel;
    private boolean enableMultiReadofPostData;
    private ArrayList<WsByteBuffer> postDataBuffer;
    protected boolean firstReadCompleteforMulti;
    private boolean readChannelComplete;
    private int postDataIndex;
    protected long bytesReadFromStore;
    private HttpInputStreamObserver obs;
    private FullHttpRequest nettyRequest;
    private ByteBuf nettyBody;

    public HttpInputStreamImpl(HttpInboundServiceContext context) {
        this.isc = null;
        this.buffer = null;
        this.error = null;
        this.closed = false;
        this.bytesRead = 0L;
        this.bytesToCaller = 0L;
        this.dataAlreadyReadFromChannel = false;
        this.enableMultiReadofPostData = false;
        this.firstReadCompleteforMulti = false;
        this.readChannelComplete = false;
        this.postDataIndex = 0;
        this.bytesReadFromStore = 0L;
        this.obs = null;
        this.nettyRequest = null;
        this.nettyBody = null;
        this.isc = context;
    }

    public HttpInputStreamImpl(HttpInboundServiceContext context, FullHttpRequest request) {
        block3: {
            this.isc = null;
            this.buffer = null;
            this.error = null;
            this.closed = false;
            this.bytesRead = 0L;
            this.bytesToCaller = 0L;
            this.dataAlreadyReadFromChannel = false;
            this.enableMultiReadofPostData = false;
            this.firstReadCompleteforMulti = false;
            this.readChannelComplete = false;
            this.postDataIndex = 0;
            this.bytesReadFromStore = 0L;
            this.obs = null;
            this.nettyRequest = null;
            this.nettyBody = null;
            this.isc = context;
            this.nettyRequest = request;
            this.nettyBody = this.nettyRequest.content();
            this.buffer = ChannelFrameworkFactory.getBufferManager().wrap(this.nettyBody.nioBuffer()).position(this.nettyBody.readerIndex());
            String contentEncoding = this.nettyRequest.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
            if (contentEncoding != null && this.isCompressed(contentEncoding)) {
                HttpChannelConfig config = ((HttpInboundServiceContextImpl)this.isc).getHttpConfig();
                HttpContentDecompressor decompressor = new HttpContentDecompressor();
                try {
                    this.buffer = decompressor.decompress(this.buffer, config, contentEncoding);
                }
                catch (DataFormatException dfe) {
                    FFDCFilter.processException((Throwable)dfe, (String)this.getClass().getName(), (String)"1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Received exception during decompress; " + dfe), (Object[])new Object[0]);
                }
            }
        }
        this.bytesRead += (long)this.buffer.remaining();
    }

    private boolean isCompressed(String encoding) {
        return "gzip".equalsIgnoreCase(encoding) || "deflate".equalsIgnoreCase(encoding);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.getClass().getSimpleName());
        sb.append('@').append(Integer.toHexString(this.hashCode()));
        sb.append(" closed=").append(this.closed);
        sb.append(" error=").append(this.error);
        sb.append(" received=").append(this.bytesRead);
        sb.append(" given=").append(this.bytesToCaller);
        sb.append(" buffer=").append(this.buffer);
        return sb.toString();
    }

    protected void validate() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Stream is closed");
        }
        if (null != this.error) {
            throw this.error;
        }
    }

    protected boolean checkBuffer() throws IOException {
        if (!this.enableMultiReadofPostData && !this.dataAlreadyReadFromChannel) {
            if (null != this.buffer) {
                if (this.buffer.hasRemaining()) {
                    return true;
                }
                this.buffer.release();
                this.buffer = null;
            }
            if (Objects.nonNull(this.nettyRequest)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"checkBuffer, No need to read from channel because in Netty we have everything from the request so returning false", (Object[])new Object[0]);
                }
                return false;
            }
            try {
                this.buffer = this.isc.getRequestBodyBuffer();
                if (null != this.buffer) {
                    this.bytesRead += (long)this.buffer.remaining();
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                this.error = e;
                throw e;
            }
        }
        return this.checkMultiReadBuffer();
    }

    private boolean checkMultiReadBuffer() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkMultiReadBuffer", (Object[])new Object[]{" firstReadCompleteforMulti [" + this.firstReadCompleteforMulti + "] " + this});
        }
        if (null != this.buffer) {
            if (this.buffer.hasRemaining()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkMultiReadBuffer Exit | return true ; has remaining ->" + this), (Object[])new Object[0]);
                }
                return true;
            }
            if (this.firstReadCompleteforMulti) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkMultiReadBuffer, buffer is completely read, ready this buffer for the subsequent read ->" + this), (Object[])new Object[0]);
                }
                this.postDataBuffer.get(this.postDataIndex).flip();
                ++this.postDataIndex;
            } else {
                this.buffer.release();
            }
            this.buffer = null;
        }
        if (this.firstReadCompleteforMulti) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkMultiReadBuffer ,index ->" + this.postDataIndex + " ,storage.size ->" + this.postDataBuffer.size()), (Object[])new Object[0]);
            }
            if (this.postDataBuffer.size() <= this.postDataIndex && !this.dataAlreadyReadFromChannel) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"checkMultiReadBuffer, requires more data, checking readRemainingFromChannel.", (Object[])new Object[0]);
                }
                this.readRemainingFromChannel();
            }
            if (this.postDataBuffer.size() > this.postDataIndex) {
                this.buffer = this.postDataBuffer.get(this.postDataIndex);
            }
            if (null != this.buffer) {
                this.bytesReadFromStore += (long)this.buffer.remaining();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkMultiReadBuffer Exit | bytes read from store [" + this.bytesReadFromStore + "] , return true" + this), (Object[])new Object[0]);
                }
                return true;
            }
        } else if (this.getBufferFromChannel()) {
            this.postDataBuffer.add(this.postDataIndex, this.buffer.duplicate());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkMultiReadBuffer, buffer ->" + this.postDataBuffer.get(this.postDataIndex) + " ,buffersize ->" + this.postDataBuffer.size() + " ,index ->" + this.postDataIndex), (Object[])new Object[0]);
            }
            ++this.postDataIndex;
            this.bytesRead += (long)this.buffer.remaining();
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("checkMultiReadBuffer:  no more buffer ->" + this), (Object[])new Object[0]);
        }
        return false;
    }

    private void readRemainingFromChannel() throws IOException {
        if (!this.readChannelComplete) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"readRemainingFromChannel, data not completely read during first read", (Object[])new Object[0]);
            }
            int localIx = this.postDataIndex;
            while (this.getBufferFromChannel()) {
                this.postDataBuffer.add(this.postDataIndex, this.buffer.duplicate());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("readRemainingFromChannel, buffer ->" + this.postDataBuffer.get(this.postDataIndex) + " ,size ->" + this.postDataBuffer.size() + " ,index ->" + this.postDataIndex), (Object[])new Object[0]);
                }
                ++this.postDataIndex;
                this.bytesRead += (long)this.buffer.remaining();
                this.buffer.release();
                this.buffer = null;
            }
            this.postDataIndex = localIx;
            this.readChannelComplete = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"readRemainingFromChannel, all buffer read and stored from channel , now read it from store", (Object[])new Object[0]);
            }
        }
    }

    private boolean getBufferFromChannel() throws IOException {
        try {
            this.buffer = this.isc.getRequestBodyBuffer();
            if (null != this.buffer) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getBufferFromChannel: new buffer from channel ->" + this), (Object[])new Object[0]);
                }
                return true;
            }
        }
        catch (IllegalHttpBodyException e) {
            this.error = e;
            throw e;
        }
        catch (IOException e) {
            this.error = e;
            throw e;
        }
        return false;
    }

    @Override
    public int available() throws IOException {
        this.validate();
        int rc = 0;
        if (null != this.buffer) {
            rc = this.buffer.remaining();
        } else if (!this.enableMultiReadofPostData && !this.dataAlreadyReadFromChannel) {
            rc = 0;
        } else {
            int localIndex = this.postDataIndex;
            WsByteBuffer localBuffer = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("available ,index ->" + this.postDataIndex + " ,storage.size ->" + this.postDataBuffer.size()), (Object[])new Object[0]);
            }
            while (this.postDataBuffer.size() > localIndex) {
                localBuffer = this.postDataBuffer.get(localIndex);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("available " + this + ", local position ->" + localBuffer.position()), (Object[])new Object[0]);
                }
                if (null == localBuffer) continue;
                ++localIndex;
                rc += localBuffer.remaining();
            }
            Object var3_3 = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("available: " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Closing stream: " + this), (Object[])new Object[0]);
        }
        if (!this.enableMultiReadofPostData) {
            if (this.dataAlreadyReadFromChannel) {
                this.cleanupforMultiRead();
            }
            if (null != this.buffer) {
                this.buffer.release();
                this.buffer = null;
            }
            this.validate();
        } else {
            if (null != this.buffer) {
                if (this.firstReadCompleteforMulti) {
                    this.buffer.rewind();
                } else {
                    this.buffer.release();
                }
                this.buffer = null;
            }
            this.validate();
            if (this.obs != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Alert for close , obs -->" + this.obs + " buffer ->" + this), (Object[])new Object[0]);
                }
                this.obs.alertISClose();
            }
            this.firstReadCompleteforMulti = true;
            this.postDataIndex = 0;
        }
        this.closed = true;
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Ignoring call to mark()", (Object[])new Object[0]);
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        this.validate();
        int rc = -1;
        if (this.checkBuffer()) {
            rc = this.buffer.get() & 0xFF;
            ++this.bytesToCaller;
        }
        return rc;
    }

    @Override
    public int read(byte[] output, int offset, int length) throws IOException {
        this.validate();
        if (0 == length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"read(byte[],int,int), target length was 0", (Object[])new Object[0]);
            }
            return 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"read(byte[],int,int)", (Object[])new Object[]{"length-->" + length + " , buffer->" + this});
        }
        if (!this.checkBuffer()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"read(byte[],int,int), EOF");
            }
            return -1;
        }
        int avail = this.buffer.remaining();
        int amount = length > avail ? avail : length;
        this.buffer.get(output, offset, amount);
        this.bytesToCaller += (long)amount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read(byte[],int,int)", (Object)this);
        }
        return amount;
    }

    @Override
    public int read(byte[] output) throws IOException {
        return this.read(output, 0, output.length);
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("Mark not supported");
    }

    @Override
    public long skip(long target) throws IOException {
        this.validate();
        long total = 0L;
        long remaining = target;
        while (total < target && this.checkBuffer()) {
            int avail = this.buffer.remaining();
            if ((long)avail > remaining) {
                this.buffer.position(this.buffer.position() + (int)remaining);
                total += remaining;
                continue;
            }
            this.buffer.release();
            this.buffer = null;
            total += (long)avail;
            remaining -= (long)avail;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("skip(" + target + ") rc=" + total), (Object[])new Object[0]);
        }
        this.bytesToCaller += total;
        return total;
    }

    @Override
    public void restart() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"restart", (Object[])new Object[]{"Start re-read of data"});
        }
        this.bytesToCaller = 0L;
        this.closed = false;
        if (this.obs != null) {
            this.obs.alertISOpen();
        }
    }

    public void setReadFromChannelComplete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setReadFromChannelComplete", (Object[])new Object[]{"Reseting indexes of data and setting all data read"});
        }
        this.enableMultiReadofPostData = false;
        this.dataAlreadyReadFromChannel = true;
        this.firstReadCompleteforMulti = true;
        this.bytesToCaller = 0L;
        this.postDataIndex = 0;
    }

    public void setupChannelMultiRead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setupChannelMultiRead", (Object[])new Object[]{"Adding everything necessary for reading from HTTP channel."});
        }
        this.enableMultiReadofPostData = true;
        this.postDataBuffer = new ArrayList();
        this.firstReadCompleteforMulti = false;
        this.dataAlreadyReadFromChannel = false;
    }

    @Override
    public void setISObserver(HttpInputStreamObserver obs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("obs  ->" + obs), (Object[])new Object[0]);
        }
        this.obs = obs;
    }

    @Override
    public void if_enableMultiReadofPostData_set(boolean set) {
        this.enableMultiReadofPostData = set;
    }

    @Override
    public void setupforMultiRead(boolean set) {
        this.enableMultiReadofPostData = set;
        if (this.enableMultiReadofPostData) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"init", (Object[])new Object[]{"create postData arrayList"});
            }
            this.postDataBuffer = new ArrayList();
            this.firstReadCompleteforMulti = false;
            this.readChannelComplete = false;
            this.dataAlreadyReadFromChannel = false;
            if (Objects.nonNull(this.nettyRequest)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Setting up Netty multiread!", (Object[])new Object[0]);
                }
                if (this.buffer == null) {
                    throw new UnsupportedOperationException("We should have data when working with Netty");
                }
                this.postDataBuffer.add(this.postDataIndex, this.buffer);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setupforMultiRead, Netty buffer ->" + this.postDataBuffer.get(this.postDataIndex) + " ,buffersize ->" + this.postDataBuffer.size() + " ,index ->" + this.postDataIndex), (Object[])new Object[0]);
                }
                this.postDataIndex = 0;
                this.firstReadCompleteforMulti = true;
                this.readChannelComplete = true;
            }
        }
    }

    @Override
    public void cleanupforMultiRead() {
        this.postDataIndex = 0;
        this.bytesReadFromStore = 0L;
        this.bytesRead = 0L;
        this.bytesToCaller = 0L;
        this.firstReadCompleteforMulti = false;
        this.dataAlreadyReadFromChannel = false;
        if (this.buffer != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"cleanupforMultiRead", (Object[])new Object[]{"remove buffer ->" + this.buffer});
            }
            this.buffer = null;
        }
        if (this.postDataBuffer != null) {
            for (WsByteBuffer postbuffer : this.postDataBuffer) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"cleanupforMultiRead", (Object[])new Object[]{"postbuffer released ->" + postbuffer});
                }
                postbuffer.release();
            }
            this.postDataBuffer = null;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"init", (Object[])new Object[]{"cleanupforMultiRead, postDataBuffer is not available"});
        }
    }
}

